
beaters = {}

function beaters.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function beaters:load(xmlFile)
    self.beatersanimation = {};
    self.beatersanimation.animCharSet = 0;
    self.beatersanimationEnabled = false;
    local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.beaters#rootNode"));
    if rootNode ~= nil then
        self.beatersanimation.animCharSet = getAnimCharacterSet(rootNode);
        if self.beatersanimation.animCharSet ~= 0 then
            self.beatersanimation.clip = getAnimClipIndex(self.beatersanimation.animCharSet, getXMLString(xmlFile, "vehicle.beaters#animationClip"));
            if self.beatersanimation.clip >= 0 then
                assignAnimTrackClip(self.beatersanimation.animCharSet, 0, self.beatersanimation.clip);
                setAnimTrackLoopState(self.beatersanimation.animCharSet, 0, true);
                setAnimTrackSpeedScale(self.beatersanimation.animCharSet, 0, 1);
            end;
        end;
    end;
end;

function beaters:delete()
end;

function beaters:update()
    if self.isTurnedOn then 
        enableAnimTrack(self.beatersanimation.animCharSet, 0);
    else
        disableAnimTrack(self.beatersanimation.animCharSet, 0);
        self.beatersanimationEnabled = false;
    end;
end;

function beaters:draw()
end;

function beaters:onEnter()
end;

function beaters:onLeave()
    if self.beatersanimationEnabled then
        disableAnimTrack(self.beatersanimation.animCharSet, 0);
        self.beatersanimationEnabled = false;
    end;
end;

function beaters:keyEvent(unicode, sym, modifier, isDown)
end;

function beaters:mouseEvent(posX, posY, isDown, isUp, button)
end;
