--
-- Kverneland 3132MT 
-- Specialization conditioning on a mower.
--
-- author  	Henly20 
-- date  	19-12-2010.
-- www.ls-uk.info
-- ALL RIGHTS RESERVED
  
acrobatWindrow_belt = {};
  
function acrobatWindrow_belt.prerequisitesPresent(specializations)
 	return true;
end;
  
function acrobatWindrow_belt:load(xmlFile)

local rotationPartNodecurtain = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartcurtain#index"));
    if rotationPartNodecurtain ~= nil then
        self.rotationPartcurtain = {};
        self.rotationPartcurtain.node = rotationPartNodecurtain;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartcurtain#minRot"));
        self.rotationPartcurtain.minRot = {};
        self.rotationPartcurtain.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartcurtain.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartcurtain.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartcurtain#maxRot"));
        self.rotationPartcurtain.maxRot = {};
        self.rotationPartcurtain.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartcurtain.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartcurtain.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartcurtain.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartcurtain#rotTime"), 2)*1000;
        self.rotationPartcurtain.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartcurtain#touchRotLimit"), 10));
    end;

      self.setWindrowOn = SpecializationUtil.callSpecializationsFunction("setWindrowOn");
 
      self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
      self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
      if self.groundReferenceNode == nil then
          self.groundReferenceNode = self.components[1].node;
      end;
  
      local numWindrowerDropAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.windrowerDropAreas#count"), 0);
      if numWindrowerDropAreas == 0 then
          print("Warning: No drop areas specified in '"..self.configFileName.."'");
      else
          if numWindrowerDropAreas ~= 1 and numWindrowerDropAreas ~= table.getn(self.cuttingAreas) then
              print("Warning: Number of cutting areas and drop areas should be equal in '"..self.configFileName.."'");
          end;
      end;
      self.windrowerDropAreas = {}
      for i=1, numWindrowerDropAreas do
          self.windrowerDropAreas[i] = {};
          local areanamei = string.format("vehicle.windrowerDropAreas.windrowerDropArea%d", i);
          self.windrowerDropAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
          self.windrowerDropAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
          self.windrowerDropAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
      end;

	  local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0)
	  self.accumulatedCuttingAreaValues = {}
	  self.accumulatedFruitType = FruitUtil.FRUITTYPE_UNKNOWN
	  for i = 1, numCuttingAreas do
		self.accumulatedCuttingAreaValues[i] = 0
	  end	  
	  
	  self.isWindrowOn = false;
  
      self.windrowerGroundFlag = self.nextDirtyFlag;
      self.nextDirtyFlag = self.windrowerGroundFlag*2;
	  
     -- self.grassParticleSystems = {};
   --   local i=0;
     -- while true do
       --   local baseName = string.format("vehicle.grassParticleSystems.grassParticleSystem(%d)", i);
  
  --        local particleSystem = {};
    --      particleSystem.ps = {};
      --    local ps = Utils.loadParticleSystem(xmlFile, particleSystem.ps, baseName, self.components, false, nil, self.baseDirectory)
        --  if ps == nil then
          --    break;
        --  end;
         -- particleSystem.disableTime = 0;
        --  particleSystem.isEnabled = false;
        --  table.insert(self.grassParticleSystems, particleSystem);
        --  i = i+1;
     -- end;
	  
      self.windrowParticleSystemFlag = self:getNextDirtyFlag();
end;
  
function acrobatWindrow_belt:delete()

  
end;
  
function acrobatWindrow_belt:mouseEvent(posX, posY, isDown, isUp, button)
end;
  
function acrobatWindrow_belt:keyEvent(unicode, sym, modifier, isDown)
end;
  
function acrobatWindrow_belt:readStream(streamId, connection)
      local isWindrowOn = streamReadBool(streamId);
      self:setWindrowOn(isWindrowOn, true);
end;
  
function acrobatWindrow_belt:writeStream(streamId, connection)
      streamWriteBool(streamId, self.isWindrowOn);
end;
  
function acrobatWindrow_belt:readUpdateStream(streamId, timestamp, connection)
      if connection:getIsServer() then
          local hasUpdate = streamReadBool(streamId);
         --    if hasUpdate then
        --      for k,v in ipairs(self.grassParticleSystems) do
          --        local enabled = streamReadBool(streamId);
            --      Utils.setEmittingState(v.ps, enabled);
           --   end;
        --  end;
      end;
end;
  
function acrobatWindrow_belt:writeUpdateStream(streamId, connection, dirtyMask)
     -- if not connection:getIsServer() then
       --   if bitAND(dirtyMask, self.windrowParticleSystemFlag) ~= 0 then
           --   streamWriteBool(streamId, true);
           --   for k,v in ipairs(self.grassParticleSystems) do
              --    streamWriteBool(streamId, v.isEnabled);
             -- end;
        --  else
         --     streamWriteBool(streamId, false);
       --   end;
     -- end;
end;
  
function acrobatWindrow_belt:update(dt)
  
      if self:getIsActiveForInput() then

			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				 self:setWindrowOn(not self.isWindrowOn);
				 -- self:setRotBody(not self.RotBody);

	 end;
    end;

end;
  
function acrobatWindrow_belt:updateTick(dt)
      if self:getIsActive() then

	  if self.isTurnedOn then	
          if self.isWindrowOn then		  
              if self.isServer and (not self.onlyActiveWhenLowered or self:isLowered(false)) then
                      local x,y,z = getWorldTranslation(self.groundReferenceNode);
                      local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
                      if terrainHeight+self.groundReferenceThreshold >= y then
                          local numDropAreas = table.getn(self.windrowerDropAreas);
                          local numAreas = table.getn(self.cuttingAreas);
                          if numDropAreas > 0 and numAreas > 0 then
                              local cuttingAreasSend = {};
                              local dropAreasSend = {};
                              for i=1, numAreas do
                                  local cuttingArea = self.cuttingAreas[i];
                                  if self:getIsAreaActive(cuttingArea) then
									  local x, _, z = getWorldTranslation(cuttingArea.start)
									  local x1, _, z1 = getWorldTranslation(cuttingArea.width)
									  local x2, _, z2 = getWorldTranslation(cuttingArea.height)
									  table.insert(cuttingAreasSend, {x, z, x1, z1, x2, z2})
                                  end;
                              end;
                              for i=1, numDropAreas do
                                  local dropArea = self.windrowerDropAreas[i];
                                  local dx,dy,dz = getWorldTranslation(dropArea.start);
                                  local dx1,dy1,dz1 = getWorldTranslation(dropArea.width);
                                  local dx2,dy2,dz2 = getWorldTranslation(dropArea.height);
                                  table.insert(dropAreasSend, {dx, dz, dx1, dz1, dx2, dz2});
                              end;
                              if table.getn(cuttingAreasSend) > 0 then
                                  local cuttingAreasSend, dropAreasSend, fruitType, bitType = WindrowAreaEvent.runLocally(cuttingAreasSend, dropAreasSend, self.accumulatedCuttingAreaValues, self.accumulatedFruitType);
									 if table.getn(cuttingAreasSend) > 0 or table.getn(dropAreasSend) > 0 then
									  self.accumulatedFruitType = fruitType
									  g_server:broadcastEvent(WindrowAreaEvent:new(cuttingAreasSend, dropAreasSend, fruitType, bitType))
									end           
                              end;
                          end;
                      end;

              end;
			--	if self.isServer then
			--		  for k,v in pairs(self.grassParticleSystems) do
			--			  if self.time > v.disableTime then
			--				  if v.isEnabled then
			--					  v.isEnabled = false;
			--					  self:raiseDirtyFlags(self.windrowParticleSystemFlag);
			--					  if self.isClient then
			--						  Utils.setEmittingState(v.ps, false);
			--					  end;
			--				  end;
						 -- end;
					--  end;
				-- end;
			end;
	end;
   end;
end;
  
function acrobatWindrow_belt:draw()
    if self.isClient then
		if self.isWindrowOn then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TEDDER"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
setRotation(self.rotationPartcurtain.node, 0, 0 ,0);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("WINDROWER"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
setRotation(self.rotationPartcurtain.node, 0, 0 ,-55);
		end;
	end;
end;
  
function acrobatWindrow_belt:onDetach()


end;
  
function acrobatWindrow_belt:onLeave()

	  self:setWindrowOn(false, true);

end;
  
function acrobatWindrow_belt:onDeactivate()

end;
  
function acrobatWindrow_belt:onDeactivateSounds()

end;
  
function acrobatWindrow_belt:setWindrowOn(isWindrowOn, noEventSend)
    SetWindrowOnEvent.sendEvent(self, isWindrowOn, noEventSend)
    self.isWindrowOn = isWindrowOn;
	if not isWindrowOn then
		for k,_ in pairs(self.accumulatedCuttingAreaValues) do
			self.accumulatedCuttingAreaValues[k] = 0
		end
	end;	
end;





--[[

SetWindrowOnEvent = {};
SetWindrowOnEvent_mt = Class(SetWindrowOnEvent, Event);
  
InitEventClass(SetWindrowOnEvent, "SetWindrowOnEvent");
  
function SetWindrowOnEvent:emptyNew()
     local self = Event:new(SetWindrowOnEvent_mt);
      self.className="SetWindrowOnEvent";
      return self;
end;
  
function SetWindrowOnEvent:new(object, WindrowOn)
      local self = SetWindrowOnEvent:emptyNew()
      self.object = object;
      self.WindrowOn = WindrowOn;
      return self;
end;
  
function SetWindrowOnEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.WindrowOn = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetWindrowOnEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.WindrowOn);
end;
  
function SetWindrowOnEvent:run(connection)
      if not connection:getIsServer() then
         g_server:broadcastEvent(self, false, connection, self.object);
      end;
      self.object:setWindrowOn(self.WindrowOn, true);
end;
  
function SetWindrowOnEvent.sendEvent(vehicle, WindrowOn, noEventSend)
      if WindrowOn ~= vehicle.isWindrowOn then
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetWindrowOnEvent:new(vehicle, WindrowOn), nil, nil, vehicle);
              else
                  g_client:getServerConnection():sendEvent(SetWindrowOnEvent:new(vehicle, WindrowOn));
              end;
          end;
      end;
end;

--]]