--
-- Kverneland 3132MT
-- Specialization conditioning on a mower.
--
-- author      Henly20
-- date      19-12-2010.
-- www.ls-uk.info
-- ALL RIGHTS RESERVED

acrobatWindrow = {};

function acrobatWindrow.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Tedder, specializations);
end;

function acrobatWindrow:load(xmlFile)
    self.setWindrowOn = SpecializationUtil.callSpecializationsFunction("setWindrowOn");

    --self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
    --self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
    --if self.groundReferenceNode == nil then
    --    self.groundReferenceNode = self.components[1].node;
    --end;

    local numWindrowerDropAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.windrowerDropAreas#count"), 0);
    if numWindrowerDropAreas == 0 then
        print("Warning: No drop areas specified in '"..self.configFileName.."'");
    else
        if numWindrowerDropAreas ~= 1 and numWindrowerDropAreas ~= table.getn(self.cuttingAreas) then
            print("Warning: Number of cutting areas and drop areas should be equal in '"..self.configFileName.."'");
        end;
    end;
    self.windrowerDropAreas = {}
    for i=1, numWindrowerDropAreas do
        self.windrowerDropAreas[i] = {};
        local areanamei = string.format("vehicle.windrowerDropAreas.windrowerDropArea%d", i);
        self.windrowerDropAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.windrowerDropAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.windrowerDropAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;

    --local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0)
    --self.accumulatedCuttingAreaValues = {}
    --for i = 1, numCuttingAreas do
    --  self.accumulatedCuttingAreaValues[i] = 0
    --end
    self.accumulatedFruitType = FruitUtil.FRUITTYPE_UNKNOWN;

    self.isWindrowOn = true;

    self.windrowerGroundFlag = self.nextDirtyFlag;
    self.nextDirtyFlag = self.windrowerGroundFlag*2;

    self.windrowParticleSystemFlag = self:getNextDirtyFlag();
end;

function acrobatWindrow:delete()
end;

function acrobatWindrow:mouseEvent(posX, posY, isDown, isUp, button)
end;

function acrobatWindrow:keyEvent(unicode, sym, modifier, isDown)
end;

function acrobatWindrow:readStream(streamId, connection)
    local isWindrowOn = streamReadBool(streamId);
    self:setWindrowOn(isWindrowOn, true);
end;

function acrobatWindrow:writeStream(streamId, connection)
    streamWriteBool(streamId, self.isWindrowOn);
end;

function acrobatWindrow:readUpdateStream(streamId, timestamp, connection)
end;

function acrobatWindrow:writeUpdateStream(streamId, connection, dirtyMask)
end;

function acrobatWindrow:update(dt)
end;

function acrobatWindrow:updateTick(dt)
    if self.isServer then
        if self.isTurnedOn and self.isWindrowOn then
            if self:getIsActive() and (not self.onlyActiveWhenLowered or self:isLowered(false)) then
                local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31; -- Same check as in Tedder.LUA
                if not toFast then
                    local x,y,z = getWorldTranslation(self.groundReferenceNode);
                    local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
                    if terrainHeight+self.groundReferenceThreshold >= y then
                        local numDropAreas = table.getn(self.windrowerDropAreas);
                        local numAreas = table.getn(self.cuttingAreas);
                        if numDropAreas > 0 and numAreas > 0 then
                            local cuttingAreasSend = {};
                            local dropAreasSend = {};
                            for i=1, numAreas do
                                local cuttingArea = self.cuttingAreas[i];
                                if self:getIsAreaActive(cuttingArea2) then
                                    local x, _, z = getWorldTranslation(cuttingArea.start)
                                    local x1, _, z1 = getWorldTranslation(cuttingArea.width)
                                    local x2, _, z2 = getWorldTranslation(cuttingArea.height)
                                    table.insert(cuttingAreasSend, {x, z, x1, z1, x2, z2})
                                end;
                            end;
                            for i=1, numDropAreas do
                                local dropArea = self.windrowerDropAreas[i];
                                local dx,dy,dz = getWorldTranslation(dropArea.start);
                                local dx1,dy1,dz1 = getWorldTranslation(dropArea.width);
                                local dx2,dy2,dz2 = getWorldTranslation(dropArea.height);
                                table.insert(dropAreasSend, {dx, dz, dx1, dz1, dx2, dz2});
                            end;
                            if table.getn(cuttingAreasSend) > 0 then
                                local cuttingAreasSend, dropAreasSend, fruitType, bitType = WindrowAreaEvent.runLocally(cuttingAreasSend, dropAreasSend, self.accumulatedCuttingAreaValues, self.accumulatedFruitType);
                                if table.getn(cuttingAreasSend) > 0 or table.getn(dropAreasSend) > 0 then
                                    self.accumulatedFruitType = fruitType
                                    g_server:broadcastEvent(WindrowAreaEvent:new(cuttingAreasSend, dropAreasSend, fruitType, bitType))
                                end;
                            end;
                        end;
                    end;
                end;
            end;
        else
            self.accumulatedFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
        end;
    end;
end;

function acrobatWindrow:draw()
end;

function acrobatWindrow:onDetach()
end;

function acrobatWindrow:onLeave()
    self:setWindrowOn(false, true);
end;

function acrobatWindrow:onDeactivate()
end;

function acrobatWindrow:onDeactivateSounds()
end;

function acrobatWindrow:setWindrowOn(isWindrowOn, noEventSend)
    SetWindrowOnEvent.sendEvent(self, isWindrowOn, noEventSend)
    self.isWindrowOn = isWindrowOn;
    if not isWindrowOn then
        for k,_ in pairs(self.accumulatedCuttingAreaValues) do
            self.accumulatedCuttingAreaValues[k] = 0
        end
    end;
end;

--------------------

SetWindrowOnEvent = {};
SetWindrowOnEvent_mt = Class(SetWindrowOnEvent, Event);

InitEventClass(SetWindrowOnEvent, "SetWindrowOnEvent");

function SetWindrowOnEvent:emptyNew()
    local self = Event:new(SetWindrowOnEvent_mt);
    self.className="SetWindrowOnEvent";
    return self;
end;

function SetWindrowOnEvent:new(object, WindrowOn)
    local self = SetWindrowOnEvent:emptyNew()
    self.object = object;
    self.WindrowOn = WindrowOn;
    return self;
end;

function SetWindrowOnEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.WindrowOn = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetWindrowOnEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteBool(streamId, self.WindrowOn);
end;

function SetWindrowOnEvent:run(connection)
    if not connection:getIsServer() then
       g_server:broadcastEvent(self, false, connection, self.object);
    end;
    self.object:setWindrowOn(self.WindrowOn, true);
end;

function SetWindrowOnEvent.sendEvent(vehicle, WindrowOn, noEventSend)
    if WindrowOn ~= vehicle.isWindrowOn then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(SetWindrowOnEvent:new(vehicle, WindrowOn), nil, nil, vehicle);
            else
                g_client:getServerConnection():sendEvent(SetWindrowOnEvent:new(vehicle, WindrowOn));
            end;
        end;
    end;
end;
