BomfordAreaEvent = {};
BomfordAreaEvent_mt = Class(BomfordAreaEvent, Event);
  
InitEventClass(BomfordAreaEvent, "BomfordAreaEvent");
  
function BomfordAreaEvent:emptyNew()
    local self = Event:new(BomfordAreaEvent_mt);
    self.className="BomfordAreaEvent";
    return self;
end;
  
function BomfordAreaEvent:new(cuttingAreas, fruitType, mode)
    local self = BomfordAreaEvent:emptyNew()
    self.cuttingAreas = cuttingAreas;
	self.fruitType = fruitType;
	self.mode = mode;
    return self;
end;
  
function BomfordAreaEvent:readStream(streamId, connection)
    local numAreas = streamReadUIntN(streamId, 4);
    local fruitType = streamReadInt8(streamId);
	local mode = streamReadInt8(streamId);
	local refX = streamReadFloat32(streamId);
    local refY = streamReadFloat32(streamId);
    local values = Utils.readCompressed2DVectors(streamId, refX, refY, numAreas*3-1, 0.01, true);
    for i=1,numAreas do
		local vi = i-1;
        local x = values[vi*3+1].x;
        local z = values[vi*3+1].y;
        local x1 = values[vi*3+2].x;
        local z1 = values[vi*3+2].y;
        local x2 = values[vi*3+3].x;
        local z2 = values[vi*3+3].y;
		Utils.updateMeadowArea(x, z, x1, z1, x2, z2, false);		
    end;
end;
   
function BomfordAreaEvent:writeStream(streamId, connection)
    local numAreas = table.getn(self.cuttingAreas);
    streamWriteUIntN(streamId, numAreas, 4);
    streamWriteInt8(streamId, self.fruitType);
	streamWriteInt8(streamId, self.mode);
	local refX, refY;
    local values = {};
    for i=1, numAreas do
        local d = self.cuttingAreas[i];
        if i==1 then
            refX = d[1];
            refY = d[2];
            streamWriteFloat32(streamId, d[1]);
            streamWriteFloat32(streamId, d[2]);
        else
            table.insert(values, {x=d[1], y=d[2]});
        end;
        table.insert(values, {x=d[3], y=d[4]});
        table.insert(values, {x=d[5], y=d[6]});
    end;
    assert(table.getn(values) == numAreas*3 - 1);
    Utils.writeCompressed2DVectors(streamId, refX, refY, values, 0.01);
end;
  
function BomfordAreaEvent:run(connection)
    print("Error: Do not run BomfordAreaEvent locally");
end;
 
function BomfordAreaEvent.runLocally(cuttingAreas, fruitType, mode)
    local totalArea =0;         
    local numAreas = table.getn(cuttingAreas);
    local refX, refY;
    local values = {};
    for i=1, numAreas do
        local d = cuttingAreas[i];
        if i==1 then
            refX = d[1];
            refY = d[2];
        else
            table.insert(values, {x=d[1], y=d[2]});
        end;
        table.insert(values, {x=d[3], y=d[4]});
        table.insert(values, {x=d[5], y=d[6]});
    end;
    assert(table.getn(values) == numAreas*3 - 1);
 
    local values = Utils.simWriteCompressed2DVectors(refX, refY, values, 0.01, true);
 
    for i=1, numAreas do
        local vi = i-1;
        local x = values[vi*3+1].x;
        local z = values[vi*3+1].y;
        local x1 = values[vi*3+2].x;
        local z1 = values[vi*3+2].y;
        local x2 = values[vi*3+3].x;
        local z2 = values[vi*3+3].y;
		local area = Utils.updateMeadowArea(x, z, x1, z1, x2, z2, false);			
        -- local area = Utils.updateMeadowArea(x, z, x1, z1, x2, z2);		
        area = area + Utils.updateMeadowArea(x, z, x1, z1, x2, z2, false);
        if area > 0 then
  			totalArea = totalArea+area;
        end;
	    return totalArea;	
    end;
end;
