--
-- Shop Categories MoreRealistic
-- Moves MoreRealistic mods and DLCs into separate main categories in the shop
--
-- @author: Jakob Tischler
-- @version: 0.3
-- @date: 15 Jun 2014
-- @history: 0.2:  (01 Apr 2014) initial release
--           0.3:  (15 Jun 2014) * inhibit multiple code executions in 2nd, 3rd, ... savegame load
--                               * add separate category for MoreRealisticDLCs
--
-- Copyright (C) 2014 Jakob Tischler

--[[
TODO: find a better way to get from storeItem to vehicleType
]]
------------------------------------

ShopCategoriesMoreRealistic = {
	modDir = g_currentModDirectory;
	modName = g_currentModName;
}
addModEventListener(ShopCategoriesMoreRealistic);

function ShopCategoriesMoreRealistic:loadMap(name)
	if self.initialized then return; end;


	-- DETERMINE IF VEHICLE IS MR
	local modsDirLen = g_modsDirectory:len();
	local realisticVehicleSpec = SpecializationUtil.getSpecialization('realisticVehicle');
	for i,item in ipairs(StoreItemsUtil.storeItems) do
		item.isMR = false;

		-- CHECK IF DLC IS MR
		if not item.isMod and item.isMoreRealisticDLC then
			item.isMR = true;

		-- CHECK IF MOD IS MR
		elseif item.isMod then
			local isMR = false;
			if fileExists(item.xmlFilename) then
				local xmlFile = loadXMLFile('tmpXML', item.xmlFilename);
				local typeName = getXMLString(xmlFile, 'vehicle#type');
				delete(xmlFile);
				if typeName then
					-- CHECK 1: typeName starts with 'moreRealistic'
					if Utils.startsWith(typeName:lower(), 'morerealistic') then
						isMR = true;
					-- CHECK 2: typeName starts with 'mr'
					elseif Utils.startsWith(typeName:lower(), 'mr') then
						isMR = true;
					else
						local custEnv = item.xmlFilename:sub(modsDirLen + 2, item.xmlFilename:len());
						-- CHECK 3: mod filename starts with 'mr'
						if Utils.startsWith(custEnv:lower(), 'mr') then
							isMR = true;
						else
							custEnv = Utils.splitString('/', custEnv)[1];
							local vehicleType = custEnv .. '.' .. typeName;
							-- CHECK 4: vehicleType has 'realisticVehicle' specialization
							if VehicleTypeUtil.vehicleTypes[vehicleType] and Utils.hasListElement(VehicleTypeUtil.vehicleTypes[vehicleType].specializations, realisticVehicleSpec) then
								isMR = true;
							end;
						end;
					end;
				end;
			end;

			-- CHECK 5: store item name starts with 'MR '
			if not isMR and item.name then
				isMR = Utils.startsWith(item.name:lower(), 'mr ');
			end;

			item.isMR = isMR;
		end;
	end;


	-- ############################################################ --


	local tableCopy = function(tab, recursive)
		local result = {};
		for k,v in pairs(tab) do
			if recursive and type(v) == 'table' then
				result[k] = tableCopy(v, recursive);
			else
				result[k] = v;
			end;
		end;
		return result;
	end;

	-- (1) CREATE NEW MR CATEGORIES
	ShopScreen.CATEGORY_MR_MACHINE_TYPES 	  = ShopScreen.CATEGORY_MACHINE_TYPES 		  + 1; -- NEW
	ShopScreen.CATEGORY_BRANDS 				  = ShopScreen.CATEGORY_MR_MACHINE_TYPES 	  + 1;
	ShopScreen.CATEGORY_ANIMALS 			  = ShopScreen.CATEGORY_BRANDS 				  + 1;
	ShopScreen.CATEGORY_PLACEABLES 			  = ShopScreen.CATEGORY_ANIMALS 			  + 1;
	ShopScreen.CATEGORY_MODS_MACHINE_TYPES 	  = ShopScreen.CATEGORY_PLACEABLES 			  + 1;
	ShopScreen.CATEGORY_MODS_MR_MACHINE_TYPES = ShopScreen.CATEGORY_MODS_MACHINE_TYPES 	  + 1; -- NEW
	ShopScreen.CATEGORY_MODS_BRANDS 		  = ShopScreen.CATEGORY_MODS_MR_MACHINE_TYPES + 1;
	ShopScreen.CATEGORY_MODS_PLACEABLES 	  = ShopScreen.CATEGORY_MODS_BRANDS 		  + 1;
	ShopScreen.CATEGORY_SALES 				  = ShopScreen.CATEGORY_MODS_PLACEABLES 	  + 1;
	ShopScreen.CATEGORY_OWNED 				  = ShopScreen.CATEGORY_SALES 				  + 1;

	------------------------------------------------------------

	-- (2) ADD TO CAT NAMES LIST AT CORRECT POSITION
	-- DLC MR
	table.insert(g_shopScreen.categoryList, ShopScreen.CATEGORY_MR_MACHINE_TYPES, 'category_machineTypeMR');
	g_i18n.globalI18N.texts.category_machineTypeMR = g_i18n:getText('category_machineType') .. ' (MR)';

	-- MODS MR
	table.insert(g_shopScreen.categoryList, ShopScreen.CATEGORY_MODS_MR_MACHINE_TYPES, 'category_modsMachineTypeMR');
	g_i18n.globalI18N.texts.category_modsMachineTypeMR = g_i18n:getText('category_modsMachineType') .. ' (MR)';

	------------------------------------------------------------

	-- (3) ADD TO CAT LIST AT CORRECT POSITION
	-- DLC MR
	local defaultSubCategoryList = tableCopy(g_shopScreen.subCategoryList[ShopScreen.CATEGORY_MACHINE_TYPES]);
	table.insert(g_shopScreen.subCategoryList, ShopScreen.CATEGORY_MR_MACHINE_TYPES, defaultSubCategoryList);

	-- MODS MR
	local modSubCategoryList = tableCopy(g_shopScreen.subCategoryList[ShopScreen.CATEGORY_MODS_MACHINE_TYPES]);
	table.insert(g_shopScreen.subCategoryList, ShopScreen.CATEGORY_MODS_MR_MACHINE_TYPES, modSubCategoryList);

	------------------------------------------------------------

	-- (4) UPDATE SELECTION ELEMENTS
	g_shopScreen:categorySelectionOnCreate(g_shopScreen.categorySelectionElement);
	g_shopScreen:subCategorySelectionOnCreate(g_shopScreen.subCategorySelectionElement);


	-- ############################################################ --


	-- DISPLAY MR MODS SEPARATELY IN SHOP
	local updateMrModsMachineTypeSubCategoryList = function(self) -- GET SUBCATEGORY LIST FROM DEFAULT MODS CATEGORY
		self.subCategoryList[ShopScreen.CATEGORY_MODS_MR_MACHINE_TYPES] = tableCopy(self.subCategoryList[ShopScreen.CATEGORY_MODS_MACHINE_TYPES], true);
	end;
	ShopScreen.updateModsMachineTypeSubCategoryList = Utils.appendedFunction(ShopScreen.updateModsMachineTypeSubCategoryList, updateMrModsMachineTypeSubCategoryList);

	local updateShopItemListOrig = ShopScreen.updateShopItemList;
	function ShopScreen.updateShopItemList(self)
		local catIsDefault, catIsDefaultMR = self.selectedCategory == ShopScreen.CATEGORY_MACHINE_TYPES, self.selectedCategory == ShopScreen.CATEGORY_MR_MACHINE_TYPES;
		local catIsMods, catIsModsMR = self.selectedCategory == ShopScreen.CATEGORY_MODS_MACHINE_TYPES, self.selectedCategory == ShopScreen.CATEGORY_MODS_MR_MACHINE_TYPES;

		if catIsDefault or catIsDefaultMR or catIsMods or catIsModsMR then
			self.shopItemList:deleteListItems();
			self.currentStoreItemsList = {};
			for i=1, #StoreItemsUtil.storeItems do
				self.currentItem = StoreItemsUtil.storeItems[i];
				local isMod = self.currentItem.isMod;
				local isMR = self.currentItem.isMR or self.currentItem.isMoreRealisticDLC;

				if ((not isMod and catIsDefault and not isMR) or -- default, non-MR
					(not isMod and catIsDefaultMR and isMR) or -- default, MR
					(isMod and catIsMods and not isMR) or -- mod, non-MR
					(isMod and catIsModsMR and isMR)) and -- mod, MR
					self.subCategoryList[self.selectedCategory][self.selectedSubCategory] == 'subCategory_' .. self.currentItem.machineType
				then
					local li = self.listItemTemplate:clone(self.shopItemList):updateAbsolutePosition();
					self.currentStoreItemsList[#self.currentStoreItemsList + 1] = self.currentItem;
				end;
			end;
			self.currentItem = nil;

		else
			updateShopItemListOrig(self);
		end;
	end;

	self.initialized = true;

	local modItem = ModsUtil.findModItemByModName(ShopCategoriesMoreRealistic.modName);
	if modItem and modItem.version and modItem.author then
		print(('### Shop categories MoreRealistic v%s by %s loaded'):format(modItem.version, modItem.author));
	else
		print('### Shop categories MoreRealistic loaded');
	end;
end;

function ShopCategoriesMoreRealistic:deleteMap() end;
function ShopCategoriesMoreRealistic:keyEvent(unicode, sym, modifier, isDown) end;
function ShopCategoriesMoreRealistic:update(dt) end;
function ShopCategoriesMoreRealistic:updateTick(dt) end;
function ShopCategoriesMoreRealistic:draw() end;
function ShopCategoriesMoreRealistic:mouseEvent(posX, posY, isDown, isUp, mouseButton) end;
