SetAdapterEvent = {};
SetAdapterEvent_mt = Class(SetAdapterEvent, Event);

InitEventClass(SetAdapterEvent, "SetAdapterEvent");

function SetAdapterEvent:emptyNew()
    local self = Event:new(SetAdapterEvent_mt);
    self.className="SetAdapterEvent";
    return self;
end;

function SetAdapterEvent:new(vehicle, adapterState)
    local self = SetAdapterEvent:emptyNew()
    self.vehicle = vehicle;
	self.adapterState = adapterState;
    return self;
end;

function SetAdapterEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.adapterState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetAdapterEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.adapterState);
end;

function SetAdapterEvent:run(connection)   
	self.vehicle:toggleAdapter(self.adapterState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetAdapterEvent:new(self.vehicle, self.adapterState), nil, connection, self.vehicle);
    end;
end;

function SetAdapterEvent.sendEvent(vehicle, adapterState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetAdapterEvent:new(vehicle, adapterState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetAdapterEvent:new(vehicle, adapterState));
		end;
	end;
end;