--
-- epareuse
-- 
--
-- @poc@lypse


epareuse = {};


function epareuse.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function epareuse:load(xmlFile)
	
  
    self.dustParticleSystems = {};
    local dustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems#count"), 0);
    for i=1, dustParticleSystemCount do
        local namei = string.format("vehicle.dustParticleSystems.part%d", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems, namei, nodei, false, nil, self.baseDirectory)			
    end;

local mowerSound = getXMLString(xmlFile, "vehicle.mowerSound#file");
    if mowerSound ~= nil and mowerSound ~= "" then
        mowerSound = Utils.getFilename(mowerSound, self.baseDirectory); 
        self.mowerSound = createSample("mowerSound");
        self.mowerSoundEnabled = false;
        loadSample(self.mowerSound, mowerSound, false);
        self.mowerSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#pitchOffset"), 1);
        self.mowerSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#volume"), 1);
    end;   

    local hidraulicSound = getXMLString(xmlFile, "vehicle.hidraulicSound#file");
    if hidraulicSound ~= nil and hidraulicSound ~= "" then
        hidraulicSound = Utils.getFilename(hidraulicSound, self.baseDirectory); 
        self.hidraulicSound = createSample("hidraulicSound");
        loadSample(self.hidraulicSound, hidraulicSound, false);
        self.hidraulicSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hidraulicSound#pitchOffset"), 1);
        self.hidraulicSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hidraulicSound#pitchScale"), 0);
        self.hidraulicSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hidraulicSound#pitchMax"), 2.0);
    end;

    local rotationPartNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart#index"));
    if rotationPartNode ~= nil then
        self.rotationPart = {};
        self.rotationPart.node = rotationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart#minRot"));
        self.rotationPart.minRot = {};
        self.rotationPart.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart#maxRot"));
        self.rotationPart.maxRot = {};
        self.rotationPart.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart#rotTime"), 2)*1000;
        self.rotationPart.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart#touchRotLimit"), 10));
        self.rotationPart.pivotverin = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart#pivotverin"));
    end;

    local rotationPartNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart1#index"));
    if rotationPartNode1 ~= nil then
        self.rotationPart1 = {};
        self.rotationPart1.node = rotationPartNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#minRot"));
        self.rotationPart1.minRot = {};
        self.rotationPart1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#maxRot"));
        self.rotationPart1.maxRot = {};
        self.rotationPart1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#rotTime"), 2)*1000;
        self.rotationPart1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#touchRotLimit"), 10));
        self.rotationPart1.pivotverin = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart1#pivotverin"));
    end;

        local rotationPartNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart2#index"));
    if rotationPartNode2 ~= nil then
        self.rotationPart2 = {};
        self.rotationPart2.node = rotationPartNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#minRot"));
        self.rotationPart2.minRot = {};
        self.rotationPart2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#maxRot"));
        self.rotationPart2.maxRot = {};
        self.rotationPart2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#rotTime"), 2)*1000;
        self.rotationPart2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#touchRotLimit"), 10));
        self.rotationPart2.pivotverin = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart2#pivotverin"));
    end;

           local rotationPartNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart3#index"));
    if rotationPartNode3 ~= nil then
        self.rotationPart3 = {};
        self.rotationPart3.node = rotationPartNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#minRot"));
        self.rotationPart3.minRot = {};
        self.rotationPart3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#maxRot"));
        self.rotationPart3.maxRot = {};
        self.rotationPart3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#rotTime"), 2)*1000;
        self.rotationPart3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#touchRotLimit"), 10));
      end;

        local rotationPartNode4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart4#index"));
    if rotationPartNode4 ~= nil then
        self.rotationPart4 = {};
        self.rotationPart4.node = rotationPartNode4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#minRot"));
        self.rotationPart4.minRot = {};
        self.rotationPart4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#maxRot"));
        self.rotationPart4.maxRot = {};
        self.rotationPart4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#rotTime"), 2)*1000;
        self.rotationPart4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#touchRotLimit"), 10));
end;
       local rotationPartNode5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart5#index"));
    if rotationPartNode5 ~= nil then
        self.rotationPart5 = {};
        self.rotationPart5.node = rotationPartNode5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart5#minRot"));
        self.rotationPart5.minRot = {};
        self.rotationPart5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart5#maxRot"));
        self.rotationPart5.maxRot = {};
        self.rotationPart5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart5#rotTime"), 2)*1000;
        self.rotationPart5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart5#touchRotLimit"), 10));
 end;
       self.drumNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drum#index1"));
         self.drumRotationScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drum#rotationScale"), 1);

       self.verin = {};
	self.verin.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.verin#indexverin"));
	self.verin.tige = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.verin#indextige"));
	self.verin.translationtige = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.verin#translationtige"));
	local ax, ay, az = getWorldTranslation(self.verin.tige);
    local bx, by, bz = getWorldTranslation(self.verin.translationtige);
    self.verin.tigeDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
   


     self.verin1 = {};
	self.verin1.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.verin1#indexverin"));
	self.verin1.tige = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.verin1#indextige"));
	self.verin1.translationtige = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.verin1#translationtige"));
	local ax, ay, az = getWorldTranslation(self.verin1.tige);
    local bx, by, bz = getWorldTranslation(self.verin1.translationtige);
    self.verin1.tigeDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
    
     self.verin2 = {};
	self.verin2.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.verin2#indexverin"));
	self.verin2.tige = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.verin2#indextige"));
	self.verin2.translationtige = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.verin2#translationtige"));
	local ax, ay, az = getWorldTranslation(self.verin2.tige);
    local bx, by, bz = getWorldTranslation(self.verin2.translationtige);
    self.verin2.tigeDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);

    
    
   self.isActive = false;
  
   

   self.time = 0;
   self.groundCheck = {};
   self.groundCheck = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundCheck#index"));
   

   
end;


function epareuse:delete()   
   Utils.setEmittingState(self.particleSystems,false)  
 if self.mowerSoundEnabled then
       stopSample(self.mowerSound);
        self.mowerSoundEnabled = false;
    end;
  	 if self.hidraulicSound ~= nil then
        delete(self.hidraulicSound);
    end;
end;

function epareuse:mouseEvent(posX, posY, isDown, isUp, button)
   
end;

function epareuse:keyEvent(unicode, sym, modifier, isDown)
  
    if sym == Input.KEY_KP_4 then
		self.rotationMax1 = isDown; 
        self.playHidraulic = not self.playHidraulic;
	end;
    if sym == Input.KEY_KP_7 then
		self.rotationMin1 = isDown;
     self.playHidraulic1 = not self.playHidraulic1;
	end;

     if sym == Input.KEY_KP_2 then
		self.rotationMax = isDown;
         self.playHidraulic2 = not self.playHidraulic2;
	end;
    if sym == Input.KEY_KP_1 then
		self.rotationMin = isDown;
          self.playHidraulic3 = not self.playHidraulic3;
	end;
 
   if sym == Input.KEY_KP_8 then
		self.rotationMax2 = isDown;
          self.playHidraulic4 = not self.playHidraulic4;
	end;
    if sym == Input.KEY_KP_5 then
		self.rotationMin2 = isDown;
          self.playHidraulic5 = not self.playHidraulic5;
	end;

   if sym == Input.KEY_KP_9 then
		self.rotationMax3 = isDown;
           self.playHidraulic6 = not self.playHidraulic6;
	end;
    if sym == Input.KEY_KP_6 then
		self.rotationMin3 = isDown;
           self.playHidraulic7 = not self.playHidraulic7;
	end;
    if isDown and sym == Input.KEY_b then
		self.isTurnedOn = not self.isTurnedOn;
	end;
   
   
    if isDown and sym == Input.KEY_n then
		self.rotationMax4 = not self.rotationMax4;
                self.rotationMax5 = not self.rotationMax5;
	end;
end;

function epareuse:update(dt)
 if self.attacherVehicle then
	
	
	if self.isTurnedOn then	
			
			local x,y,z = getWorldTranslation(self.groundCheck);
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
			local gC = y-terrainHeight; 
		
			if (math.min(gC) < 0.5) then
			  self.go = true;
			else
			  self.go = false;
			end;	
			
	   if  self.go	  then
		Utils.setEmittingState(self.dustParticleSystems, true)
		Utils.setEmittingState(self.particleSystems, true);
	   else
		Utils.setEmittingState(self.particleSystems, false);
		Utils.setEmittingState(self.dustParticleSystems, false)
	   end;
		
			
	if self.drumNode1 ~= nil then
				rotate(self.drumNode1, self.drumRotationScale * 20 * 1, 0, 0);
	end;
			if self.go then
		           if table.getn(self.cuttingAreas) > 0 then
				local x,y,z = getWorldTranslation(self.cuttingAreas[1].start);
				local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[1].width);
				local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[1].height);
				Utils.cutFruitArea( 1, x1, z2, x1, z1, x2, z2);
				Utils.cutFruitArea( 2, x1, z2, x1, z1, x2, z2);
				Utils.cutFruitArea( 3, x1, z2, x1, z1, x2, z2);
				Utils.cutFruitArea( 4, x1, z2, x1, z1, x2, z2);
				Utils.updateMeadowArea(x1, z2, x1, z1, x2, z2);
				Utils.updateCuttedMeadowArea(x1, z2, x1, z1, x2, z2);
			  end;
			end;
		if not self.mowerSoundRunning then
                print("start");
                playSample(self.mowerSound, 0, 1.6, 0);
                self.mowerSoundRunning = true;				
		end;	
	else
	
	   if self.mowerSoundRunning then
                print("end");
                stopSample(self.mowerSound, 0, 1.6, 0);
                self.mowerSoundRunning = false;
		
	  end;	
	end;	
end;
	if (not self.isTurnedOn) then	
		Utils.setEmittingState(self.particleSystems, false);
			Utils.setEmittingState(self.dustParticleSystems, false)
	end;

if (not self.isTurnedOn) then	
		Utils.setEmittingState(self.particleSystems, false);
			Utils.setEmittingState(self.dustParticleSystems, false)
	end;
	if self.playHidraulic or self.playHidraulic1 or self.playHidraulic2 or self.playHidraulic3 or self.playHidraulic4 or self.playHidraulic5 or self.playHidraulic6 or self.playHidraulic7 then
            if self.hidraulicSound ~= nil and not self.hidraulicSoundEnabled then
                if self:getIsActiveForSound() then
                    setSamplePitch(self.hidraulicSound, self.hidraulicSoundPitchOffset);
                    playSample(self.hidraulicSound, 0, 0.5, 0);
                    self.hidraulicSoundEnabled = true;
                end;
            end;
     
		
     else
            if self.hidraulicSound ~= nil and self.hidraulicSoundEnabled then
                stopSample(self.hidraulicSound);
                self.hidraulicSoundEnabled = false;
            end;
     
	end;



    if self.rotationPart ~= nil and (self.rotationMax or self.rotationMin) then
          local x, y, z = getRotation(self.rotationPart.node);
          local rot = {x,y,z};
          local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart.maxRot, self.rotationPart.minRot, 3, self.rotationPart.rotTime, dt, not self.rotationMax);
          setRotation(self.rotationPart.node, unpack(newRot));
    end;

     if self.rotationPart1 ~= nil and (self.rotationMax1 or self.rotationMin1) then
          local x, y, z = getRotation(self.rotationPart1.node);
          local rot = {x,y,z};
          local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart1.maxRot, self.rotationPart1.minRot, 3, self.rotationPart1.rotTime, dt, not self.rotationMax1);
          setRotation(self.rotationPart1.node, unpack(newRot));
    end;

     if self.rotationPart2 ~= nil and (self.rotationMax2 or self.rotationMin2) then
          local x, y, z = getRotation(self.rotationPart2.node);
          local rot = {x,y,z};
          local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart2.maxRot, self.rotationPart2.minRot, 3, self.rotationPart2.rotTime, dt, not self.rotationMax2);
          setRotation(self.rotationPart2.node, unpack(newRot));
    end;

    
      if self.rotationPart3 ~= nil and (self.rotationMax3 or self.rotationMin3) then
          local x, y, z = getRotation(self.rotationPart3.node);
          local rot = {x,y,z};
          local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart3.maxRot, self.rotationPart3.minRot, 3, self.rotationPart3.rotTime, dt, not self.rotationMax3);
          setRotation(self.rotationPart3.node, unpack(newRot));
    end;

    if self.rotationPart4 ~= nil then
          local x, y, z = getRotation(self.rotationPart4.node);
          local rot = {x,y,z};
          local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart4.maxRot, self.rotationPart4.minRot, 3, self.rotationPart4.rotTime, dt, not self.rotationMax4);
          setRotation(self.rotationPart4.node, unpack(newRot));
    end;

    if self.rotationPart5 ~= nil then
          local x, y, z = getRotation(self.rotationPart5.node);
          local rot = {x,y,z};
          local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart5.maxRot, self.rotationPart5.minRot, 3, self.rotationPart5.rotTime, dt, not self.rotationMax5);
          setRotation(self.rotationPart5.node, unpack(newRot));
    end;


     if self.verin ~= nil and self.rotationPart ~= nil then
		local ax, ay, az = getWorldTranslation(self.verin.node);
		local bx, by, bz = getWorldTranslation(self.rotationPart.pivotverin);
		local x, y, z = worldDirectionToLocal(getParent(self.verin.node), bx-ax, by-ay, bz-az);
		setDirection(self.verin.node, x, y, z, 0, 1, 0);
		if self.verin.tige ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.verin.tige, 0, (distance-self.verin.tigeDistance), 0);
		end;
	end;

    if self.verin1 ~= nil and self.rotationPart1 ~= nil then
		local ax, ay, az = getWorldTranslation(self.verin1.node);
		local bx, by, bz = getWorldTranslation(self.rotationPart1.pivotverin);
		local x, y, z = worldDirectionToLocal(getParent(self.verin1.node), bx-ax, by-ay, bz-az);
		setDirection(self.verin1.node, x, y, z, 0, 1, 0);
		if self.verin1.tige ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.verin1.tige, 0, (distance-self.verin1.tigeDistance), 0);
		end;
	end;

   if self.verin2 ~= nil and self.rotationPart2 ~= nil then
		local ax, ay, az = getWorldTranslation(self.verin2.node);
		local bx, by, bz = getWorldTranslation(self.rotationPart2.pivotverin);
		local x, y, z = worldDirectionToLocal(getParent(self.verin2.node), bx-ax, by-ay, bz-az);
		setDirection(self.verin2.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.verin2.tige ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.verin2.tige, 0, (distance-self.verin2.tigeDistance), 0);
		end;
	end;
   
                local joint = self.componentJoints[1];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
		local joint = self.componentJoints[2];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
		local joint = self.componentJoints[3];

end;

function epareuse:draw()
 
    g_currentMission:addExtraPrintText("Touche KP_1/KP_2: Rotation base");
  g_currentMission:addExtraPrintText("Touche KP_7/KP_4: Rotation premier bras");
  g_currentMission:addExtraPrintText("Touche KP_8/KP_5: Rotation deuxieme bras");   
  g_currentMission:addExtraPrintText("Touche KP_9/KP_6: Rotation coupe");
  g_currentMission:addExtraPrintText("Touche N: Enlever/mettre les bequilles");
  g_currentMission:addExtraPrintText("Touche B: Demarrer/arreter le rotor");       
   
end;


function epareuse:onDetach()
  self.isTurnedOn = false;
	 stopSample(self.mowerSound);
        self.mowerSoundEnabled = false;   
end;



function epareuse:onDeactivateSounds()
    if self.hidraulicSound ~= nil and self.hidraulicSoundEnabled then
        stopSample(self.hidraulicSound);
        self.hidraulicSoundEnabled = false;
    end;
   if self.mowerSoundRunning then
                print("end");
                stopSample(self.mowerSound, 0, 1.6, 0);
                self.mowerSoundRunning = false;
			end;
end;