--
-- Hidraulic
--
-- @autor  Andrei Valentin
-- 

Hidraulic = {};

function Hidraulic.prerequisitesPresent(specializations)
    return true;
end;

function Hidraulic:load(xmlFile)
	self.HidraulicCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Hidraulic#count"), 0);	
	if self.HidraulicCount == 0 then
        print("Error: No Hidraulic specified - Count: 0", configFile);
    end;
	
	self.Hidraulic = {};	
	for i=1, self.HidraulicCount do
		local HidraulicName = string.format("vehicle.Hidraulic.Hidraulic%d", i);
		
		self.Hidraulic[i] = {};		
		self.Hidraulic[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, HidraulicName .. "#Hidraulic"));
		self.Hidraulic[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, HidraulicName .. "#HidraulicPunch"));
		self.Hidraulic[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, HidraulicName .. "#HidraulicPunchFixPoint"));
		self.Hidraulic[i].FixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, HidraulicName .. "#FixPoint"));
		local ax, ay, az = getWorldTranslation(self.Hidraulic[i].punch);
		local bx, by, bz = getWorldTranslation(self.Hidraulic[i].translationPunch);		
		self.Hidraulic[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);	
	end;
end;

function Hidraulic:delete()
end;

function Hidraulic:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Hidraulic:keyEvent(unicode, sym, modifier, isDown)
end;

function Hidraulic:update(dt)
	for i=1, table.getn(self.Hidraulic) do
		local ax, ay, az = getWorldTranslation(self.Hidraulic[i].node);
		local bx, by, bz = getWorldTranslation(self.Hidraulic[i].FixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.Hidraulic[i].node), bx-ax, by-ay, bz-az);
		
		setDirection(self.Hidraulic[i].node, x, y, z, 0, 1, 0);
		if self.Hidraulic[i].punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.Hidraulic[i].punch, 0, 0, distance-self.Hidraulic[i].punchDistance);
		end;	
	end;
		
end;

function Hidraulic:draw()
end;
