--
-- URSUS C360 BY POLISHMODS TEAM.
--
-- M@D Author:  Fumski
-- M@D date: 28.07.2012
--
-- > Copyright (C) Fumski - Www.LS-Modteam.pl | Www.Polishmods.ubf.pl < --
--

UrsusC360BF = {};

function UrsusC360BF.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations) and SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function UrsusC360BF:load(xmlFile)

	self.setHydraulicTime = 30;
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	self.Belka = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Belka#index"));
	self.Sruba = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Sruba#index"));
 	setVisibility((self.Belka), true);
 	setVisibility((self.Sruba), false);
	self.rotationMax3Active = false;
	self.rotationMax2Active = false;
	self.rotationMax4Active = false;
	self.rotationMax5Active = false;


	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};
		
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;

    local rotationPartNodebieg1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bieg1#index"));
    if rotationPartNodebieg1 ~= nil then
        self.rotationPartbieg1 = {};
        self.rotationPartbieg1.node = rotationPartNodebieg1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartbieg1#minRot"));
        self.rotationPartbieg1.minRot = {};
        self.rotationPartbieg1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbieg1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbieg1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bieg1#maxRot"));
        self.rotationPartbieg1.maxRot = {};
        self.rotationPartbieg1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbieg1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbieg1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotationPartbieg1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.bieg1#rotTime"), 2)*1000;
        self.rotationPartbieg1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.bieg1#touchRotLimit"), 10));
    end;

    local rotationPartNodebieg2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bieg2#index"));
    if rotationPartNodebieg2 ~= nil then
        self.rotationPartbieg2 = {};
        self.rotationPartbieg2.node = rotationPartNodebieg2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartbieg2#minRot"));
        self.rotationPartbieg2.minRot = {};
        self.rotationPartbieg2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbieg2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbieg2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bieg2#maxRot"));
        self.rotationPartbieg2.maxRot = {};
        self.rotationPartbieg2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbieg2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbieg2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotationPartbieg2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.bieg2#rotTime"), 2)*1000;
        self.rotationPartbieg2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.bieg2#touchRotLimit"), 10));
    end;

    local rotationPartNodebieg3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bieg3#index"));
    if rotationPartNodebieg3 ~= nil then
        self.rotationPartbieg3 = {};
        self.rotationPartbieg3.node = rotationPartNodebieg3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartbieg3#minRot"));
        self.rotationPartbieg3.minRot = {};
        self.rotationPartbieg3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbieg3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbieg3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bieg3#maxRot"));
        self.rotationPartbieg3.maxRot = {};
        self.rotationPartbieg3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbieg3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbieg3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotationPartbieg3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.bieg3#rotTime"), 2)*1000;
        self.rotationPartbieg3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.bieg3#touchRotLimit"), 10));
    end;

    local rotationPartNodebiegr = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.biegr#index"));
    if rotationPartNodebiegr ~= nil then
        self.rotationPartbiegr = {};
        self.rotationPartbiegr.node = rotationPartNodebiegr;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartbiegr#minRot"));
        self.rotationPartbiegr.minRot = {};
        self.rotationPartbiegr.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbiegr.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbiegr.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.biegr#maxRot"));
        self.rotationPartbiegr.maxRot = {};
        self.rotationPartbiegr.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbiegr.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbiegr.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotationPartbiegr.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.biegr#rotTime"), 2)*1000;
        self.rotationPartbiegr.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.biegr#touchRotLimit"), 10));
    end;

	local rotationPartNodeLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartLeft#index"));
    if rotationPartNodeLeft ~= nil then
        self.rotationPartLeft = {};
        self.rotationPartLeft.node = rotationPartNodeLeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#minRot"));
        self.rotationPartLeft.minRot = {};
        self.rotationPartLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#maxRot"));
        self.rotationPartLeft.maxRot = {};
        self.rotationPartLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#rotTime"), 2)*1000;
        self.rotationPartLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#touchRotLimit"), 10));
    end;

	local rotationRpmNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationRpm#index"));
		if rotationRpmNode ~= nil then
        self.rotationRpm = {};
        self.rotationRpm.node = rotationRpmNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationRpm#minRot"));
        self.rotationRpm.minRot = {};
        self.rotationRpm.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationRpm.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationRpm.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationRpm#maxRot"));
        self.rotationRpm.maxRot = {};
        self.rotationRpm.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationRpm.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationRpm.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationRpm.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationRpm#rotTime"), 2)*1000;
        self.rotationRpm.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationRpm#touchRotLimit"), 10));
    end;

	local rotationRpm2Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationRpm2#index"));
		if rotationRpm2Node ~= nil then
        self.rotationRpm2 = {};
        self.rotationRpm2.node = rotationRpm2Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationRpm2#minRot"));
        self.rotationRpm2.minRot = {};
        self.rotationRpm2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationRpm2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationRpm2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationRpm2#maxRot"));
        self.rotationRpm2.maxRot = {};
        self.rotationRpm2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationRpm2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationRpm2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationRpm2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationRpm2#rotTime"), 2)*1000;
        self.rotationRpm2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationRpm2#touchRotLimit"), 10));
    end;
	
	local rotationPartNode5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart5#index"));
    if rotationPartNode5 ~= nil then
        self.rotationPart5 = {};
        self.rotationPart5.node = rotationPartNode5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart5#minRot"));
        self.rotationPart5.minRot = {};
        self.rotationPart5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart5#maxRot"));
        self.rotationPart5.maxRot = {};
        self.rotationPart5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart5#rotTime"), 2)*1000;
        self.rotationPart5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart5#touchRotLimit"), 10));
    end;

	local rotationPartNode4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart4#index"));
    if rotationPartNode4 ~= nil then
        self.rotationPart4 = {};
        self.rotationPart4.node = rotationPartNode4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#minRot"));
        self.rotationPart4.minRot = {};
        self.rotationPart4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#maxRot"));
        self.rotationPart4.maxRot = {};
        self.rotationPart4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#rotTime"), 2)*1000;
        self.rotationPart4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#touchRotLimit"), 10));
    end;

	local rotationPartNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart3#index"));
		if rotationPartNode3 ~= nil then
        self.rotationPart3 = {};
        self.rotationPart3.node = rotationPartNode3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#minRot"));
        self.rotationPart3.minRot = {};
        self.rotationPart3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#maxRot"));
        self.rotationPart3.maxRot = {};
        self.rotationPart3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#rotTime"), 2)*1000;
        self.rotationPart3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#touchRotLimit"), 10));
    end;

	local rotationPartNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart2#index"));
    if rotationPartNode2 ~= nil then
        self.rotationPart2 = {};
        self.rotationPart2.node = rotationPartNode2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#minRot"));
        self.rotationPart2.minRot = {};
        self.rotationPart2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#maxRot"));
        self.rotationPart2.maxRot = {};
        self.rotationPart2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#rotTime"), 2)*1000;
        self.rotationPart2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#touchRotLimit"), 10));
    end;

	
	local rotationLifter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Lifter#index"));
	self.Lifter = {};
	self.Lifter.node = rotationLifter;

	local rotationLifterArm = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.LifterArm#index"));
	self.LifterArm = {};
	self.LifterArm.node = rotationLifterArm;

	local rotationLifterBottom = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.LifterBottom#index"));
	self.bottomArm2 = {};
	self.bottomArm2.node = rotationLifterBottom;

	self.backAttacherJoint = {};
	self.backAttacherJoint.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerAttacherJoints#node"));
	self.backAttacherJoint.lowRot = Utils.degToRad(getXMLFloat(xmlFile, "vehicle.trailerAttacherJoints#lowRot"));
	self.backAttacherJoint.upRot = Utils.degToRad(getXMLFloat(xmlFile, "vehicle.trailerAttacherJoints#upRot"));

end;

function UrsusC360BF:delete()
end;

function UrsusC360BF:mouseEvent(posX, posY, isDown, isUp, button)
end;

function UrsusC360BF:keyEvent(unicode, sym, modifier, isDown)
end;

function UrsusC360BF:update(dt)
	if self:getIsActiveForInput() and self.isEntered then
        if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
			self.rotationMax4Active = not self.rotationMax4Active;
        end;
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			self.rotationMax5Active = not self.rotationMax5Active;
        end;
	end;


	if self.setHydraulicTime > 0 then
		for k,v in pairs(self.hydraulics) do 
			self:setHydraulicDirection(k);
		end;
		self.setHydraulicTime = self.setHydraulicTime - 1;
	end;
	
	if self:getIsActive() then
		self.setHydraulicTime = 30;
    end;

	if self:getIsActive() then
	inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

    if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
    end;

	if self.isEntered ~= nil then
		if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
			self.rotationMax3Active = true;
			self.rotationMax2Active = true;
		else
			self.rotationMax3Active = false;
			self.rotationMax2Active = false;
		end;
	end;

	if self.motor.speedLevel == 0 then
		self.rotationMaxbieg2 = false;
		self.rotationMaxbieg3 = false;
		self.rotationMaxbieg1 = false;
		self.rotationMaxbiegr = false;
	elseif self.motor.speedLevel == 1 then
		self.rotationMaxbieg1 = true;
		self.rotationMaxbieg2 = false;
		self.rotationMaxbieg3 = false;
		self.rotationMaxbiegr = false;
	elseif self.motor.speedLevel == 2 then
		self.rotationMaxbieg2 = true;
		self.rotationMaxbieg1 = false;
		self.rotationMaxbieg3 = false;
		self.rotationMaxbiegr = false;
	elseif self.motor.speedLevel == 3 then
		self.rotationMaxbieg3 = true;
		self.rotationMaxbieg2 = false;
		self.rotationMaxbieg1 = false;
		self.rotationMaxbiegr = false;  			  
	end;

	if self.isEntered then
		if Input.isKeyPressed(Input.KEY_w) then
			self.rotationMaxbiegr = false;
			self.rotationMaxbieg3 = true;
		elseif Input.isKeyPressed(Input.KEY_s) then 
			self.rotationMaxbiegr = true;
		end; 
	end; 

	if self.rotationPartbieg1 ~= nil then
		local x, y, z = getRotation(self.rotationPartbieg1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbieg1.maxRot, self.rotationPartbieg1.minRot, 3, self.rotationPartbieg1.rotTime, dt, not self.rotationMaxbieg1);
		setRotation(self.rotationPartbieg1.node, unpack(newRot));
    end;
    if self.rotationPartbieg2 ~= nil then
		local x, y, z = getRotation(self.rotationPartbieg2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbieg2.maxRot, self.rotationPartbieg2.minRot, 3, self.rotationPartbieg2.rotTime, dt, not self.rotationMaxbieg2);
		setRotation(self.rotationPartbieg2.node, unpack(newRot));
    end;
    if self.rotationPartbieg3 ~= nil then
		local x, y, z = getRotation(self.rotationPartbieg3.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbieg3.maxRot, self.rotationPartbieg3.minRot, 3, self.rotationPartbieg3.rotTime, dt, not self.rotationMaxbieg3);
		setRotation(self.rotationPartbieg3.node, unpack(newRot));
    end;
    if self.rotationPartbiegr ~= nil then
		local x, y, z = getRotation(self.rotationPartbiegr.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbiegr.maxRot, self.rotationPartbiegr.minRot, 3, self.rotationPartbiegr.rotTime, dt, not self.rotationMaxbiegr);
		setRotation(self.rotationPartbiegr.node, unpack(newRot));
    end;
	local maxrpmneedle = 2500;
	if self.rotationRpm ~= nil and self.isMotorStarted == true then
	local x, y, z = getRotation(self.rotationRpm.node);
	local range = math.deg(self.rotationRpm.maxRot[2]) - math.deg(self.rotationRpm.minRot[2])
	local crpm = self.motor.lastMotorRpm*3
	local p = (crpm/maxrpmneedle) 
		y = self.rotationRpm.minRot[2] + math.rad((range*p)+(math.random(0,20)-10))
		setRotation(self.rotationRpm.node, x, y ,z);
	elseif self.rotationRpm ~= nil and self.isMotorStarted == false then
		setRotation(self.rotationRpm.node, 0, 0 ,0);
	end;
	local maxrpmklapka = 2500;
	if self.rotationRpm2 ~= nil and self.isMotorStarted == true then
	local x, y, z = getRotation(self.rotationRpm2.node);
	local range = math.deg(self.rotationRpm2.maxRot[3]) - math.deg(self.rotationRpm2.minRot[3])
	local crpm = self.motor.lastMotorRpm*3
	local p = (crpm/maxrpmklapka) 
		z = self.rotationRpm2.minRot[3] + math.rad((range*p)+(math.random(0,20)-10))
		setRotation(self.rotationRpm2.node, x, y ,z);
	elseif self.rotationRpm2 ~= nil and self.isMotorStarted == false then
		setRotation(self.rotationRpm2.node, 0, 0 ,0);
	end;
	if self.rotationPart5 ~= nil then
		local x, y, z = getRotation(self.rotationPart5.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart5.maxRot, self.rotationPart5.minRot, 3, self.rotationPart5.rotTime, dt, not self.rotationMax5Active);
		setRotation(self.rotationPart5.node, unpack(newRot));
	end;
	if self.rotationPart4 ~= nil then
		local x, y, z = getRotation(self.rotationPart4.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart4.maxRot, self.rotationPart4.minRot, 3, self.rotationPart4.rotTime, dt, not self.rotationMax4Active);
		setRotation(self.rotationPart4.node, unpack(newRot));
	end;
	if self.rotationPart3 ~= nil then
		local x, y, z = getRotation(self.rotationPart3.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart3.maxRot, self.rotationPart3.minRot, 3, self.rotationPart3.rotTime, dt, not self.rotationMax3Active);
		setRotation(self.rotationPart3.node, unpack(newRot));
	end;
	if self.rotationPart2 ~= nil then
		local x, y, z = getRotation(self.rotationPart2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart2.maxRot, self.rotationPart2.minRot, 3, self.rotationPart2.rotTime, dt, not self.rotationMax2Active);
		setRotation(self.rotationPart2.node, unpack(newRot));
	end;	
	
	if self.Lifter.node ~= nil and self.bottomArm2.node ~= nil then
		rBBArmX, rBBArmY, rBBArmZ = getRotation(self.bottomArm2.node);
		setRotation(self.Lifter.node, rBBArmX*1.05, 0, 0);
	end;
	if self.LifterArm.node ~= nil and self.bottomArm2.node ~= nil then
		setRotation(self.LifterArm.node, 0.05-rBBArmX*1.1, 0, 0);
	end;
	if self.rotationPartLeft ~= nil then
		local x, y, z = getRotation(self.rotationPartLeft.node);
		x = (self.rotationPartLeft.maxRot[1] - self.rotationPartLeft.minRot[1]) * (self.rotatedTime/-1);
		setRotation(self.rotationPartLeft.node, x, y ,z);
	end;
	end;
end;

function UrsusC360BF:updateTick(dt)
end;

function UrsusC360BF:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return true;
end;

function UrsusC360BF:draw()
end;

function UrsusC360BF:onLeave()
end;

function UrsusC360BF:onEnter()
end;

function UrsusC360BF:attachImplement(implement)
	self.rotationMax4Active = false;
	self.rotationMax5Active = false;
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;
	
	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if jointIndex == 1 then
			setVisibility((self.Sruba), true);
			setVisibility((self.Belka), false);
		end;
	end;
	if jointType == Vehicle.JOINTTYPE_TRAILER then
		if jointIndex == 2 then
			setVisibility((self.Sruba), false);
			setVisibility((self.Belka), true);
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if jointIndex == 3 then	
			setVisibility((self.Sruba), false);
			setVisibility((self.Belka), true);
		end;
	end;
	self.updateJoint = true;
end;

function UrsusC360BF:detachImplement(implementIndex)
	self.rotationMax4Active = false;
	self.rotationMax5Active = false;
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;
	
	if jointIndex == 1 then
		setVisibility((self.Sruba), false);
		setVisibility((self.Belka), true);
	end;
	if jointIndex == 2 then
		setVisibility((self.Sruba), false);
		setVisibility((self.Belka), true);
	end
	if jointIndex == 3 then
		setVisibility((self.Sruba), false);
		setVisibility((self.Belka), true);
	end;
end;

function UrsusC360BF:setHydraulicDirection(index)
	local hydraulic = self.hydraulics[index];

	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
	end;
end;
