--
-- Pylon Farm
--
-- @author  Davidw123
-- @date  14/04/13
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

pylonfarm = {}
pylonfarm.currentModDirectory = g_modsDirectory .. "/pylonfarm/";



local pylonfarm_mt = Class(pylonfarm, Mission00);


function pylonfarm:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = pylonfarm_mt;
    end;
    local self = pylonfarm:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function pylonfarm:delete()
    pylonfarm:superClass().delete(self);
end;

function pylonfarm:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/map01.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function pylonfarm:loadMap01Finished(node, arguments)
    self.terrainDetailAngleNumChannels = 8; -- durch die gewünschte Anzahl Channels ersetzen
    self.terrainDetailAngleMaxValue = bitShiftLeft(1, self.terrainDetailAngleNumChannels) - 1;

    self:loadMapXMLFile(Utils.getFilename("pylonfarm.xml", self.baseDirectory));


    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs
    --self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 1024 - 85, 1024 - 135, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 1024 - 174, 1024 - 141, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Vehicle Shop
    --self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), 1024 + 714, 1024 + 119, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths
    --self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 1024 - 175, 1024 - 136, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- farm silos
    --self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 1024 - 697, 1024 - 33, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
    -- bga
    --self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 1024 - 430, 1024 - 805, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- livestock
    --self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 1024 + 655, 1024 + 256, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), 1024 - 612, 1024 + 587, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), 1024 - 12, 1024 - 93, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    pylonfarm:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function pylonfarm:onStartMission()
    pylonfarm:superClass().onStartMission(self);
end;

function pylonfarm:mouseEvent(posX, posY, isDown, isUp, button)
    pylonfarm:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function pylonfarm:keyEvent(unicode, sym, modifier, isDown)
    pylonfarm:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function pylonfarm:update(dt)
    pylonfarm:superClass().update(self, dt);
end;

function pylonfarm:draw()
    pylonfarm:superClass().draw(self);
end;