-- Lua scripting by the team at PUC-Rio, the Pontifical Catholic University of Rio de Janeiro in Brazil.
-- this script uses code that can be found in many Giants lua scripts 
-- this script is based upon the placeableFertilizerTank script by Alex2009, Sven777b
-- author sandgroper...

uanTankPlaceableL = {};
uanTankPlaceableL_mt = Class(uanTankPlaceableL, Placeable);

InitObjectClass(uanTankPlaceableL, "uanTankPlaceableL");

function uanTankPlaceableL:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, uanTankPlaceableL_mt);
    registerObjectClassName(self, "uanTankPlaceableL");
    return self;
end;

function uanTankPlaceableL:delete()
    removeTrigger(self.SprayerFillTriggerId);
    unregisterObjectClassName(self);
    uanTankPlaceableL:superClass().delete(self);
end;

function uanTankPlaceableL:deleteFinal()
    uanTankPlaceableL:superClass().deleteFinal(self);
end;

function uanTankPlaceableL:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not uanTankPlaceableL:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
    local xmlFile = loadXMLFile("TempXML", xmlFilename);
    self.SprayerFillTriggerId = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.FillTrigger4#index"));
	SprayerFillTrigger:onCreate(self.SprayerFillTriggerId);
    
    delete(xmlFile);
    
	return true;
	
end;

function uanTankPlaceableL:update(dt)
end;
registerPlaceableType("uanTankPlaceableL", uanTankPlaceableL);