-- Lua scripting by the team at PUC-Rio, the Pontifical Catholic University of Rio de Janeiro in Brazil.
-- this script uses code that can be found in many Giants lua scripts 
-- this script is based upon the placeableFertilizerTank script by Alex2009, Sven777b
-- author sandgroper...

uanTankPlaceableC = {};
uanTankPlaceableC_mt = Class(uanTankPlaceableC, Placeable);

InitObjectClass(uanTankPlaceableC, "uanTankPlaceableC");

function uanTankPlaceableC:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, uanTankPlaceableC_mt);
    registerObjectClassName(self, "uanTankPlaceableC");
    return self;
end;

function uanTankPlaceableC:delete()
    removeTrigger(self.SprayerFillTriggerId);
    unregisterObjectClassName(self);
    uanTankPlaceableC:superClass().delete(self);
end;

function uanTankPlaceableC:deleteFinal()
    uanTankPlaceableC:superClass().deleteFinal(self);
end;

function uanTankPlaceableC:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not uanTankPlaceableC:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
    local xmlFile = loadXMLFile("TempXML", xmlFilename);
    self.SprayerFillTriggerId = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.FillTrigger3#index"));
	SprayerFillTrigger:onCreate(self.SprayerFillTriggerId);
    
    delete(xmlFile);
    
	return true;
	
end;

function uanTankPlaceableC:update(dt)
end;
registerPlaceableType("uanTankPlaceableC", uanTankPlaceableC);