-- Lua scripting by the team at PUC-Rio, the Pontifical Catholic University of Rio de Janeiro in Brazil.
-- this script uses code that can be found in many Giants lua scripts 
-- this script is based upon the placeableFertilizerTank script by Alex2009, Sven777b
-- author sandgroper...

uanTankPlaceableB = {};
uanTankPlaceableB_mt = Class(uanTankPlaceableB, Placeable);

InitObjectClass(uanTankPlaceableB, "uanTankPlaceableB");

function uanTankPlaceableB:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, uanTankPlaceableB_mt);
    registerObjectClassName(self, "uanTankPlaceableB");
    return self;
end;

function uanTankPlaceableB:delete()
    removeTrigger(self.SprayerFillTriggerId);
    unregisterObjectClassName(self);
    uanTankPlaceableB:superClass().delete(self);
end;

function uanTankPlaceableB:deleteFinal()
    uanTankPlaceableB:superClass().deleteFinal(self);
end;

function uanTankPlaceableB:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not uanTankPlaceableB:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
    local xmlFile = loadXMLFile("TempXML", xmlFilename);
    self.SprayerFillTriggerId = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.FillTrigger2#index"));
	SprayerFillTrigger:onCreate(self.SprayerFillTriggerId);
    
    delete(xmlFile);
    
	return true;
	
end;

function uanTankPlaceableB:update(dt)
end;
registerPlaceableType("uanTankPlaceableB", uanTankPlaceableB);