-- Lua scripting by the team at PUC-Rio, the Pontifical Catholic University of Rio de Janeiro in Brazil.
-- this script uses code that can be found in many Giants lua scripts 
-- this script is based upon the placeableFertilizerTank script by Alex2009, Sven777b
-- author sandgroper...

uanTankPlaceableA = {};
uanTankPlaceableA_mt = Class(uanTankPlaceableA, Placeable);

InitObjectClass(uanTankPlaceableA, "uanTankPlaceableA");

function uanTankPlaceableA:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, uanTankPlaceableA_mt);
    registerObjectClassName(self, "uanTankPlaceableA");
    return self;
end;

function uanTankPlaceableA:delete()
    removeTrigger(self.SprayerFillTriggerId);
    unregisterObjectClassName(self);
    uanTankPlaceableA:superClass().delete(self);
end;

function uanTankPlaceableA:deleteFinal()
    uanTankPlaceableA:superClass().deleteFinal(self);
end;

function uanTankPlaceableA:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not uanTankPlaceableA:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
    local xmlFile = loadXMLFile("TempXML", xmlFilename);
    self.SprayerFillTriggerId = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.FillTrigger1#index"));
	SprayerFillTrigger:onCreate(self.SprayerFillTriggerId);
    
    delete(xmlFile);
    
	return true;
	
end;

function uanTankPlaceableA:update(dt)
end;
registerPlaceableType("uanTankPlaceableA", uanTankPlaceableA);