-- Lua scripting by the team at PUC-Rio, the Pontifical Catholic University of Rio de Janeiro in Brazil.
-- this script uses code that can be found in many Giants lua scripts 
-- this script is based upon the placeableFertilizerTank script by Alex2009, Sven777b
-- author sandgroper...

herbiTankPlaceableC = {};
herbiTankPlaceableC_mt = Class(herbiTankPlaceableC, Placeable);

InitObjectClass(herbiTankPlaceableC, "herbiTankPlaceableC");

function herbiTankPlaceableC:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, herbiTankPlaceableC_mt);
    registerObjectClassName(self, "herbiTankPlaceableC");
    return self;
end;

function herbiTankPlaceableC:delete()
    removeTrigger(self.SprayerFillTriggerId);
    unregisterObjectClassName(self);
    herbiTankPlaceableC:superClass().delete(self);
end;

function herbiTankPlaceableC:deleteFinal()
    herbiTankPlaceableC:superClass().deleteFinal(self);
end;

function herbiTankPlaceableC:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not herbiTankPlaceableC:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
    local xmlFile = loadXMLFile("TempXML", xmlFilename);
    self.SprayerFillTriggerId = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.FillTriggerC#index"));
	SprayerFillTrigger:onCreate(self.SprayerFillTriggerId);
    
    delete(xmlFile);
    
	return true;
	
end;

function herbiTankPlaceableC:update(dt)
end;
registerPlaceableType("herbiTankPlaceableC", herbiTankPlaceableC);