-- Lua scripting by the team at PUC-Rio, the Pontifical Catholic University of Rio de Janeiro in Brazil.
-- this script uses code that can be found in many Giants lua scripts 
-- this script is based upon the placeableFertilizerTank script by Alex2009, Sven777b
-- author sandgroper...

herbiTankPlaceableB = {};
herbiTankPlaceableB_mt = Class(herbiTankPlaceableB, Placeable);

InitObjectClass(herbiTankPlaceableB, "herbiTankPlaceableB");

function herbiTankPlaceableB:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, herbiTankPlaceableB_mt);
    registerObjectClassName(self, "herbiTankPlaceableB");
    return self;
end;

function herbiTankPlaceableB:delete()
    removeTrigger(self.SprayerFillTriggerId);
    unregisterObjectClassName(self);
    herbiTankPlaceableB:superClass().delete(self);
end;

function herbiTankPlaceableB:deleteFinal()
    herbiTankPlaceableB:superClass().deleteFinal(self);
end;

function herbiTankPlaceableB:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not herbiTankPlaceableB:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
    local xmlFile = loadXMLFile("TempXML", xmlFilename);
    self.SprayerFillTriggerId = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.FillTriggerB#index"));
	SprayerFillTrigger:onCreate(self.SprayerFillTriggerId);
    
    delete(xmlFile);
    
	return true;
	
end;

function herbiTankPlaceableB:update(dt)
end;
registerPlaceableType("herbiTankPlaceableB", herbiTankPlaceableB);