-- Lua scripting by the team at PUC-Rio, the Pontifical Catholic University of Rio de Janeiro in Brazil.
-- this script uses code that can be found in many Giants lua scripts 
-- this script is based upon the placeableFertilizerTank script by Alex2009, Sven777b
-- author sandgroper...

herbiTankPlaceableA = {};
herbiTankPlaceableA_mt = Class(herbiTankPlaceableA, Placeable);

InitObjectClass(herbiTankPlaceableA, "herbiTankPlaceableA");

function herbiTankPlaceableA:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, herbiTankPlaceableA_mt);
    registerObjectClassName(self, "herbiTankPlaceableA");
    return self;
end;

function herbiTankPlaceableA:delete()
    removeTrigger(self.SprayerFillTriggerId);
    unregisterObjectClassName(self);
    herbiTankPlaceableA:superClass().delete(self);
end;

function herbiTankPlaceableA:deleteFinal()
    herbiTankPlaceableA:superClass().deleteFinal(self);
end;

function herbiTankPlaceableA:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not herbiTankPlaceableA:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
    local xmlFile = loadXMLFile("TempXML", xmlFilename);
    self.SprayerFillTriggerId = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.FillTriggerA#index"));
	SprayerFillTrigger:onCreate(self.SprayerFillTriggerId);
    
    delete(xmlFile);
    
	return true;
	
end;

function herbiTankPlaceableA:update(dt)
end;
registerPlaceableType("herbiTankPlaceableA", herbiTankPlaceableA);