

visibility = {};

function visibility.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function visibility:load(xmlFile)

    numparts = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.parts#count"), 0);
	self.parts = {};
    for i=1, numparts do
        local partnamei = string.format("vehicle.parts.part%d", i);
        self.parts[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
        setVisibility(self.parts[i], false);
    end;
	self.partsActive = false;
	
	numparts2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.parts2#count"), 0);
	self.parts2 = {};
    for i=1, numparts2 do
        local partnamei = string.format("vehicle.parts2.part%d", i);
        self.parts2[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
        setVisibility(self.parts2[i], false);
    end;
	self.parts2Active = true;
	
	numparts3 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.parts3#count"), 0);
	self.parts3 = {};
    for i=1, numparts3 do
        local partnamei = string.format("vehicle.parts3.part%d", i);
        self.parts3[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
        setVisibility(self.parts3[i], false);
    end;
	self.parts3Active = false;
	
	numparts4 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.parts4#count"), 0);
	self.parts4 = {};
    for i=1, numparts4 do
        local partnamei = string.format("vehicle.parts4.part%d", i);
        self.parts4[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
        setVisibility(self.parts4[i], false);
    end;
	self.parts4Active = true;
	
end;

function visibility:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym == Input.KEY_l then 
	  self.partsActive = not self.partsActive;
	end;
	if isDown and sym == Input.KEY_l then 
		self.parts2Active = not self.parts2Active;
	end;
	if isDown and sym == Input.KEY_l then 
		self.parts3Active = not self.parts3Active;
	end;
	if isDown and sym == Input.KEY_l then 
		self.parts4Active = not self.parts4Active;
	end;

end;


function visibility:update(dt)

  if self.partsActive then
		for i=1, numparts do
			setVisibility(self.parts[i], self.partsActive);
		end;
	        else
		for i=1, numparts do
			setVisibility(self.parts[i], self.partsActive, false);
	    end;
	end;
   if self.parts2Active then
		for i=1, numparts2 do
			setVisibility(self.parts2[i], self.parts2Active);
		end;
	        else
		for i=1, numparts2 do
			setVisibility(self.parts2[i], self.parts2Active, false);
	    end;	
    end;
	   if self.parts3Active then
		for i=1, numparts3 do
			setVisibility(self.parts3[i], self.parts3Active);
		end;
	        else
		for i=1, numparts3 do
			setVisibility(self.parts3[i], self.parts3Active, false);
	    end;	
    end;
	   if self.parts4Active then
		for i=1, numparts4 do
			setVisibility(self.parts4[i], self.parts4Active);
		end;
	        else
		for i=1, numparts4 do
			setVisibility(self.parts4[i], self.parts4Active, false);
	    end;	
    end;
end;

function visibility:draw()
end;

function visibility:onEnter()

end;

function visibility:onLeave()
end;

function visibility:delete()
end;

function visibility:mouseEvent(posX, posY, isDown, isUp, button)
end;