--
-- BuyableTwinWheelsAttacher
-- Specialization for Buyable Twin Wheels
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v3.0
-- @date  		30/10/12
-- @history:	v1.0 - Initial version
--				v2.0 - added network support, changed update to updateTick
--				v3.0 - Added dynamic collision support, ls13-ready
--
-- free for noncommerical-usage
--

BuyableTwinWheelsAttacher = {};

function BuyableTwinWheelsAttacher.prerequisitesPresent(specializations)
    return true;
end;

function BuyableTwinWheelsAttacher:load(xmlFile)

	self.onAssembling = SpecializationUtil.callSpecializationsFunction("onAssembling");
	self.onDisassembling = SpecializationUtil.callSpecializationsFunction("onDisassembling");
	
	self.buyableTwinWheels = {};
	self.buyableTwinWheels.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#twinWheelsCheckString"), "standart");
	self.buyableTwinWheels.twinWheels = nil;
	self.buyableTwinWheels.twinWheelsFront = nil;
	self.buyableTwinWheels.twinWheelsBack = nil;
	
	self.buyableTwinWheels.wheelsInRange = nil;	
	
    local i = 0;
    while true do
        local wheelnamei = string.format("vehicle.wheels.wheel(%d)", i);        
        local rootNodeStr = getXMLString(xmlFile, wheelnamei .. "#rootNode");
        if rootNodeStr == nil then
            break;
        end;
		local wheel = self.wheels[i+1];
        wheel.rootNode = Utils.indexToObject(self.components, rootNodeStr);
		wheel.twinWheelAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, wheelnamei .. "#twinWheelAttacher"));
        i = i+1;
    end;	
	
	
	
	--DURAL
	RealisticVehicle.registerExtraMassGetter(self, BuyableTwinWheelsAttacher.getCurrentMass);	
	
end;


--DURAL
function BuyableTwinWheelsAttacher:getCurrentMass()

	--[[
	if self.buyableTwinWheels.twinWheels~=nil then
		local mass = self.buyableTwinWheels.twinWheels.realAdditionalMass;
		local comTrans = self.buyableTwinWheels.twinWheels.realComTrans;
		if mass~=nil and comTrans~=nil then
			--print("BuyableTwinWheelsAttacher:getCurrentMass - mass=" .. tostring(self.buyableTwinWheels.twinWheels.realAdditionalMass) .. " comtrans=" .. tostring(self.buyableTwinWheels.twinWheels.realComTrans.z));
			return mass, comTrans;
		end
	end; 
	]]--
	
	local mass = 0;
	local comTrans = {x=0, y=0, z=0};

	if self.buyableTwinWheels.twinWheelsFront ~= nil then
		mass = mass + self.buyableTwinWheels.twinWheelsFront.realAdditionalMass;
		local ct = self.buyableTwinWheels.twinWheelsFront.realComTrans;
		comTrans.x = comTrans.x + ct.x;
		comTrans.y = comTrans.y + ct.y;
		comTrans.z = comTrans.z + ct.z;
	end;
	if self.buyableTwinWheels.twinWheelsBack ~= nil then
		mass = mass + self.buyableTwinWheels.twinWheelsBack.realAdditionalMass;
		local ct = self.buyableTwinWheels.twinWheelsBack.realComTrans;			
		comTrans.x = comTrans.x + ct.x;
		comTrans.y = comTrans.y + ct.y;
		comTrans.z = comTrans.z + ct.z;
	end;
	--	if mass ~= nil and comTrans ~= nil then
	--		--print("BuyableTwinWheelsAttacher:getCurrentMass - mass=" .. tostring(self.buyableTwinWheels.twinWheels.realAdditionalMass) .. " comtrans=" .. tostring(self.buyableTwinWheels.twinWheels.realComTrans.z));
	--		return mass, comTrans;
	--	end
	--end;	
	return mass, comTrans;		
	
end;

function BuyableTwinWheelsAttacher:delete()
	--if self.buyableTwinWheels.twinWheels ~= nil then
	--	self.buyableTwinWheels.twinWheels:disassembleWheels(true);
	--end;
	if self.buyableTwinWheels.twinWheelsFront ~= nil then
		self.buyableTwinWheels.twinWheelsFront:disassembleWheels(true);
	end;
	if self.buyableTwinWheels.twinWheelsBack ~= nil then
		self.buyableTwinWheels.twinWheelsBack:disassembleWheels(true);
	end;	
end;

function BuyableTwinWheelsAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BuyableTwinWheelsAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function BuyableTwinWheelsAttacher:update(dt)

	if self:getIsActive() then
		local wheels = self.buyableTwinWheels;
		if wheels.wheelsInRange ~= nil then
			if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
				if InputBinding.hasEvent(InputBinding.BUYABLE_TWINWHEELS_ATTACH) then
					if wheels.twinWheelsFront == nil and string.match(wheels.wheelsInRange.side, "front") then
						wheels.wheelsInRange:assembleWheels(self);
					elseif wheels.twinWheelsBack == nil and string.match(wheels.wheelsInRange.side, "back") then
						wheels.wheelsInRange:assembleWheels(self);
					else
						if wheels.wheelsInRange.twinWheelsUser == self then
							wheels.wheelsInRange:disassembleWheels();
						end;
					end;
				end;
			end;
		end;
	end;
end;

function BuyableTwinWheelsAttacher:draw()
	local wheels = self.buyableTwinWheels;
	if wheels.wheelsInRange ~= nil then
		if self.buyableTwinWheels.twinWheelsFront == nil or self.buyableTwinWheels.twinWheelsBack == nil then
			if wheels.wheelsInRange.twinWheelsUser == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_assemble"), InputBinding.BUYABLE_TWINWHEELS_ATTACH);
			elseif wheels.wheelsInRange.twinWheelsUser == self then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_disassemble"), InputBinding.BUYABLE_TWINWHEELS_ATTACH);
			end;		
		elseif wheels.wheelsInRange.twinWheelsUser == self then
			g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_disassemble"), InputBinding.BUYABLE_TWINWHEELS_ATTACH);
		end;		
		--[[
		if wheels.twinWheels ~= nil then
			if wheels.wheelsInRange.twinWheelsUser == self then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_disassemble"), InputBinding.BUYABLE_TWINWHEELS_ATTACH);
			end;
		else
			if wheels.wheelsInRange.twinWheelsUser == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_assemble"), InputBinding.BUYABLE_TWINWHEELS_ATTACH);
			end;
		end;
		]]--
	end;
end;

function BuyableTwinWheelsAttacher:onAssembling(buyableTwinWheels)
	--self.buyableTwinWheels.twinWheels = buyableTwinWheels;
	if string.match("front", buyableTwinWheels.side) then
		self.buyableTwinWheels.twinWheelsFront = buyableTwinWheels;
	else
		self.buyableTwinWheels.twinWheelsBack = buyableTwinWheels;
	end;	
end;

function BuyableTwinWheelsAttacher:onDisassembling()
	--self.buyableTwinWheels.twinWheels = nil;
	if self.buyableTwinWheels.wheelsInRange == self.buyableTwinWheels.twinWheelsFront then
		self.buyableTwinWheels.twinWheelsFront = nil;
	elseif self.buyableTwinWheels.wheelsInRange == self.buyableTwinWheels.twinWheelsBack then
		self.buyableTwinWheels.twinWheelsBack = nil;
	end;		
end;