--
-- InteractiveButtons
-- Specialization for an interactive control button
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--

InteractiveButtons = {};

function InteractiveButtons.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(InteractiveControl, specializations);
end;

function InteractiveButtons:load(xmlFile)

	self.count = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.interactiveComponents.buttons#count"), 0);	
	if self.count ~= 0 then	
		for i=1, self.count do	
			local buttonName = string.format("vehicle.interactiveComponents.buttons.button%d", i);	
			local name = Utils.getNoNil(g_i18n:getText(getXMLString(xmlFile, buttonName .. "#name")), "ERROR");
			local mark = Utils.indexToObject(self.components, getXMLString(xmlFile, buttonName .. "#mark"));
			local highlight = getChildAt(mark, 0);
			local size = Utils.getNoNil(getXMLFloat(xmlFile, buttonName .. "#size"), 0.1);
			local event = getXMLString(xmlFile, buttonName .. "#event");
			local onMessage = g_i18n:getText("ic_button_on");
			local offMessage = g_i18n:getText("ic_button_off");
		
			local button = Button:new(nil, highlight, name, mark, size, event, self, onMessage, offMessage);

			table.insert(self.interactiveObjects, button);
		end;
	end;
	
end;

function InteractiveButtons:delete()
end;

function InteractiveButtons:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InteractiveButtons:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveButtons:update(dt)	
end;

function InteractiveButtons:draw()
end;



--
-- Button Class
-- Specifies an interactive Button
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  25/12/09
--

Button = {};

function Button:new(node, highlight, name, mark, size, event, vehicle, onMessage, offMessage)

	local Button_mt = Class(Button, InteractiveComponentInterface);	
    local instance = InteractiveComponentInterface:new(node, highlight, name, mark, size, onMessage, offMessage, Button_mt);

	instance.vehicle = vehicle;
	instance.event = event;
	
	return instance;	
end;

function Button:delete()
	InteractiveComponentInterface.delete(self);
end;

function Button:mouseEvent(posX, posY, isDown, isUp, button)
	InteractiveComponentInterface.mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Button:keyEvent(unicode, sym, modifier, isDown)
	InteractiveComponentInterface.keyEvent(self, unicode, sym, modifier, isDown);
end;

function Button:update(dt)
	if self.vehicle ~= nil then
		self.isOpen = self.vehicle.currentLight == 2;
	end;
	InteractiveComponentInterface.update(self, dt);
end;

function Button:draw()
	InteractiveComponentInterface.draw(self);
end;

function Button:doAction(dt)
	if self.event == "toggleWarningLights" then
		if self.vehicle ~= nil then
			if self.vehicle.B3.wl then
				self.vehicle:setState("warnlights", false);
				self.vehicle:setState("dirLeft", false);
				self.vehicle:setState("dirRight", false);
			else
				self.vehicle:setState("warnlights", true);
				self.vehicle:setState("dirLeft", true);
				self.vehicle:setState("dirRight", true);
			end;
		end;
	end;
	if self.event == "toggleRightIndicator" then
		if self.vehicle ~= nil then
			if not self.vehicle.B3.wl then
				if self.vehicle.B3.dirRight[1].a then
					self.vehicle:setState("dirLeft", false);
					self.vehicle:setState("dirRight", false);
				else
					self.vehicle:setState("dirLeft", false);
					self.vehicle:setState("dirRight", true);
				end;
			end;
		end;
	end;
	if self.event == "toggleLeftIndicator" then
		if self.vehicle ~= nil then
			if not self.vehicle.B3.wl then
				if self.vehicle.B3.dirLeft[1].a then
					self.vehicle:setState("dirLeft", false);
					self.vehicle:setState("dirRight", false);
				else
					self.vehicle:setState("dirLeft", true);
					self.vehicle:setState("dirRight", false);
				end;
			end;
		end;
	end;
	if self.event == "toggleFrontlights" then
		if self.vehicle ~= nil then
			if self.vehicle.lightsActive then
				self.vehicle:setLightsVisibility(false);
			else
				self.vehicle:setLightsVisibility(true);
			end;
		end;
	end;	
	if self.event == "toggleFrontWorklights" then
		if self.vehicle ~= nil then
			local i = 1;
			if self.vehicle.B3.work[i].a then
				self.vehicle:setState("work:"..i, false);
			else
				self.vehicle:setState("work:"..i, true);
			end;
		end;
	end;
	if self.event == "toggleBackWorklights" then
		if self.vehicle ~= nil then
			local i = 2;
			if self.vehicle.B3.work[i].a then
				self.vehicle:setState("work:"..i, false);
			else
				self.vehicle:setState("work:"..i, true);
			end;
		end;
	end;
	if self.event == "togglePipeWorklights" then
		if self.vehicle ~= nil then
				if self.B3.pipe[1].a then
					self:setState("pipe", self.currentPipeState > 1, true);
				end;
		end;
	end;
end;

function Button:onEnter(dt)
	InteractiveComponentInterface.onEnter(self, dt);
end;

function Button:onExit(dt)
	InteractiveComponentInterface.onExit(self, dt);
end;

function Button:setActive()
	InteractiveComponentInterface.setActive(self, isActive);
end;

function Button:setVisible(isVisible)
	InteractiveComponentInterface.setVisible(self, isVisible);
end;