--
-- Copyright © 2013 Joacim Sigfridsson <joxxer@msn.com>
-- This work is free. You can redistribute it and/or modify it under the
-- terms of the Do What The Fuck You Want To Public License, Version 2,
-- as published by Sam Hocevar. See http://www.wtfpl.net/ for more details.
--
--
-- BJR_DynamicCamera
-- Specialization for BJR_DynamicCamera mod
--
-- @author  	JoXXer
-- @date  		03/03/13
-- @history		v1.0 - Initial implementation
--				v1.1 - 16/03/13 - General improvements
--				v1.1.1 - 30/05/13 - Namechange from DynamicCamera to BJR_DynamicCamera
--
-- @usage
-- XML: <dynamicCamera index="MOVING_PART_INDEX" rearWindow="REAR_WINDOW_INDEX" indoorCameraIndex="INDOOR_CAMERA_VALUE_INT"/>
-- 

BJR_DynamicCamera = {};

function BJR_DynamicCamera.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function BJR_DynamicCamera:load(xmlFile)
	
	self.cameraTransNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dynamicCamera#index"));
	self.rearWindow = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dynamicCamera#rearWindow"));
	self.indoorCameraIndex = getXMLInt(xmlFile, "vehicle.dynamicCamera#indoorCameraIndex");

	self.insideCamera = self.cameras[self.indoorCameraIndex];
	
	self.origX, self.origY, self.origZ = getTranslation(self.cameraTransNode);
	
	self.xTrans = self.origX;
	
	self.rearTransLimitMod = 0.0025;
end;

function BJR_DynamicCamera:delete()
end;

function BJR_DynamicCamera:readStream(streamId, connection)
end;

function BJR_DynamicCamera:writeStream(streamId, connection)
end;

function BJR_DynamicCamera:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BJR_DynamicCamera:keyEvent(unicode, sym, modifier, isDown)
end;

function BJR_DynamicCamera:update(dt)
	if self:getIsActive() then
		if self.camIndex  == self.indoorCameraIndex then
			
			if self.rearWindow ~= nil then
				local rearX, rearY, rearZ = getRotation(self.rearWindow);
				if math.deg(rearX) > 50 then
					if self.rearTransLimitMod < 0.0035 then
						self.rearTransLimitMod = self.rearTransLimitMod + dt * 0.0000005;
					end;
				else
					if self.rearTransLimitMod > 0.0025 then
						self.rearTransLimitMod = self.rearTransLimitMod - dt * 0.000001;
					end;
				end;
			end;
			
			local x, y, z = getRotation(self.insideCamera.cameraNode);
			
			local yFix = y;
			if yFix < 0 then
				yFix = -yFix;
			end;
				
			local timesTurned = yFix / math.rad(280);
			
			timesTurned = math.floor(timesTurned);
			
			if timesTurned >= 1 then
				if y < 0 then
					y = y + (math.rad(360) * timesTurned);
				else
					y = y - (math.rad(360) * timesTurned);
				end;
			end;
				
			if y < math.rad(80) and y > math.rad(-80) then
				local diff = math.rad(80);
				
				local origY = y;
				
				if y < 0 then
					y = -y;
				end;
				y = diff - y;
				
				if origY < 0 and self.xTrans >= self.origX then
					self.xTrans = self.origX + (math.deg(y) * 0.0025);
				elseif self.xTrans <= self.origX then
					self.xTrans = self.origX - (math.deg(y) * 0.0025);
				end;
				setTranslation(self.cameraTransNode, self.xTrans, (self.origY + (math.deg(y) * 0.002)), (self.origZ - (math.deg(y) * self.rearTransLimitMod))); 
			else
				setTranslation(self.cameraTransNode, self.origX, self.origY, self.origZ); 
				self.xTrans = self.origX;
			end;
		end;
	end;
end;

function BJR_DynamicCamera:updateTick(dt)

end;

function BJR_DynamicCamera:draw()

end;

function BJR_DynamicCamera:onLeave()

end;

function BJR_DynamicCamera:onEnter()

end;