TX65Cutter = {};

function TX65Cutter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function TX65Cutter:load(xmlFile)
	self.Psenice = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tx65Cutter.psenice#node"));
	self.Repka = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tx65Cutter.repka#node"));
	self.Kryt = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tx65Cutter.kryt#node"));
	self.PseniceJe = false;
	self.RepkaJe = false;
	self.KrytJe = true;
	self.RepkaMusi = false;
	self.PseniceMusi = false;
	self.Sekame = false;
end;

function TX65Cutter:delete()
end;

function TX65Cutter:readStream(streamId, connection)
end;

function TX65Cutter:writeStream(streamId, connection)
end;

function TX65Cutter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TX65Cutter:keyEvent(unicode, sym, modifier, isDown)
end;

function TX65Cutter:update(dt)
	if self:getIsActive() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_CUTTING_PART_W) then
			if not self.RepkaJe and not self.RepkaMusi and not self.PseniceMusi then
				if self.PseniceJe then
					setVisibility(self.Psenice,false);
				else
					setVisibility(self.Psenice,true);
				end;
				self.PseniceJe = not self.PseniceJe;
			end;
		end;
		if InputBinding.hasEvent(InputBinding.TOGGLE_CUTTING_PART_R) then
			if not self.PseniceJe and not self.PseniceMusi and not self.RepkaMusi then
				if self.RepkaJe then
					setVisibility(self.Repka,false);
				else
					setVisibility(self.Repka,true);
				end;
				self.RepkaJe = not self.RepkaJe;
			end;
		end;
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHIELD_STATE) then
			if self.KrytJe then
				setVisibility(self.Kryt,false);
			else
				setVisibility(self.Kryt,true);
			end;
			self.KrytJe = not self.KrytJe;
		end;
		if InputBinding.hasEvent(InputBinding.ACTIVATE_THRESHING) then
			if self.attacherVehicle ~= nil then
				if self.attacherVehicle.lastValidGrainTankFruitType == FruitUtil.FRUITTYPE_RAPE then
					setVisibility(self.Repka,true);
					setVisibility(self.Psenice,false);
					self.RepkaMusi = true;
					self.RepkaJe = true;
				end;
			    if self.attacherVehicle.lastValidGrainTankFruitType == FruitUtil.FRUITTYPE_WHEAT then
					setVisibility(self.Repka,false);
					setVisibility(self.Psenice,true);
					self.PseniceMusi = true;
				end;
			    if self.attacherVehicle.lastValidGrainTankFruitType == FruitUtil.FRUITTYPE_BARLEY then
					setVisibility(self.Repka,false);
					setVisibility(self.Psenice,true);
					self.PseniceMusi = true;
					self.PseniceJe = true;
				end;
			end;
			if self.Sekame then
				self.RepkaMusi = false;
				self.PseniceMusi = false;
			end;
			self.Sekame = not self.Sekame;
		end;
	end;
end;

function TX65Cutter:updateTick(dt)
end;

function TX65Cutter:draw()	
	if self.KrytJe then
		g_currentMission:addHelpButtonText(g_i18n:getText("krytON"), InputBinding.TOGGLE_SHIELD_STATE);
    else
	    g_currentMission:addHelpButtonText(g_i18n:getText("krytOFF"), InputBinding.TOGGLE_SHIELD_STATE);
	end;
	if self.RepkaJe and not self.Sekame then
		g_currentMission:addHelpButtonText(g_i18n:getText("repkaON"), InputBinding.TOGGLE_CUTTING_PART_R);
	end;
	if self.PseniceJe and not self.Sekame then
		g_currentMission:addHelpButtonText(g_i18n:getText("pseniceON"), InputBinding.TOGGLE_CUTTING_PART_W);
	end;
	if not self.PseniceJe and not self.RepkaJe then
		g_currentMission:addHelpButtonText(g_i18n:getText("pseniceOFF"), InputBinding.TOGGLE_CUTTING_PART_W);
	    g_currentMission:addHelpButtonText(g_i18n:getText("repkaOFF"), InputBinding.TOGGLE_CUTTING_PART_R);
	end;
end;