mrGearbox2SetNextGearEvent = {};
mrGearbox2SetNextGearEvent_mt = Class(mrGearbox2SetNextGearEvent, Event);

InitEventClass(mrGearbox2SetNextGearEvent, "mrGearbox2SetNextGearEvent");

 
function mrGearbox2SetNextGearEvent:emptyNew()
	local self = Event:new(mrGearbox2SetNextGearEvent_mt);
	self.className="mrGearbox2SetNextGearEvent";
	return self;
end;

function mrGearbox2SetNextGearEvent:new(object, gearDown)
	local self = mrGearbox2SetNextGearEvent:emptyNew();
	self.gearDown = gearDown;
	self.object = object;
	return self;
end;

function mrGearbox2SetNextGearEvent:readStream(streamId, connection)
	--only the server receive the event
	local id = streamReadInt32(streamId);
	self.gearDown = streamReadBool(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function mrGearbox2SetNextGearEvent:writeStream(streamId, connection)
	--only the clients send this event
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.gearDown);
end;

function mrGearbox2SetNextGearEvent:run(connection)
	--only the server "run" this event (after reading it)	
	self.object:setNextGear(self.gearDown, true);	
end;