mrGearbox2SetGearEvent = {};
mrGearbox2SetGearEvent_mt = Class(mrGearbox2SetGearEvent, Event);

InitEventClass(mrGearbox2SetGearEvent, "mrGearbox2SetGearEvent");

 
function mrGearbox2SetGearEvent:emptyNew()
	local self = Event:new(mrGearbox2SetGearEvent_mt);
	self.className="mrGearbox2SetGearEvent";
	return self;
end;

function mrGearbox2SetGearEvent:new(object, gearNum, range, reverseActive)
	local self = mrGearbox2SetGearEvent:emptyNew();
	self.gearNum = gearNum;
	self.range = range;
	self.reverseActive = reverseActive;
	self.object = object;
	return self;
end;

function mrGearbox2SetGearEvent:readStream(streamId, connection)
	--both clients and server can receive this event
	local id = streamReadInt32(streamId);
	self.gearNum = streamReadInt32(streamId);
	self.range = streamReadInt32(streamId);
	self.reverseActive = streamReadBool(streamId);
	self.object = networkGetObject(id);
	if self.object~=nil then
		self:run(connection);
	end;
end;

function mrGearbox2SetGearEvent:writeStream(streamId, connection)
	--both clients and server can send this event
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt32(streamId, self.gearNum);
	streamWriteInt32(streamId, self.range);
	streamWriteBool(streamId, self.reverseActive);
end;

function mrGearbox2SetGearEvent:run(connection)
	----both clients and server can "run" this event (after reading it)	
	
	if not connection:getIsServer() then
		--we are the server, and so, we need to broadcast the new gearnum to all the other clients
		self.object:setGear(self.gearNum, self.range, self.reverseActive, false);	
	else
		--we are the client, and so we just receive the new gearnum
		self.object:setGear(self.gearNum, self.range, self.reverseActive, true);	
	end;
end;