--**** V20140508 ****

mrGearbox2 = {};

function mrGearbox2.prerequisitesPresent(specializations) 
	return SpecializationUtil.hasSpecialization(RealisticMotorized, specializations);
end;


function mrGearbox2:load(xmlFile) 

	--print(" ----- ******  loading mrGearbox2 ****** ------");

	self.isRealistic = true;	
	
	--you have to select the next transmission mode here (example : if only one additionnal transmission, the modeNum should be 4)
	--! don't forget to "order" your transmission specialization in the moddesc.xml vehicleType section (T4 first, then T5)
	self.mrGb2TransmissionModeNum = 4;
	self.mrGb2TransmissionModeText = "T4";
	
	self.setNextGear = mrGearbox2.setNextGear;
	self.setGear = mrGearbox2.setGear;
	
	self.doGearShift = mrGearbox2.doGearShift;
	
	self.setGearbox2ModeOn = mrGearbox2.setGearbox2ModeOn;
	self.setGearbox2ModeOff = mrGearbox2.setGearbox2ModeOff;
	
	self.setManualGear3 = RealisticMotorized.setManualGear3;
	
	
	local xmlString = "vehicle.gearbox2";
	
	self.mrGb2ClutchEngagingTime = Utils.getNoNil(getXMLFloat(xmlFile, xmlString .. "#clutchEngagingTimeMs"), 1000); -- 1000 = 1s
	
	self.mrGb2TransmissionEfficiency = Utils.getNoNil(getXMLFloat(xmlFile, xmlString .. "#transmissionEfficiency"), self.realTransmissionEfficiency);
	self.mrGb2TransmissionEfficiencyBackup = self.realTransmissionEfficiency;
	
	self.mrGb2GearTimeToShiftGear = Utils.getNoNil(getXMLFloat(xmlFile, xmlString .. "#gearShiftTimeMs"), 500);
	self.mrGb2GearTimeToShiftHl = Utils.getNoNil(getXMLFloat(xmlFile, xmlString .. "#hlShiftTimeMs"), 250);
	self.mrGb2GearTimeToShiftReverse = Utils.getNoNil(getXMLFloat(xmlFile, xmlString .. "#rShiftTimeMs"), 1000);
		
	self.mrGb2Gears = {};
	local i = 0;
	while true do
		local fwdGearString = xmlString .. string.format(".gears.gear(%d)", i);		
		local spdL = getXMLFloat(xmlFile, fwdGearString .. "#speedL");
		local spdH = getXMLFloat(xmlFile, fwdGearString .. "#speedH");
		if spdL == nil or spdH==nil then
			break;
		end;
		local newGear = {spdH=spdH/3.6,spdL=spdL/3.6};
		table.insert(self.mrGb2Gears, newGear); -- m/s
		i = i + 1;
	end;	
	
	self.mrGb2GearsR = {};
	local i = 0;
	while true do
		local revGearString = xmlString .. string.format(".gearsR.gear(%d)", i);		
		local spdL = getXMLFloat(xmlFile, revGearString .. "#speedL");
		local spdH = getXMLFloat(xmlFile, revGearString .. "#speedH");
		if spdL == nil or spdH==nil then
			break;
		end;
		local newGear = {spdH=spdH/3.6,spdL=spdL/3.6};
		table.insert(self.mrGb2GearsR, newGear); -- m/s
		i = i + 1;
	end;	
	
	--RealisticUtils.testClass("mrGearbox2 - mrGb2Gears", self.mrGb2Gears);
	
	self.mrGb2DefaultForwardGear = Utils.getNoNil(getXMLFloat(xmlFile, xmlString .. ".gears#defaultGear"), 1);
	self.mrGb2DefaultReverseGear = Utils.getNoNil(getXMLFloat(xmlFile, xmlString .. ".gearsR#defaultGear"), 1);
	
	
	
	
	self.mrGb2IsOn = false;
	
	self.mrGb2CurrentGear = 0;
	self.mrGb2CurrentRange = 2; -- 1=forward low range, 2 = forward high range, -1 = reverse
	self.mrGb2MinGear = 1; -- 1 = first gear
	self.mrGb2MaxGear = table.getn(self.mrGb2Gears); -- to be set each time we switch from reverse/forward
	
	self.mrGb2GearShiftingNeeded = false;
	self.mrGb2GearShiftingTime = 0;
	
	self.mrGb2ReverseActive = false;	
	
	--adding the new transmission mode
	self.realTransmissionMode.maxMode = self.mrGb2TransmissionModeNum;
	self.realTransmissionMode.modes[self.mrGb2TransmissionModeNum] = {};
	self.realTransmissionMode.modes[self.mrGb2TransmissionModeNum].enabled = true; -- gearbox2 mode
	self.realTransmissionMode.modes[self.mrGb2TransmissionModeNum].text = self.mrGb2TransmissionModeText;	
  
end;

function mrGearbox2:delete()    
end;

function mrGearbox2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function mrGearbox2:keyEvent(unicode, sym, modifier, isDown)
end;

function mrGearbox2:readStream(streamId, connection)
	self.mrGb2IsOn = streamReadBool(streamId);
	self.mrGb2CurrentGear = streamReadInt32(streamId);
	self.mrGb2CurrentRange = streamReadInt32(streamId);
	self.mrGb2ReverseActive = streamReadBool(streamId);
end;
 
function mrGearbox2:writeStream(streamId, connection)
	streamWriteBool(streamId, self.mrGb2IsOn);	
	streamWriteInt32(streamId, self.mrGb2CurrentGear);
	streamWriteInt32(streamId, self.mrGb2CurrentRange);
	streamWriteBool(streamId, self.mrGb2ReverseActive);	
end;

function mrGearbox2:updateTick(dt)

	if self.isAITractorActivated and self.mrGb2IsOn then
		self:setGearbox2ModeOff();	
	else -- not ai controlled
		if self.realIsMotorStarted then
		
			--new powershift mode = T4
			if self.realTransmissionMode.currentMode==self.mrGb2TransmissionModeNum and self.motor.speedLevel == 0 then
				if not self.mrGb2IsOn then
					self:setGearbox2ModeOn();	
				end;				
			else		
				if self.mrGb2IsOn then
					self:setGearbox2ModeOff();
				end;				
			end;
			
		end;
	end;
	
end;

function mrGearbox2:update(dt)

	if self:getIsActiveForInput(false) then
	
		if self.mrGb2IsOn and self.realIsMotorStarted then		
			if g_gui.currentGui == nil and (self.isMouseActive == nil or not self.isMouseActive) then
				--print(self.time .. " mrGearbox2:update - g_gui.currentGuiName = " .. tostring(g_gui.currentGuiName));				
				if InputBinding.hasEvent(InputBinding.MRGEARBOX2NEUTRAL) then
					if self.mrGb2CurrentRange==0 then
						self:setGear(self.mrGb2CurrentGear, 2, self.mrGb2ReverseActive);
					else
						self:setGear(self.mrGb2CurrentGear, 0, self.mrGb2ReverseActive);
					end;
				elseif InputBinding.hasEvent(InputBinding.MRGEARBOX2REVERSE) then			
					self:setGear(self.mrGb2CurrentGear, self.mrGb2CurrentRange, not self.mrGb2ReverseActive);					
				elseif InputBinding.hasEvent(InputBinding.MRGEARBOX2SHIFTRANGE) then -- high/low range shift
					if self.mrGb2CurrentRange==1 then											
						self:setGear(self.mrGb2CurrentGear, 2, self.mrGb2ReverseActive);
					elseif self.mrGb2CurrentRange==2 then											
						self:setGear(self.mrGb2CurrentGear, 1, self.mrGb2ReverseActive);
					end;				
				elseif InputBinding.hasEvent(InputBinding.MRGEARBOX2SHIFTGEARUP) then
					--RealisticUtils.testClass("g_currentMission.inGameMessage", g_currentMission.inGameMessage);
					--RealisticUtils.testClass("g_currentMission.messages", g_currentMission.messages);
					self:setNextGear(false);
				elseif InputBinding.hasEvent(InputBinding.MRGEARBOX2SHIFTGEARDOWN) then
					self:setNextGear(true);				
				end;
			end;			
		end;
		
	end;
	
	if self.isServer and self.isActive and self.mrGb2IsOn then
		if self.mrGb2GearShiftingNeeded then
			if self.time>=self.mrGb2GearShiftingTime then
				self.mrGb2GearShiftingNeeded = false;
				self:doGearShift();
			end;
		else
			if self.lastAcceleration<0 and self.realGroundSpeed<1 then
				self.realClutchEngaged = false;	
			elseif self.mrGb2CurrentRange==0 then
				self.realParkbrakeIsManual = false;				
			else
				--no auto parkbrake when a gear is engaged
				self.realParkbrakeIsManual = true;
				self.realParkbrakeIsActive = false;
				self.realClutchEngaged = true;	
				if self.realSoundEngineRevFx<=0.9*self.realEngine.idleRpmRatio then -- we want to accelerate but the engine rpm is low
					self.realClutchPercent = 0.1; -- depress the clutch
				elseif self.realClutchPercent<1 then
					self.realClutchPercent = math.min(1, self.realClutchPercent + dt/self.mrGb2ClutchEngagingTime);
				end;
			end;
		end;

		--[[test
		if self.realTestValue==0 then
			self.realParkbrakeIsManual = true;
			self.realParkbrakeIsActive = false;
			self.realClutchEngaged = false;	
		end;]]
		
	end;

end;

function mrGearbox2:draw() 	
	
	if self.mrGb2IsOn then
		setTextBold(false);
		setTextColor(1, 1, 1, 1);
		setTextAlignment(RenderText.ALIGN_LEFT);
		
		local rangeText = "";
		if self.mrGb2CurrentRange==0 then
			rangeText = "N";
		elseif self.mrGb2CurrentRange==1 then
			rangeText = "L";			
		elseif self.mrGb2CurrentRange==2 then
			rangeText = "H";			
		end;			
		
		local gearText = string.format("%1.0f", self.mrGb2CurrentGear)
		if self.mrGb2ReverseActive then
			gearText = gearText .. "-R";
		end;
		
		local rpm = 0;
		
		--if self.isServer then
		--	rpm = self.mrGb2MaxRpm*self.realAvgMotorizedWheelSpd/self.realManualGearMaxSpeed;
		--else
		rpm = self.realSoundEngineRevFx*self.realEngine.ratedRpm;
		--end;
		
		renderText(0.86, 0.70, 0.03, "Range : " .. rangeText);		
		renderText(0.86, 0.67, 0.03, "Gear : " .. gearText);			
		renderText(0.86, 0.64, 0.03, string.format("Rpm : %1.0f", rpm));
	end;
	
end;


function mrGearbox2:setNextGear(gearDown, noEventSend)

	
	if self.isServer then
		--server side : compute the new gear
		--print(self.time .. " mrGearbox2:setNextGear - gearDown=" .. tostring(gearDown) .. " / self.mrGb2CurrentGear=" .. tostring(self.mrGb2CurrentGear));

		local wantedGear = nil;
		
		if gearDown then
			if self.mrGb2CurrentGear>self.mrGb2MinGear then
				wantedGear = self.mrGb2CurrentGear - 1;		
			end;
		else
			if self.mrGb2CurrentGear<self.mrGb2MaxGear then
				wantedGear = self.mrGb2CurrentGear + 1;		
			end;
		end;
		
		if wantedGear~=nil then
			self:setGear(wantedGear, self.mrGb2CurrentRange, self.mrGb2ReverseActive);
		end;	
	end;	
	
	if noEventSend == nil or noEventSend == false then
		if g_server == nil then		
			--client side : tell the server what we want to do (gear up or down)
			g_client:getServerConnection():sendEvent(mrGearbox2SetNextGearEvent:new(self, gearDown));
		end;
	end;

end;


function mrGearbox2:setGear(gearNum, range, reverseActive, noEventSend) -- range : 0 = neutral, 1 = low, 2 = high, -1 = reverse

	--print(self.time .. " mrGearbox2 - setGear - gearNum=" .. tostring(gearNum) .. " - range=" .. tostring(range) .. " - mrGb2CurrentRange = " ..tostring(self.mrGb2CurrentRange));	
	
	if self.isServer then	

		self.mrGb2CurrentGear = gearNum;
	
		if reverseActive~=self.mrGb2ReverseActive  then
		
			self.mrGb2ReverseActive = reverseActive;
			
			--timer to shift the "reverse/forward"
			self.mrGb2GearShiftingNeeded = true;
			self.mrGb2GearShiftingTime = self.time + self.mrGb2GearTimeToShiftReverse;	

			--disengage the clutch during the reverse shifting
			self.realClutchEngaged = false;		

			if reverseActive then
				self.mrGb2MaxGear = table.getn(self.mrGb2GearsR);
				self.mrGb2CurrentGear = self.mrGb2DefaultReverseGear;
			else
				self.mrGb2MaxGear = table.getn(self.mrGb2Gears);
				self.mrGb2CurrentGear = self.mrGb2DefaultForwardGear;
			end;
	
		elseif range~=self.mrGb2CurrentRange then -- range shifting				
			
			self.mrGb2CurrentRange = range;
			
			if range==0 then
				--neutral
				self.realShuttleDirection = 0;
				self.mrGb2GearShiftingNeeded = false;
			else
				--timer to shift the "range"
				self.mrGb2GearShiftingNeeded = true;
				self.mrGb2GearShiftingTime = self.time + self.mrGb2GearTimeToShiftHl;
				
				--disengage the clutch during the "range" shifting
				self.realClutchEngaged = false;
			end;
			
		else -- gear shifting ?					
			
			--timer to set the gear
			self.mrGb2GearShiftingNeeded = true;
			self.mrGb2GearShiftingTime = self.time + self.mrGb2GearTimeToShiftGear;
			
			--disengage the clutch during the gear shifting
			self.realClutchEngaged = false;
			
		end;	
	else
		--client side in mp game
		self.mrGb2CurrentGear = gearNum;
		self.mrGb2CurrentRange = range;
		self.mrGb2ReverseActive = reverseActive;
	end;
	
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			-- server side :  send the new "gear" to all the clients
			g_server:broadcastEvent(mrGearbox2SetGearEvent:new(self, self.mrGb2CurrentGear, self.mrGb2CurrentRange, self.mrGb2ReverseActive), nil, nil, self);
		else
			-- client side : tell the server the gearNum we want it to set
			g_client:getServerConnection():sendEvent(mrGearbox2SetGearEvent:new(self, gearNum, range, reverseActive));
		end;
	end;

end;




function mrGearbox2:setGearbox2ModeOn()

	--print(self.time .. " mrGearbox2:setGearbox2ModeOn");

	self.mrGb2IsOn = true;
	
	if self.isServer then
		self.realDirectInverser = false;
		self.realShuttleIsManual = true;
		self.realUseDefaultShuttle = false;
		self.realClutchEngaged = true;
		
		self.realTransmissionEfficiency = self.mrGb2TransmissionEfficiency;
			
		if self.realShuttleDirection<0 then		
			self:setGear(self.mrGb2DefaultReverseGear, 2, true); -- first gear, H range, reverse
		else
			self:setGear(self.mrGb2DefaultForwardGear, 2, false); -- first gear, H range, forward
		end;
	end;

end;

function mrGearbox2:setGearbox2ModeOff()

	--print(self.time .. " mrGearbox2:setGearbox2ModeOff");

	self.mrGb2IsOn = false;
	
	if self.isServer then
		self.realClutchEngaged = true;	
		self:setManualGear3(false);
		self.mrGb2GearShiftingNeeded = false;
		self.realTransmissionEfficiency = self.mrGb2TransmissionEfficiencyBackup;
	end;
	
	self.realParkbrakeIsManual = false;
	
end;


function mrGearbox2:doGearShift()

	--print(self.time .. " mrGearbox2:doGearShift - currentGear=" .. tostring(self.mrGb2CurrentGear));

	--only the server should call this
	
	
	self.realClutchEngaged = true;	
	self.realClutchPercent = math.min(0.5, 0.1*self.realGroundSpeed);
	
	local gearMaxSpeed = 0;
	
	if self.mrGb2ReverseActive then	
		self.realShuttleDirection = -1;
		if self.mrGb2CurrentRange==1 then
			gearMaxSpeed = self.mrGb2GearsR[self.mrGb2CurrentGear].spdL;
		else
			gearMaxSpeed = self.mrGb2GearsR[self.mrGb2CurrentGear].spdH;
		end;
	else
		self.realShuttleDirection = 1;
		if self.mrGb2CurrentRange==1 then
			gearMaxSpeed = self.mrGb2Gears[self.mrGb2CurrentGear].spdL;
		else
			gearMaxSpeed = self.mrGb2Gears[self.mrGb2CurrentGear].spdH;
		end;
	end;
	
	--local gearMinSpeedForMaxPower = gearMaxSpeed * self.mrGb2MinRpmAtMaxPower / self.mrGb2MaxRpm;--m/s	
	
	
	if self.mrGb2CurrentRange==0 then
		--keep the neutral state
		self.realShuttleDirection = 0;
		self.realClutchEngaged = false;
	end;
	
	--print(self.time .. " mrGearbox2:doGearShift - "..string.format("mrGb2MinMaxRpmRatio=%1.2f", self.mrGb2MinMaxRpmRatio) .. string.format(" gearMinSpeedForMaxPower=%1.2f",gearMinSpeedForMaxPower)..string.format(" gearMaxSpeed=%1.2f", gearMaxSpeed));
	
	self:setManualGear3(true, gearMaxSpeed);	
	
end;