T150davlenie = {};

function T150davlenie.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function T150davlenie:load(xmlFile)
	self.drehzahlnadel4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drehzahlnadel4#index"));
	self.tachonadel4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tachonadel4#index"));
	self.fensterOpen = false;
end;

function T150davlenie:delete()
end;

function T150davlenie:readStream(streamId, connection)
end;

function T150davlenie:writeStream(streamId, connection)
end;

function T150davlenie:mouseEvent(posX, posY, isDown, isUp, button)
end;

function T150davlenie:keyEvent(unicode, sym, modifier, isDown)
end;

function T150davlenie:update(dt)
	if self.isMotorStarted then
        local kmh = math.min(5, math.max(0, self.lastSpeed*self.speedDisplayScale*15000));
        local rotateDrehzahlnadel4 = (((kmh / 25)*940) +1);
		local rotateTachonadel4 = (((kmh / 25)*-100) +200);
		setRotation(self.drehzahlnadel4, 0, 0, Utils.degToRad( rotateDrehzahlnadel4));
		setRotation(self.tachonadel4, 0, 0, Utils.degToRad( rotateTachonadel4));
    else
        setRotation(self.drehzahlnadel4, 0, 0, 0);
        setRotation(self.tachonadel4, 0, 0, 0);
    end;	
end;

function T150davlenie:draw()
end;

function T150davlenie:validateAttacherJoint(implement, jointDesc, dt)
end;

function T150davlenie:onLeave()
end;

function T150davlenie:onEnter()
end;
