K700A1 = {};

function K700A1.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function K700A1:load(xmlFile)
	self.drehzahlnadel1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drehzahlnadel1#index"));
	self.tachonadel1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tachonadel1#index"));
	self.fensterOpen = false;
end;

function K700A1:delete()
end;

function K700A1:readStream(streamId, connection)
end;

function K700A1:writeStream(streamId, connection)
end;

function K700A1:mouseEvent(posX, posY, isDown, isUp, button)
end;

function K700A1:keyEvent(unicode, sym, modifier, isDown)
end;

function K700A1:update(dt)
	if self.isMotorStarted then
        local kmh = math.min(100, math.max(0, self.lastSpeed*self.speedDisplayScale*3600));
        local rotateDrehzahlnadel1 = (((kmh / 25)*-36) -12);
		local rotateTachonadel1 = (((kmh / 25)*11) +40);
		setRotation(self.drehzahlnadel1, 0, 0, Utils.degToRad( rotateDrehzahlnadel1));
		setRotation(self.tachonadel1, 0, 0, Utils.degToRad( rotateTachonadel1));
    else
        setRotation(self.drehzahlnadel1, 0, 0, 0);
        setRotation(self.tachonadel1, 0, 0, 0);
    end;	
end;

function K700A1:draw()
end;

function K700A1:validateAttacherJoint(implement, jointDesc, dt)
end;

function K700A1:onLeave()
end;

function K700A1:onEnter()
end;
