engineBrake = {};

function engineBrake.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;
function engineBrake:load(xmlFile)
-- Configure Outside Engine Brake Sound
	local engineBrakeSound3d  = getXMLString(xmlFile, "vehicle.engineBrakeSound3d#file");
	if engineBrakeSound3d  ~= nil and engineBrakeSound3d  ~= "" then
		engineBrakeSound3d  = Utils.getFilename(engineBrakeSound3d, self.baseDirectory);
		self.engineBrakeSound3dRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineBrakeSound3d#radius"), 35);
		self.engineBrakeSound3dInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineBrakeSound3d#innerRadius"), 10);
		self.engineBrakeSound3dVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineBrakeSound3d#volume"), 1);
		self.engineBrakeSound3d = createAudioSource("engineBrakeSound3d", engineBrakeSound3d, self.engineBrakeSound3dRadius, self.engineBrakeSound3dInnerRadius, self.engineBrakeSound3dVolume, 0);
		link(self.components[1].node, self.engineBrakeSound3d);
	end;
	setVisibility(self.engineBrakeSound3d, false);
-- Configure Inside Engine Brake Sound
	local engineBrakeSound = getXMLString(xmlFile, "vehicle.engineBrakeSound#file");
	if engineBrakeSound ~= nil and engineBrakeSound ~= "" then
		engineBrakeSound = Utils.getFilename(engineBrakeSound, self.baseDirectory);
		self.engineBrakeSound = createSample("engineBrakeSound");
		loadSample(self.engineBrakeSound, engineBrakeSound, false);
		self.engineBrakeSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineBrakeSound#pitchOffset"), 0);
		self.engineBrakeSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineBrakeSound#pitchScale"), 0.05);
		self.engineBrakeSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineBrakeSound#pitchMax"), 2.0);
		self.engineBrakeSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineBrakeSound#volume"), 10.0);
		self.engineBrakeSoundEnabled = false;
	end;
-- Configure Variables
	self.engineBrake = false;
end;

function engineBrake:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.ENGINEBRAKE) then
			self.engineBrake = not self.engineBrake
			--self:engineBrakeState(self.engineBrake, self.engineBrakeSoundEnabled);
		end;
	end;
-- Engine Brake
	if self.engineBrake then
	self.motor.brakeForce = 15;
	-- Set engineBrakeSound pitch based on Engine RPM
		local alpha = 0.9; --0.9
		local roundPerMinute = self.lastRoundPerMinute*alpha + (1-alpha)*(self.motor.lastMotorRpm-self.motor.minRpm);
		self.lastRoundPerMinute = roundPerMinute;
		local roundPerSecond = roundPerMinute / 60;
		if self.engineBrakeSound ~= nil then
			--setSamplePitch(self.engineBrakeSound, math.min(self.engineBrakeSoundPitchOffset + self.engineBrakeSoundPitchScale*math.abs(roundPerSecond), self.engineBrakeSoundPitchMax));
			setSampleVolume(self.engineBrakeSound, math.min(0.5 + 0.1*math.abs(roundPerSecond), 10));
		end;
	--
		local input = 0;
		if self.axisForward ~= nil then
			input = self.axisForward;
		end;
		if self.engineBrakeSound ~= nil then
			local maxRpm = self.motor:getMaxRpm();
			local enoughRpm = false;
			if self.motor.lastMotorRpm > (maxRpm/2.5) then --2
				enoughRpm = true;
			end;
			if self.engineBrakeSoundEnabled and input == -1 then
				stopSample(self.engineBrakeSound)
				self.engineBrakeSoundEnabled = false;
			end;
			if input == -1 and enoughRpm then
				-- if we drive fast enough, we need to run the exhaustbrake the next time we release the throttle
				self.engineBrakeSoundEnabled = false;
			end;
			if input == 0 and not self.engineBrakeSoundEnabled and enoughRpm then
				-- play the exhaustbrake sound if we drive fast enough and release throttle
				if self:getIsActiveForSound() then
					playSample(self.engineBrakeSound, 1, self.engineBrakeSoundVolume, 0);
				end;
				self.engineBrakeSoundEnabled = true;
			end;
		end;
	else
		self.motor.brakeForce = 30;
	end;
end;
function engineBrake:draw()
	if self.engineBrake then
		g_currentMission:addHelpButtonText(g_i18n:getText("ENGINEBRAKE_ON"),InputBinding.ENGINEBRAKE);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("ENGINEBRAKE_OFF"),InputBinding.ENGINEBRAKE);
	end;
end;

function engineBrake:mouseEvent(posX, posY, isDown, isUp, button)
end;

function engineBrake:keyEvent(unicode, sym, modifier, isDown)
end;

-- Motorized.load = Utils.appendedFunction(Motorized.load, engineBrake.load);
-- Motorized.update = Utils.appendedFunction(Motorized.update, engineBrake.update);
-- Motorized.draw = Utils.appendedFunction(Motorized.draw, engineBrake.draw);


 function engineBrake:delete()
	 if self.engineBrakeSoundEnabled then
		stopSample(self.engineBrakeSound);
	 end;
 end;
-- function engineBrake:readStream(streamId, connection)
	-- self.engineBrakeSoundEnabled = streamReadBool(streamId);
-- end;
-- function engineBrake:writeStream(streamId, connection)
	-- streamWriteBool(streamId, self.engineBrakeSoundEnabled);
-- end;
