RealisticSteerableSpeedLimiterEvent = {};
RealisticSteerableSpeedLimiterEvent_mt = Class(RealisticSteerableSpeedLimiterEvent, Event);

InitEventClass(RealisticSteerableSpeedLimiterEvent, "RealisticSteerableSpeedLimiterEvent");

 
function RealisticSteerableSpeedLimiterEvent:emptyNew()
	local self = Event:new(RealisticSteerableSpeedLimiterEvent_mt);
	self.className="RealisticSteerableSpeedLimiterEvent";
	return self;
end;

function RealisticSteerableSpeedLimiterEvent:new(object, increaseSpeedLimit)
	local self = RealisticSteerableSpeedLimiterEvent:emptyNew();
	self.increaseSpeedLimit = increaseSpeedLimit;
	self.object = object;
	return self;
end;

function RealisticSteerableSpeedLimiterEvent:readStream(streamId, connection)
	--only the server get the info
	local id = streamReadInt32(streamId);
	self.increaseSpeedLimit = streamReadBool(streamId);
	self.object = networkGetObject(id);
	if self.object~=nil then -- protection against not valid "object vehicle" (exemple : the vehicle has been sold while the event is sent)
		self:run(connection);
	end;
end;

function RealisticSteerableSpeedLimiterEvent:writeStream(streamId, connection)
	--only the client send the event
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.increaseSpeedLimit);
end;

function RealisticSteerableSpeedLimiterEvent:run(connection)
	--only the server "run" after getting the info
	if self.object.motor.speedLevel>0 then -- avoid trying to modify the speedlimit if no speedlevel is set (if the speedlevel is not synchronized yet between the client and the server)
		self.object:realSetSpeedLimiterValue(self.increaseSpeedLimit);
	end;
end;