--
-- internalclod
-- Specialization for physically adapting Camera
--
-- @author  Knagsted
-- @date  3/04/10
--
--modifing for open-close door
-- --by Clod @ TIF-http://forum.tractor-italia.net
--@ 23-11-2011
---
---fix for Fendt 900 
---- Ago-Systemtech @ TIF-http://forum.tractor-italia.net
---@ 25/01/2012
---fix for LS13 by Clod 
-- --by Clod @ TIF-http://forum.tractor-italia.net
--@ 16-12-2012
--@DATE  14/06/13 ADD FIX FOR USE JD 7R SERIES Ago-Systemtech: https://www.facebook.com/ago.systemtech (Modhoster Team)
------ free for non commercial-usage-----

internalclodtif = {};

function internalclodtif.prerequisitesPresent(specializations)
   print("specialization Real internal sound by Clod loaded");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
	
end;

function internalclodtif:load(xmlFile)
	self.intCameraIndex = 1;
	
	
	
	
	local motorStartSoundInternal = getXMLString(xmlFile, "vehicle.motorStartSoundInternal#file");
	if motorStartSoundInternal ~= nil and motorStartSoundInternal ~= "" then
        motorStartSoundInternal = Utils.getFilename(motorStartSoundInternal, self.baseDirectory);
        self.motorStartSoundInternal = createSample("motorStartSoundInternal");
        loadSample(self.motorStartSoundInternal, motorStartSoundInternal, false);
        self.motorStartSoundInternalPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStartSoundInternal#pitchOffset"), 0);
        self.motorStartSoundInternalVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStartSoundInternal#volume"), 1.0);
    end;

    local motorStopSoundInternal = getXMLString(xmlFile, "vehicle.motorStopSoundInternal#file");
    if motorStopSoundInternal ~= nil and motorStopSoundInternal ~= "" then
        motorStopSoundInternal = Utils.getFilename(motorStopSoundInternal, self.baseDirectory);
        self.motorStopSoundInternal = createSample("motorStopSoundInternal");
        loadSample(self.motorStopSoundInternal, motorStopSoundInternal, false);
        self.motorStopSoundInternalPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSoundInternal#pitchOffset"), 0);
        self.motorStopSoundInternalVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSoundInternal#volume"), 1.0);
    end;

    local motorSoundInternal = getXMLString(xmlFile, "vehicle.motorSoundInternal#file");
    if motorSoundInternal ~= nil and motorSoundInternal ~= "" then
        motorSoundInternal = Utils.getFilename(motorSoundInternal, self.baseDirectory);
        self.motorSoundInternal = createSample("motorSoundInternal");
        loadSample(self.motorSoundInternal, motorSoundInternal, false);
        self.motorSoundInternalPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#pitchOffset"), 0);
        self.motorSoundInternalPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#pitchScale"), 0.05);
        self.motorSoundInternalPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#pitchMax"), 2.0);
        self.motorSoundInternalVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#volume"), 1.0);
    end;

    local motorSoundInternalRun = getXMLString(xmlFile, "vehicle.motorSoundInternalRun#file");
    if motorSoundInternalRun ~= nil and motorSoundInternalRun ~= "" then
        motorSoundInternalRun = Utils.getFilename(motorSoundInternalRun, self.baseDirectory);
        self.motorSoundInternalRun = createSample("motorSoundInternalRun");
        loadSample(self.motorSoundInternalRun, motorSoundInternalRun, false);
        self.motorSoundInternalRunPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#pitchOffset"), 0);
        self.motorSoundInternalRunPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#pitchScale"), 0.05);
        self.motorSoundInternalRunPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#pitchMax"), 2.0);
        self.motorSoundInternalRunVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#volume"), 1.0);
    end;
	
    local powershiftMotorSoundInternal = getXMLString(xmlFile, "vehicle.motorSoundInternal#file");
    if powershiftMotorSoundInternal ~= nil and powershiftMotorSoundInternal ~= "" then
        powershiftMotorSoundInternal = Utils.getFilename(powershiftMotorSoundInternal, self.baseDirectory);
        self.powershiftMotorSoundInternal = createSample("powershiftMotorSoundInternal");
        loadSample(self.powershiftMotorSoundInternal, powershiftMotorSoundInternal, false);
        self.powershiftMotorSoundInternalPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#pitchOffset"), 0);
        self.powershiftMotorSoundInternalPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#pitchScale"), 0.05);
        self.powershiftMotorSoundInternalPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#pitchMax"), 2.0);
        self.powershiftMotorSoundInternalVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#volume"), 1.0);
    end;

    local powershiftMotorSoundInternalRun = getXMLString(xmlFile, "vehicle.motorSoundInternalRun#file");
    if powershiftMotorSoundInternalRun ~= nil and powershiftMotorSoundInternalRun ~= "" then
        powershiftMotorSoundInternalRun = Utils.getFilename(powershiftMotorSoundInternalRun, self.baseDirectory);
        self.powershiftMotorSoundInternalRun = createSample("powershiftMotorSoundInternalRun");
        loadSample(self.powershiftMotorSoundInternalRun, powershiftMotorSoundInternalRun, false);
        self.powershiftMotorSoundInternalRunPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#pitchOffset"), 0);
        self.powershiftMotorSoundInternalRunPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#pitchScale"), 0.05);
        self.powershiftMotorSoundInternalRunPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#pitchMax"), 2.0);
        self.powershiftMotorSoundInternalRunVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#volume"), 1.0);
    end;
	
	openSoundFile = Utils.getFilename("sounds/7RcloseDoor.ogg", self.baseDirectory);
    self.openDoorSoundId = createSample("JD7Rdoorsound");
    loadSample(self.openDoorSoundId, openSoundFile, false);
    self.openPlaying = false;
	
	clouseSoundFile = Utils.getFilename("sounds/7RopenDoor.ogg", self.baseDirectory);
    self.clouseDoorSoundId = createSample("JD7Rdoorsound");
    loadSample(self.clouseDoorSoundId, clouseSoundFile, false);
    self.clousePlaying = false
		
	self.originalMotorStartSound = self.motorStartSound;
	self.originalMotorStopSound = self.motorStopSound;
	self.originalMotorSound = self.motorSound;
	self.originalMotorSoundRun = self.motorSoundRun;
	
	self.originalPowershiftMotorSound = self.powershiftMotorSound;
	self.originalPowershiftMotorSoundRun = self.powershiftMotorSoundRun;
	
	--[[if table.getn(self.wheels) > 0 then
		if self.camIndex == self.intCameraIndex then
			self.motorStartSound = self.motorStartSoundInternal;
			self.motorStopSound = self.MotorStopSoundInternal;
			self.motorSound = self.MotorSoundInternal;
			self.motorSoundRun =self.MotorSoundInternalRun;
		else
			self.motorStartSound = self.originalMotorStartSound;
			self.motorStopSound = self.originalMotorStopSound;
			self.motorSound = self.originalMotorSound;
			self.motorSoundRun =self.originalMotorSoundRun;
		end;
	end;]]
	
	self.soundSwitched = true;
	self.motorStartHandled = false;
	
	
	
	self.powershiftMotorSound = self.powershiftMotorSoundInternal;
	self.powershiftMotorSoundRun =self.powershiftMotorSoundInternalRun;
	self.motorSound = self.motorSoundInternal;
	self.motorSoundRun =self.motorSoundInternalRun;
	
	--by Clod @ TIF-http://forum.tractor-italia.net
	local oSX = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.osx#index"));
    if oSX ~= nil then
        self.osx = {};
        self.osx.node = oSX;
		end;
		
		
	local oRX = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.orx#index"));
    if oRX ~= nil then
        self.orx = {};
        self.orx.node = oRX;
		end;			
	
	self.dehihoho1=true;
	self.dehihoho2=true;

	self.p=false;
	--by Clod @ TIF-http://forum.tractor-italia.net
end;

function internalclodtif:delete()
end;

function internalclodtif:mouseEvent(posX, posY, isDown, isUp, button)
end;

function internalclodtif:keyEvent(unicode, sym, modifier, isDown)

	
end;

function internalclodtif:update(dt)
	if InputBinding.hasEvent(InputBinding.CAMERA_SWITCH) and self.isEntered then
		self.soundSwitched = true;
	end;
	--by Clod @ TIF-http://forum.tractor-italia.net
   
	   local x, y, z = getRotation(self.osx.node);
			
			if y < Utils.degToRad(1) and y > Utils.degToRad(0.01)  then
			self.dehihoho1=true;
			self.soundSwitched=true;
			self.soundOpen = true;
			self.soundClose = false;
			else
			
			
			if y > Utils.degToRad(1) and y < Utils.degToRad(3)  then
			self.dehihoho1=false;
			self.soundSwitched=true;
			self.soundOpen = false;
			self.soundClose = true;
			end;
			end;
			
			
			
		
		 local xz, yz, zz = getRotation(self.orx.node);
			
			if xz < Utils.degToRad(1) and  xz > Utils.degToRad(0.01) then
			self.dehihoho2=true;
			self.soundSwitched=true;
			self.soundOpen = true;
			self.soundClose = false;
			else
			
			if xz > Utils.degToRad(1) and xz < Utils.degToRad(3)  then
			self.dehihoho2=false;
			self.soundSwitched=true;
			self.soundOpen = false;
			self.soundClose = true;
			end;
			end;
			
			
	  
	 
	 
		  
	  
	--by Clod @ TIF-http://forum.tractor-italia.net
	
		
	if self.soundOpen then
       if not self.openPlaying then
            playSample(self.openDoorSoundId, 1, 3, 3);
            self.openPlaying = true;
        end;
       
    else
        if self.openPlaying then
            stopSample(self.openDoorSoundId);
            self.openPlaying = false;
        end;
         
    end;
	
	if self.soundClose then
       if not self.clousePlaying then
            playSample(self.clouseDoorSoundId, 1, 3, 3);
            self.clousePlaying = true;
        end;
       
    else
        if self.clousePlaying then
            stopSample(self.clouseDoorSoundId);
            self.clousePlaying = false;
        end;
         
    end;
	  
	  --------------------------------------
	
	
	
	
	
	
		if self.playMotorSoundTime ~= nil and self.playMotorSoundTime <= self.time and not self.motorStartHandled then
		self.motorStartHandled = true;
		self.soundSwitched = true;
	end;
	
	if self.soundSwitched then
		if table.getn(self.wheels) > 0 then
			stopSample(self.motorSound);
			stopSample(self.motorSoundRun);
			--stopSample(self.motorStartSound);
			--stopSample(self.motorStopSound);
			stopSample(self.powershiftMotorSound);
			stopSample(self.powershiftMotorSoundRun);
					
			if not self.enabledPowershiftGearBox then
				if self.camIndex == self.intCameraIndex and self.dehihoho1 and self.dehihoho2  then
                 			
					self.motorStartSound = self.motorStartSoundInternal;
					self.motorStopSound = self.motorStopSoundInternal;
					self.motorSound = self.motorSoundInternal;
					self.motorSoundRun =self.motorSoundInternalRun;
				else								
					self.motorStartSound = self.originalMotorStartSound;
					self.motorStopSound = self.originalMotorStopSound;
					self.motorSound = self.originalMotorSound;
					self.motorSoundRun =self.originalMotorSoundRun;
				end;
				
				
				if self.isMotorStarted then
					if self:getIsActiveForSound() then
						if self.motorSound ~= nil then
						 
							playSample(self.motorSound, 0, self.motorSoundVolume, 0);
							self.playMotorSound = false;
							

							if self.motorSoundRun ~= nil then
								playSample(self.motorSoundRun, 0, 0.0, 0);
							end;
						end;
					end;
				end;
			else
				if self.camIndex == self.intCameraIndex and self.dehihoho1 and self.dehihoho2  then
					
					self.motorStartSound = self.motorStartSoundInternal;
					self.motorStopSound = self.motorStopSoundInternal;
					self.powershiftMotorSound = self.powershiftMotorSoundInternal;
					self.powershiftMotorSoundRun =self.powershiftMotorSoundInternalRun;
				else
					self.motorStartSound = self.originalMotorStartSound;
					self.motorStopSound = self.originalMotorStopSound;
					self.powershiftMotorSound = self.originalPowershiftMotorSound;
					self.powershiftMotorSoundRun =self.originalPowershiftMotorSoundRun;
				end;
				
				
				
				if self.isMotorStarted then
					--renderText(0.5, 0.5, 0.0250, string.format("about to play"));
					if self:getIsActiveForSound() then
						--renderText(0.5, 0.6, 0.0250, string.format("almost playing"));
						if self.powershiftMotorSound ~= nil and self.playMotorSoundTime <= self.time then
							playSample(self.powershiftMotorSound, 0, self.powershiftMotorSoundVolume, 0);
							self.playPowershiftMotorSound = false;

							if self.powershiftMotorSoundRun ~= nil then
								playSample(self.powershiftMotorSoundRun, 0, 0.0, 0);
							end;
							--renderText(0.5, 0.7, 0.0250, string.format("playing"));
						end;
					end;
				end;
			end;
		end;
		self.soundSwitched = false;
	end;
end;


function internalclodtif:onLeave()
   
	self.soundSwitched = true;
    Motorized.stopSounds(self);
end;

function internalclodtif:onEnter()
   
	self.soundSwitched = true;
end;

function internalclodtif:startMotor()
	--renderText(0.5, 0.1, 0.0250, string.format("start engine"));
	self.motorStartHandled = false;
end;

function internalclodtif:draw()
end;

