--
-- JD7230RFAN
-- Specialization FAN class for JD7230RFAN
-- V1.0
-- @author  Ago-Systemtech
-- @date  26/06/2013
--	for use this specialization on your mods...
-- 	@ Ago-Systemtech: https://www.facebook.com/ago.systemtech (Modhoster Team)
--	free for non commercial-usage! -------------

JD7230RFAN = {};
function JD7230RFAN.prerequisitesPresent(specializations)

    return true;
end;
function JD7230RFAN:load(xmlFile)

	local StartCofano = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Cofano#index"));
	if StartCofano ~= nil then
	    self.StartCofano = StartCofano;
	end;
	
	
	openHodSoundFile = Utils.getFilename("sound/closeHod.ogg", self.baseDirectory);
    self.openSoundId = createSample("hodsound");
    loadSample(self.openSoundId, openHodSoundFile, false);
    self.openhod = false;
	
	clouseHodSoundFile = Utils.getFilename("sound/openHod.ogg", self.baseDirectory);
    self.clouseSoundId = createSample("hodsound");
    loadSample(self.clouseSoundId, clouseHodSoundFile, false);
    self.closehod = false;

	-----------------SOUND VENTOLA------------------
		local fanSound = getXMLString(xmlFile, "vehicle.fanSound#file");
		if fanSound ~= nil and fanSound ~= "" then
			fanSound = Utils.getFilename(fanSound, self.baseDirectory);
			self.fanSound = createSample("fanSound");
			loadSample(self.fanSound, fanSound, false);
			self.fanSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fanSound#pitchOffset"), 1);
			self.fanSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fanSound#volume"), 1);
			setSamplePitch(self.fanSound, self.fanSoundPitchOffset);
			self.fanSoundTime = 0;
			self.fanSoundEnabled = false;
      end;
	self.fanLed = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.fanLed#index"));

end;
function JD7230RFAN:delete() 
	 if self.fanSound ~= nil then
          delete(self.fanSound);
     end;
   
end;
function JD7230RFAN:readStream(streamId, connection)
		
end;
function JD7230RFAN:writeStream(streamId, connection)
	
end;
function JD7230RFAN:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
     return BaseMission.VEHICLE_LOAD_OK;
end;

function JD7230RFAN:mouseEvent(posX, posY, isDown, isUp, button)
end;
function JD7230RFAN:keyEvent(unicode, sym, modifier, isDown)
			
end;

function JD7230RFAN:update(dt)
	 
	if self.isMotorStarted then
  
         if self:getIsActiveForSound() then
 
            if self.fanSound ~= nil and not self.fanSoundEnabled and self.fanSoundTime <= self.time then
                  playSample(self.fanSound, 1, self.fanSoundVolume, 0);
                  self.fanSoundTime = self.time + 240000;
                  self.fanSoundEnabled = true;
	
			end;
			if self.fanLed ~= nil then
				if self.fanSoundEnabled then
					setVisibility(self.fanLed, true);
				else
					setVisibility(self.fanLed, false);
				end;
			end
		end;
	end;
	
	
	if self.soundOpenhod then
       if not self.openhod then
            playSample(self.openSoundId, 1, 3, 3);
            self.openhod = true;
        end;
       
    else
        if self.openhod then
            stopSample(self.openSoundId);
            self.openhod = false;
        end;
         
    end;
	
	if self.soundClosehod then
       if not self.closehod then
            playSample(self.clouseSoundId, 1, 3, 3);
            self.closehod = true;
        end;
       
    else
        if self.closehod then
            stopSample(self.clouseSoundId);
            self.closehod = false;
        end;
         
    end;

	if g_currentMission.player ~= nil then
		------------cofano----------
		local nearestDistance = 2;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		
		local px, py, pz = getWorldTranslation(self.StartCofano); 
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.openCofano = true;
		else
			self.openCofano = false;
		end; 
		
	end;
	
	-----------------
	if self.openCofano then
	if InputBinding.hasEvent(InputBinding.Cofano) then
			if self.animationParts[1].clipEndTime then
				self:setAnimationTime(1, self.animationParts[1].offSet);
				self.soundOpenhod = true;
				self.soundClosehod = false;
			elseif self.animationParts[1].clipStartTime then
				self:setAnimationTime(1, self.animationParts[1].animDuration);
				self.soundOpenhod = false;
				self.soundClosehod = true;
			end;
		end;
	end;
	
		if self.openCofano then
		if self.animationParts[1].clipStartTime then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Aprire_Cofano"), self.typeDesc), InputBinding.Cofano);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Chiudere_Cofano"), self.typeDesc), InputBinding.Cofano);
			end;
		end
		
	
	
		if self.setAnimationTime ~= nil then
		if self.isMotorStarted then
			self:setAnimationTime(2, 1);
		else
			self:setAnimationTime(2, 0);
		end;
		end;
end;

function JD7230RFAN:updateTick(dt)

end;

function JD7230RFAN:draw()
 	
end;

function JD7230RFAN:stopSounds()
	if self.isClient then
		 if self.fanSoundEnabled then
              stopSample(self.fanSound);
              self.fanSoundEnabled = false;
          end;
	end;
  setVisibility(self.fanLed, false);	
end;

function JD7230RFAN:startMotor()
  
		self.fanSoundTime = self.time + 240000;

end;

function JD7230RFAN:stopMotor()			
      JD7230RFAN.stopSounds(self);
end;
function JD7230RFAN:onEnter()
 
end;

function JD7230RFAN:onLeave()
		JD7230RFAN.stopSounds(self);          
end;

