--
-- extrapipeSound
-- Specialization for extrapipeSound
--
-- @version:	v1.0
-- @author:  	janba75
--

extrapipeSound = {};

function extrapipeSound.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function extrapipeSound:load(xmlFile)
    self.turnTimeout = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.turnTimeout"), 1500);
    local extrapipeSound  = getXMLString(xmlFile, "vehicle.extrapipeSound#file");
    if extrapipeSound  ~= nil and extrapipeSound  ~= "" then
        extrapipeSound  = Utils.getFilename(extrapipeSound, self.baseDirectory);
        self.extrapipeSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.extrapipeSound#pitchOffset"), 0);
        self.extrapipeSoundRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.extrapipeSound#radius"), 50);
        self.extrapipeSoundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.extrapipeSound#innerRadius"), 10);
        self.extrapipeSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.extrapipeSound#volume"), 1);
        self.extrapipeSound = createAudioSource("extrapipeSound", extrapipeSound, self.extrapipeSoundRadius, self.extrapipeSoundInnerRadius, self.extrapipeSoundVolume, 0);
        link(self.components[1].node, self.extrapipeSound);
        setVisibility(self.extrapipeSound, false);
    end;
end;
function extrapipeSound:delete()
end;
function extrapipeSound:readStream(streamId, connection)
end;
function extrapipeSound:writeStream(streamId, connection)
end;
function extrapipeSound:mouseEvent(posX, posY, isDown, isUp, button)
end;
function extrapipeSound:keyEvent(unicode, sym, modifier, isDown)
end;
function extrapipeSound:update(dt)
end;
function extrapipeSound:updateTick(dt)
    if self.pipeIsUnloading == true then
       self.pipeParticleDeactivateTime = self.time + 2000;
          setVisibility(self.extrapipeSound, true); 
    end;
    if self.pipeParticleDeactivateTime <= self.time == true then
            setVisibility(self.extrapipeSound, false);
    end;  
end;
function extrapipeSound:draw()
end;
function extrapipeSound:detachImplement(implementIndex)
end;

function extrapipeSound:attachImplement(implement)
end;

function extrapipeSound:startThreshing()
end;

