--
-- Conspeed
-- Specialization for Conspeed
--
-- @author  	Manuel Leithner
-- @version 	v1.0
-- @date  		02/11/11
-- @history:	v1.0 - Initial version
--
-- free for noncommerical-usage
--

e295 = {};

function e295.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function e295:load(xmlFile)
	
	self.e295 = {};
	self.e295.speedScaleTime = 5000;
	self.e295.speed = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.e295#speed"), 11);
	self.e295.rollSpeedBackup = self.rollNodes[1].speed;
	for _, rollNode in pairs(self.rollNodes) do
		rollNode.backup = rollNode.speed;
		rollNode.speed = 0;
	end;	
end;

function e295:delete()
end;

function e295:readStream(streamId, connection)
end;

function e295:writeStream(streamId, connection)
end;

function e295:mouseEvent(posX, posY, isDown, isUp, button)
end;

function e295:keyEvent(unicode, sym, modifier, isDown)
end;

function e295:update(dt)
	Utils.setEmittingState(self.threshingParticleSystems, (self.reelStarted and self.lastCutterAreaBiggerZero));
	
	if self:getIsActive() and self.reelStarted then	
		local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.e295.speed, 1.5));
	
		for _, rollNode in pairs(self.rollNodes) do
			local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {rollNode.backup * percent}, {0}, 1, self.e295.speedScaleTime, dt, false);
			rollNode.speed = rollSpeed[1];
		end;
	else
		if self.rollNodes[1].speed ~= 0 then
			local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.e295.speed, 1.5));
		
			for _, rollNode in pairs(self.rollNodes) do
				local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {rollNode.backup * percent}, {0}, 1, self.e295.speedScaleTime*1.5, dt, true);
				rollNode.speed = rollSpeed[1];
				rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
			end;
		end;
	end;	
end;

function e295:updateTick(dt)
end;

function e295:draw()
end;

function e295:onAttach(attacherVehicle)
end;

function e295:onDetach()	
end; 

function e295:onStartReel()
end;

function e295:setFoldDirection(direction, noEventSend)
end;