--[[************************************************************************************************************************************************************
	
	strawChopper v1.2
	
	06/2013 by Saty / http://forum.lsczech.cz
	
****************************************************************************************************************************************************************
	
	(EN) INFO
	
	Free for use on mods. Modifications only with my permission !
	
****************************************************************************************************************************************************************
	
	(CZ) INFO
	
	Pro volne pouziti v modech. ZAKAZ modifikaci bez meho souhlasu !
	
	--------------------------------------------------------------------------------------------------------------------------------------------------------	
	
	Zapis do XML souboru stroje :
	*****************************
	
	( [foldingAnimation] animace otevreni/zavreni drtice -- NEMUSI BYT ZADANO -- jinak zadavat klasicky jako jine animace )
	( [indicator] kontrolka spusteni drtice na palubni desce -- NEMUSI BYT ZADANO -- [node] index kontrolky )
	( [turnOnSound] zvuk pri behu drtice -- NEMUSI BYT ZADANO -- [file] cesta k souboru, [pitchoffset] rychlost prehravani, [volume] hlasitost )
	( [foldingSound] zvuk pri animaci drtice -- NEMUSI BYT ZADANO -- [file] cesta k souboru, [pitchoffset] rychlost prehravani, [volume] hlasitost, [volume3D] hlasitost pri vystoupeni, [innerRadius] polomer vzdalenosti plne hlasitosi pri vystoupeni, [radius] polomer vzdalenosti kam az je slyset zvuk pri vystoupeni )
	<chopper>
		<foldingAnimation name="chopper" />
		<indicator node="0>21|15|1" />
		<turnOnSound file="" pitchOffset="1" volume="1" volume3D="1" innerRadius="2" radius="10" />
		<foldingSound file="" pitchOffset="1" volume="1" />
	</chopper>
	
	<animations>
		<!-- chopper ON/OFF animation -->
		<animation name="chopper">
			<part node="0>25|2" startTime="0" endTime="1" startRot="0 0 0" endRot="90 0 0" />
		</animation>
	</animations>
	
	( Rotacni casti drtice -- NEMUSI BYT ZADANO -- jinak libovolny pocet )
	( [node] index casti, [rotSpeed] rychlost otaceni (- je reverzni pohyb), [rotAxis] osa otaceni (1=X; 2=Y; 3=Z; nezadano=Y) )
	( [acceleration] hodnota urcuje jak rychle se vsechny dane casti po zapnuti roztoci (pri nezadani defaultni hodnota "1" = okamzite roztoceni )
	( [deceleration] hodnota urcuje jak rychle se vsechny dane casti po vypnuti zastavi (pri nezadani defaultni hodnota "1" = okamzite zastaveni )
	<chopperRotatingParts>
		<rotationPart node="0>33" rotAxis="2" rotSpeed="-500" />
		<rotationPart node="0>34" rotAxis="2" rotSpeed="500" />
	</chopperRotatingParts>

	( Klasicky PS pro drtic )
	<chopperParticleSystems>
		<chopperParticleSystem type="wheat" node="" file="particleSystems/threshingChopperWheat.i3d" />
		<chopperParticleSystem type="barley" node="" file="particleSystems/threshingChopperWheat.i3d" />
		<chopperParticleSystem type="rape" node="" file="particleSystems/threshingChopperRape.i3d" />
		<chopperParticleSystem type="maize" node="" file="particleSystems/threshingChopperMaize.i3d" />
	</chopperParticleSystems>
	
	( Klasicky PS pro slamu )
	<strawParticleSystems>
		<strawParticleSystem type="wheat" node="" file="$data/vehicles/particleSystems/threshingStrawParticleSystemSmall.i3d" />
		<strawParticleSystem type="barley" node="" file="$data/vehicles/particleSystems/threshingStrawParticleSystemSmall.i3d" />
	</strawParticleSystems>

	( Pridavny PS pro drtic -- NEMUSI BYT ZADANO -- pouzije se v pripade, ze potrebujete jeste jeden index pro PS drtice )
	<addChopperParticleSystems>
		<chopperParticleSystem type="wheat" node="" file="particleSystems/threshingChopperWheat.i3d" />
		<chopperParticleSystem type="barley" node="" file="particleSystems/threshingChopperWheat.i3d" />
		<chopperParticleSystem type="rape" node="" file="particleSystems/threshingChopperRape.i3d" />
		<chopperParticleSystem type="maize" node="" file="particleSystems/threshingChopperMaize.i3d" />
	</addChopperParticleSystems>

	( Pridavny PS pro prach od drtice -- NEMUSI BYT ZADANO -- pouzije se v pripade, ze nemate v klasickem PS pro drtic prach nebo chcete pridat jeste jeden index pro PS prachu )
	<chopperDustParticleSystems>
		<chopperDustParticleSystem type="wheat" node="" file="particleSystems/threshingDustParticleSystemWheat.i3d" />
		<chopperDustParticleSystem type="barley" node="" file="particleSystems/threshingDustParticleSystemWheat.i3d" />
		<chopperDustParticleSystem type="rape" node="" file="particleSystems/threshingDustParticleSystemRape.i3d" />
		<chopperDustParticleSystem type="maize" node="" file="particleSystems/threshingDustParticleSystemMaize.i3d" />
	</chopperDustParticleSystems>
	
	--------------------------------------------------------------------------------------------------------------------------------------------------------	
	
	Zapis do souboru modDesc.xml :
	******************************
	
	vsadit do <specializations> :
		<specialization name="strawChopper"  className="strawChopper"  filename="scripts/strawChopper.lua" />
	
	vsadit do <vehicleTypes> :
		<specialization name="strawChopper" />
		<specialization name="animatedVehicle" />	( Nutn pouze pro animaci otevreni/zavreni drtice! )
	
	vsadit do <l10n> :
		<text name="ENABLE_CHOPPER"><en>Enable chopper</en><cz>Zapnout drtic</cz></text>
		<text name="DISABLE_CHOPPER"><en>Disable chopper</en><cz>Vypnout drtic</cz></text>
		<text name="TOGGLE_CHOPPER"><en>Enable/Disable Chopper</en><cz>ZAP/VYP drtic</cz></text>
		<text name="COULD_NOT_TOGGLE_CHOPPER"><en>Could not enable straw. Current fruittype doesn't support straw!</en><cz>Drtic nelze vypnout, protoze z teto plodiny neni slama!</cz></text>	
	
	vsadit do <inputBindings> :
		<input name="TOGGLE_CHOPPER" 	key1="KEY_n"	category="VEHICLE" />
	
************************************************************************************************************************************************************]]--

strawChopper = {};

function strawChopper.prerequisitesPresent(specializations)
	return true;
end;

function strawChopper:load(xmlFile)
	self.setIsStrawActive = SpecializationUtil.callSpecializationsFunction("setIsStrawActive");
	
	self.isStrawActive = true;
	self.toggleChopperWarningTime = 0;
	self.isStrawSwitch = false;
	self:setIsStrawActive(self.isStrawActive, true);

	self.maxRotTimeBackup = self.maxRotTime;
	self.minRotTimeBackup = self.minRotTime;
	
	for _, wheel in pairs(self.wheels) do
		wheel.rotMaxBackup = wheel.rotMax;
		wheel.rotMinBackup = wheel.rotMin;
	end;
	
	-- chopper folding animation
	self.playChopperAnimation = false;
	self.chopperFold = false;
	self.chopperAnimation = getXMLString(xmlFile, "vehicle.chopper.foldingAnimation#name");
	
	-- chopper turnedOn indicator
	local indicatorNode = getXMLString(xmlFile, "vehicle.chopper.indicator#node");
	if indicatorNode ~= nil and indicatorNode ~= "" then
		self.indicatorNode = Utils.indexToObject(self.components, indicatorNode);
	end;
	
	-- chopper rotating parts
	self.chopperRotatingParts = {};
	self.chopperAcceleration = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.chopperRotatingParts#acceleration"), 1);
	self.chopperDeceleration = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.chopperRotatingParts#deceleration"), 1);
	self.chopperRegSpeed = 0;
	local i = 0;
	while true do
		local key = string.format("vehicle.chopperRotatingParts.rotationPart(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#node"));
		local rotSpeed = math.rad(Utils.getNoNil(getXMLFloat(xmlFile, key.."#rotSpeed"), 1)*0.001);
		local rotAxis = Utils.getNoNil(getXMLInt(xmlFile, key.."#rotAxis"), 2);
		if node ~= nil then
			table.insert(self.chopperRotatingParts, {node=node, rotSpeed=rotSpeed, rotAxis=rotAxis});
		end;
		i = i + 1;
	end;
	
	-- chopper particle system
	self.addChopperParticleSystems = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.addChopperParticleSystems.chopperParticleSystem(%d)", i);
		local t = getXMLString(xmlFile, key .. "#type");
		if t == nil then
			break;
		end;
		local desc = FruitUtil.fruitTypes[t];
		if desc ~= nil then
			local currentPS = {};

			local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/threshingChopperParticleSystem.i3d", self.baseDirectory);
			self.addChopperParticleSystems[desc.index] = currentPS;
			if self.addDefaultChopperParticleSystem == nil then
				self.addDefaultChopperParticleSystem = currentPS;
			end;
		end;
		i = i + 1;
	end;
	
	-- chopper dust particle system
	self.chopperDustParticleSystems = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.chopperDustParticleSystems.chopperDustParticleSystem(%d)", i);
		local t = getXMLString(xmlFile, key .. "#type");
		if t == nil then
			break;
		end;
		local desc = FruitUtil.fruitTypes[t];
		if desc ~= nil then
			local currentPS = {};

			local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/threshingChopperParticleSystem.i3d", self.baseDirectory);
			self.chopperDustParticleSystems[desc.index] = currentPS;
			if self.defaultChopperDustParticleSystem == nil then
				self.defaultChopperDustParticleSystem = currentPS;
			end;
		end;
		i = i + 1;
	end;
	
	-- chopper sound
	local turnOnSound = getXMLString(xmlFile, "vehicle.chopper.turnOnSound#file");
	if turnOnSound ~= nil and turnOnSound ~= "" then
		turnOnSound = Utils.getFilename(turnOnSound, self.baseDirectory);
		self.turnOnSound = createSample("turnOnSound");
		loadSample(self.turnOnSound, turnOnSound, false);
		local soundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.chopper.turnOnSound#pitchOffset"), 1);
		self.turnOnSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.chopper.turnOnSound#volume"), 1);
		setSamplePitch(self.turnOnSound, soundPitchOffset);
		self.playChopperTurnOnSound = false;
		
		self.turnOnSound3DVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.chopper.turnOnSound#volume3D"), self.turnOnSoundVolume);
		self.turnOnSound3DInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.chopper.turnOnSound#innerRadius"), 10);
		self.turnOnSound3DRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.chopper.turnOnSound#radius"), 50);
		self.turnOnSound3D = createAudioSource("turnOnSound3D", turnOnSound, self.turnOnSound3DRadius, self.turnOnSound3DInnerRadius, self.turnOnSound3DVolume, 0);
		if self.chopperRotatingParts[1] ~= nil then
			link(self.chopperRotatingParts[1].node, self.turnOnSound3D);
		else
			link(self.components[1].node, self.turnOnSound3D);
		end;
		setVisibility(self.turnOnSound3D, false);
	end;
	
	local foldingSound = getXMLString(xmlFile, "vehicle.chopper.foldingSound#file");
	if foldingSound ~= nil and foldingSound ~= "" then
		foldingSound = Utils.getFilename(foldingSound, self.baseDirectory);
		self.foldingSound = createSample("foldingSound");
		loadSample(self.foldingSound, foldingSound, false);
		local soundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.chopper.foldingSound#pitchOffset"), 1);
		self.foldingSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.chopper.foldingSound#volume"), 1);
		setSamplePitch(self.foldingSound, soundPitchOffset);
		self.playChopperFoldingSound = false;
	end;
	
	self.threshingScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingScale#value"), self.threshingScale);
end;

function strawChopper:delete()
	for k,v in pairs(self.addChopperParticleSystems) do
		Utils.deleteParticleSystem(v);
	end;
	for k,v in pairs(self.chopperDustParticleSystems) do
		Utils.deleteParticleSystem(v);
	end;
	if self.turnOnSound ~= nil then
		delete(self.turnOnSound);
		self.playChopperTurnOnSound = false;
	end;
	if self.foldingSound ~= nil then
		delete(self.foldingSound);
		self.playChopperFoldingSound = false;
	end;
	if self.turnOnSound3D ~= nil then
		setVisibility(self.turnOnSound3D, false);
	end;
end;

function strawChopper:readStream(streamId, connection)
	local isStrawActive = streamReadBool(streamId);
	self:setIsStrawActive(isStrawActive, true);
end;

function strawChopper:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isStrawActive);
end;

function strawChopper:mouseEvent(posX, posY, isDown, isUp, button)
end;

function strawChopper:keyEvent(unicode, sym, modifier, isDown)
end;

function strawChopper:update(dt)
	if self:getIsActive() then
		if self.isClient and self.isEntered and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.TOGGLE_CHOPPER) then
				if self.lastValidInputFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
					local fruitDesc = FruitUtil.fruitIndexToDesc[self.lastValidInputFruitType];
					if fruitDesc.hasWindrow then
						self:setIsStrawActive(not self.isStrawActive);
					else
						self.toggleChopperWarningTime = self.time + 2000;
					end;
				else
					self:setIsStrawActive(not self.isStrawActive);
				end;
			end;
		end;
		
		if self.lastValidInputFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
			local fruitDesc = FruitUtil.fruitIndexToDesc[self.lastValidInputFruitType];
			if not fruitDesc.hasWindrow then
				if self.isStrawActive then
					self:setIsStrawActive(false);
				end;
			end;
		end;
		
		self.chopperActivated = not self.isStrawActive;
	end;
	
	if self:getIsActiveForSound() then
		if self.foldingSound ~= nil then
			if self.playChopperAnimation then
				if not self.playChopperFoldingSound then
					playSample(self.foldingSound, 0, self.foldingSoundVolume, 0);
					self.playChopperFoldingSound = true;
				end;
			else
				stopSample(self.foldingSound);
				self.playChopperFoldingSound = false;
			end;
		end;
		if self.turnOnSound ~= nil then
			if not self.isStrawActive and self.isThreshing then
				if not self.playChopperTurnOnSound then
					playSample(self.turnOnSound, 0, self.turnOnSoundVolume, 0);
					self.playChopperTurnOnSound = true;
				end;
			else
				stopSample(self.turnOnSound);
				self.playChopperTurnOnSound = false;
			end;
		end;
		if self.turnOnSound3D ~= nil then
			setVisibility(self.turnOnSound3D, false);
		end;
	else
		if self.turnOnSound ~= nil then
			stopSample(self.turnOnSound);
			self.playChopperTurnOnSound = false;
		end;
		if self.turnOnSound3D ~= nil then
			if not self.isStrawActive and self.isThreshing then
				setVisibility(self.turnOnSound3D, true);
			else
				setVisibility(self.turnOnSound3D, false);
			end;
		end;
	end;
	
	if self.chopperAnimation ~= "" then
		local animTime = nil;
		if self:getIsAnimationPlaying(self.chopperAnimation) then
			self.playChopperAnimation = true;
			animTime = self:getAnimationTime(self.chopperAnimation);
		else
			self.playChopperAnimation = false;
		end;
		if not self.isStrawActive then
			if self.chopperFold then
				self:playAnimation(self.chopperAnimation, 1, animTime, true)
				self.chopperFold = false;
			end;
		else
			if not self.chopperFold then
				self:playAnimation(self.chopperAnimation, -1, animTime, true)
				self.chopperFold = true;
			end;
		end;
	end;
	
	if self.indicatorNode ~= nil then
		setVisibility(self.indicatorNode, self.chopperActivated);
	end;
end;

function strawChopper:updateTick(dt)
	if self:getIsActive() then
		for key, particle in pairs(self.addChopperParticleSystems) do
			if self.chopperParticleSystems[key] ~= nil then
				Utils.setEmittingState(particle, Utils.getNoNil(self.chopperParticleSystems[key].isEmitting, false));
			end;
		end;
		for key, particle in pairs(self.chopperDustParticleSystems) do
			if self.chopperParticleSystems[key] ~= nil then
				Utils.setEmittingState(particle, Utils.getNoNil(self.chopperParticleSystems[key].isEmitting, false));
			end;
		end;
		
		if not self.isStrawActive and self.isThreshing then
			if self.chopperRegSpeed < 1 then
				self.chopperRegSpeed = self.chopperRegSpeed + self.chopperAcceleration;
			else
				self.chopperRegSpeed = 1;
			end;
			for _, node in pairs(self.chopperRotatingParts) do
				if node.rotAxis == 3 then
					rotate(node.node, 0, 0, dt * (node.rotSpeed * self.chopperRegSpeed));
				elseif node.rotAxis == 1 then
					rotate(node.node, dt * (node.rotSpeed * self.chopperRegSpeed), 0, 0);
				else
					rotate(node.node, 0, dt * (node.rotSpeed * self.chopperRegSpeed), 0);
				end;
			end;
		else
			if self.chopperRegSpeed > 0 then
				self.chopperRegSpeed = self.chopperRegSpeed - self.chopperDeceleration;
				for _, node in pairs(self.chopperRotatingParts) do
					if node.rotAxis == 3 then
						rotate(node.node, 0, 0, dt * (node.rotSpeed * self.chopperRegSpeed));
					elseif node.rotAxis == 1 then
						rotate(node.node, dt * (node.rotSpeed * self.chopperRegSpeed), 0, 0);
					else
						rotate(node.node, 0, dt * (node.rotSpeed * self.chopperRegSpeed), 0);
					end;
				end;
			else
				self.chopperRegSpeed = 0;
			end;
		end;
	end;	
end;

function strawChopper:draw()
	if self.isClient and self.isEntered then
		local fruitDesc = FruitUtil.fruitIndexToDesc[self.lastValidInputFruitType];	
		if self.lastValidInputFruitType == FruitUtil.FRUITTYPE_UNKNOWN or fruitDesc.hasWindrow then	
			if self.isStrawActive then
				g_currentMission:addHelpButtonText(g_i18n:getText("ENABLE_CHOPPER"), InputBinding.TOGGLE_CHOPPER);
			else
				g_currentMission:addHelpButtonText(g_i18n:getText("DISABLE_CHOPPER"), InputBinding.TOGGLE_CHOPPER);
			end;
		end;
	end;
	
	if self.toggleChopperWarningTime > self.time then
		g_currentMission:addWarning(g_i18n:getText("COULD_NOT_TOGGLE_CHOPPER"), 0.018, 0.033);
	end;
end;

function strawChopper:onDeactivate()
	for k,v in pairs(self.addChopperParticleSystems) do
		Utils.setEmittingState(v, false);
	end;
	for k,v in pairs(self.chopperDustParticleSystems) do
		Utils.setEmittingState(v, false);
	end;
end;

function strawChopper:startThreshing()
	if self.numAttachedCutters > 0 then
		self.maxRotTime = self.maxRotTimeBackup / 0.75;
		self.minRotTime = self.minRotTimeBackup / 0.75;
		for _,wheel in pairs(self.wheels) do
			wheel.rotMax = wheel.rotMaxBackup / 0.75;
			wheel.rotMin = wheel.rotMinBackup / 0.75;
		end;
	end;
end;

function strawChopper:stopThreshing()
	for k,v in pairs(self.addChopperParticleSystems) do
		Utils.setEmittingState(v, false);
	end;
	for k,v in pairs(self.chopperDustParticleSystems) do
		Utils.setEmittingState(v, false);
	end;
	self.maxRotTime = self.maxRotTimeBackup;
	self.minRotTime = self.minRotTimeBackup;
	for _,wheel in pairs(self.wheels) do
		wheel.rotMax = wheel.rotMaxBackup;
		wheel.rotMin = wheel.rotMinBackup;
	end;
end;

function strawChopper:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local isStrawActive = Utils.getNoNil(getXMLBool(xmlFile, key .. "#isStrawActive"), false);
		self:setIsStrawActive(isStrawActive, true);
		if isStrawActive then
			self.chopperFold = false;
		end;
	end; 
	return BaseMission.VEHICLE_LOAD_OK;
end;

function strawChopper:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'isStrawActive="' .. tostring(self.isStrawActive) ..'"';
	return attributes, nil;
end;

function strawChopper:addCutterArea(cutter, area, realArea, inputFruitType, fruitType)
	if area > 0 and (self.lastCuttersFruitType == FruitUtil.FRUITTYPE_UNKNOWN or self.lastCuttersArea == 0 or self.lastCuttersFruitType == fruitType) then
		if not self.chopperActivated and not self.isStrawActive then
			self.chopperActivated = not self.isStrawActive;
			self.chopperEnableTime = nil;
			self.chopperDisableTime = nil;
		end;
		
		if self.isStrawSwitch then
			if self.isStrawActive then
				self.chopperDisableTime = 0;
				self.chopperEnableTime = nil;
				self.strawEnableTime = 0;
				self.strawDisableTime = nil;
			else
				self.chopperDisableTime = nil;
				self.chopperEnableTime = 0;
				self.strawEnableTime = nil;
				self.strawDisableTime = 0;
			end;
			self.isStrawSwitch = false;
		end;
	end;
end;

function strawChopper:setStrawPSEnabled(strawPSenabled, fruitTypeChanged, isSynchronized)
	if not self.isStrawActive then
		if strawPSenabled then
			self:setChopperPSEnabled(true, fruitTypeChanged, isSynchronized);
			self:setStrawPSEnabled(false, fruitTypeChanged, isSynchronized);
		end;
	end;
end;

function strawChopper:setIsStrawActive(isStrawActive, noEventSend)
	ChopperSwitchEvent.sendEvent(self, isStrawActive, noEventSend);
	self.isStrawActive = isStrawActive;
	self.isStrawSwitch = true;
end;




ChopperSwitchEvent = {};
ChopperSwitchEvent_mt = Class(ChopperSwitchEvent, Event);

InitEventClass(ChopperSwitchEvent, "ChopperSwitchEvent");

function ChopperSwitchEvent:emptyNew()
	local self = Event:new(ChopperSwitchEvent_mt);
	return self;
end;

function ChopperSwitchEvent:new(vehicle, isStrawActive)
	local self = ChopperSwitchEvent:emptyNew()
	self.vehicle = vehicle;
	self.isStrawActive = isStrawActive;
	return self;
end;

function ChopperSwitchEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.isStrawActive = streamReadBool(streamId);
	self.vehicle = networkGetObject(id);
	self:run(connection);
end;

function ChopperSwitchEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isStrawActive);
end;

function ChopperSwitchEvent:run(connection)
	self.vehicle:setIsStrawActive(self.isStrawActive, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(ChopperSwitchEvent:new(self.vehicle, self.isStrawActive), nil, connection, self.vehicle);
	end;
end;

function ChopperSwitchEvent.sendEvent(vehicle, isStrawActive, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ChopperSwitchEvent:new(vehicle, isStrawActive), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ChopperSwitchEvent:new(vehicle, isStrawActive));
		end;
	end;
end;