--[[************************************************************************************************************************************************************
	
	multiTrailer v1.0 (compatible with MR)
	
	09/2013 by Saty / http://forum.lsczech.cz
	
****************************************************************************************************************************************************************
	
	(EN) INFO
	
	Free for use on mods. Modifications only with my permission !
	
****************************************************************************************************************************************************************
	
	(CZ) INFO
	
	Pro volne pouziti v modech. ZAKAZ modifikaci bez meho souhlasu !
	
************************************************************************************************************************************************************]]--

multiTrailer = {};

function multiTrailer.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Fillable, specializations) and SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function multiTrailer:load(xmlFile)
	self.changeCurrentBody = SpecializationUtil.callSpecializationsFunction("changeCurrentBody");
	self.setCoverSheet = SpecializationUtil.callSpecializationsFunction("setCoverSheet");
	self.setUnloadingObjects = SpecializationUtil.callSpecializationsFunction("setUnloadingObjects");
	self.isActiveForInput = multiTrailer.isActiveForInput;
	self.printInfo = multiTrailer.printInfo;
	
	self.multiT = {};
	self.multiT.body = {};
	
	self.multiT.firstLoad = true;
	self.multiT.activeBody = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.multiTrailer#defaultBody"), 1);
	
	-- ## EXTRA FILLTYPES ##
	local extraFillTypes = getXMLString(xmlFile, "vehicle.extraFillTypes#fillTypes");
	if extraFillTypes ~= nil then
		local types = Utils.splitString(" ", extraFillTypes);
		for k,v in pairs(types) do
			local extraFillTypes = Fillable.fillTypeNameToInt[v];
			if extraFillTypes ~= nil then
				self.fillTypes[extraFillTypes] = true;
			end;
		end;
	end;
	
	-- ## BODY TYPES ##
	local i = 0;
	while true do
		local key = string.format("vehicle.multiTrailer.body(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local capacity = getXMLInt(xmlFile, key .. "#capacity");
		local allowFillFromAir = Utils.getNoNil(getXMLBool(xmlFile, key .. "#allowFillFromAir"), true);
		local dynamicMountAttacher = Utils.getNoNil(getXMLBool(xmlFile, key .. "#dynamicMountAttacher"), true);
		
		-- ## FILL TYPES ##
		local fillTypes = {};
		local fillTypesLoad = getXMLString(xmlFile, key .. "#fillTypes");
		if fillTypesLoad ~= nil then
			local types = Utils.splitString(" ", fillTypesLoad);
			for k,v in pairs(types) do
				local fillType = Fillable.fillTypeNameToInt[v];
				if fillType ~= nil then
					fillTypes[fillType] = true;
				end;
			end;
		end;
		local fruitTypesLoad = getXMLString(xmlFile, key .. "#fruitTypes");
		if fruitTypesLoad ~= nil then
			local types = Utils.splitString(" ", fruitTypesLoad);
			for k,v in pairs(types) do
				local fillType = Fillable.fillTypeNameToInt[v];
				if fillType ~= nil then
					fillTypes[fillType] = true;
				end;
			end;
		end;
		
		-- ## COMPONENTS WITH CHANGES VISIBILITY ##
		local components = {};
		local j = 0;
		while true do
			local keyNode = key .. string.format(".components.component(%d)", j);
			if not hasXMLProperty(xmlFile, keyNode) then
				break;
			end;
			local node = Utils.indexToObject(self.components, getXMLString(xmlFile, keyNode.."#node"));
			table.insert(components, node);
			j = j + 1;
		end;
		
		-- ## COVERING SHEET ##
		self.multiT.coverSheet = false;
		local coverSheetUnused = getXMLString(xmlFile, key .. "#coverSheetUnused");
		if coverSheetUnused ~= nil then
			coverSheetUnused = Utils.indexToObject(self.components, coverSheetUnused);
			setVisibility(coverSheetUnused, false);
		end;
		
		local coverSheet = getXMLString(xmlFile, key .. "#coverSheetNode");
		if coverSheet ~= nil then
			coverSheet = Utils.indexToObject(self.components, coverSheet);
			setVisibility(coverSheet, false);
			
			local coverSheetScale = {};
			local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. ".coverSheetScalePart#node"));
			if node ~= nil then
				local defaultX, defaultY, defaultZ = getTranslation(node);
				local defaultRX, defaultRY, defaultRZ = getRotation(node);
				local animCurve = AnimCurve:new(linearInterpolatorTransRotScale);
				local keyI = 0;
				while true do
					local animKey = key .. string.format(".coverSheetScalePart.key(%d)", keyI);
					local keyTime = getXMLFloat(xmlFile, animKey.."#time");
					local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, animKey.."#translation"));
					if y == nil then
						y = getXMLFloat(xmlFile, animKey.."#y");
					end;
					local rx,ry,rz = Utils.getVectorFromString(getXMLString(xmlFile, animKey.."#rotation"));
					local sx,sy,sz = Utils.getVectorFromString(getXMLString(xmlFile, animKey.."#scale"));
					if keyTime == nil then
						break;
					end;
					local x = Utils.getNoNil(x, defaultX);
					local y = Utils.getNoNil(y, defaultY);
					local z = Utils.getNoNil(z, defaultZ);
					local rx = Utils.getNoNil(rx, defaultRX);
					local ry = Utils.getNoNil(ry, defaultRY);
					local rz = Utils.getNoNil(rz, defaultRZ);
					local sx = Utils.getNoNil(sx, 1);
					local sy = Utils.getNoNil(sy, 1);
					local sz = Utils.getNoNil(sz, 1);
					animCurve:addKeyframe({x=x, y=y, z=z, rx=rx, ry=ry, rz=rz, sx=sx, sy=sy, sz=sz, time = keyTime});
					keyI = keyI + 1;
				end;
				if keyI == 0 then
					local minY, maxY = Utils.getVectorFromString(getXMLString(xmlFile, nodeKey.."#minMaxY"));
					local minY = Utils.getNoNil(minY, defaultY);
					local maxY = Utils.getNoNil(maxY, defaultY);
					animCurve:addKeyframe({x=defaultX, y=minY, z=defaultZ, rx=defaultRX, ry=defaultRY, rz=defaultRZ, sx=1, sy=1, sz=1, time = 0});
					animCurve:addKeyframe({x=defaultX, y=maxY, z=defaultZ, rx=defaultRX, ry=defaultRY, rz=defaultRZ, sx=1, sy=1, sz=1, time = 1});
				end;
				coverSheetScaleNode = node;
				coverSheetScaleAnimCurve = animCurve;
			end;
		end;
		
		-- ## FILL PLANES ##
		local fillPlanes = {};
		local k = 0;
		while true do
			local keyPlanes = key .. string.format(".fillPlanes.fillPlane(%d)", k);
			if not hasXMLProperty(xmlFile, keyPlanes) then
				break;
			end;
			local fillPlane = {};
			fillPlane.nodes = {};
			local fillType = getXMLString(xmlFile, keyPlanes .. "#type");
			if fillType ~= nil then
				local nodeI = 0;
				while true do
					local nodeKey = keyPlanes..string.format(".node(%d)", nodeI);
					if not hasXMLProperty(xmlFile, nodeKey) then
						 break;
					end;
					local node = Utils.indexToObject(self.components, getXMLString(xmlFile, nodeKey.."#index"));
					if node ~= nil then
						local defaultX, defaultY, defaultZ = getTranslation(node);
						local defaultRX, defaultRY, defaultRZ = getRotation(node);
						setVisibility(node, false);

						local animCurve = AnimCurve:new(linearInterpolatorTransRotScale);
						local keyI = 0;
						while true do
							local animKey = nodeKey..string.format(".key(%d)", keyI);
							local keyTime = getXMLFloat(xmlFile, animKey.."#time");
							local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, animKey.."#translation"));
							if y == nil then
								y = getXMLFloat(xmlFile, animKey.."#y");
							end;
							if z == nil then
								z = getXMLFloat(xmlFile, animKey.."#z");
							end;
							local rx,ry,rz = Utils.getVectorFromString(getXMLString(xmlFile, animKey.."#rotation"));
							local sx,sy,sz = Utils.getVectorFromString(getXMLString(xmlFile, animKey.."#scale"));
							if keyTime == nil then
								break;
							end;
							local x = Utils.getNoNil(x, defaultX);
							local y = Utils.getNoNil(y, defaultY);
							local z = Utils.getNoNil(z, defaultZ);
							local rx = Utils.getNoNil(rx, defaultRX);
							local ry = Utils.getNoNil(ry, defaultRY);
							local rz = Utils.getNoNil(rz, defaultRZ);
							local sx = Utils.getNoNil(sx, 1);
							local sy = Utils.getNoNil(sy, 1);
							local sz = Utils.getNoNil(sz, 1);
							animCurve:addKeyframe({x=x, y=y, z=z, rx=rx, ry=ry, rz=rz, sx=sx, sy=sy, sz=sz, time = keyTime});
							keyI = keyI +1;
						end;
						if keyI == 0 then
							local minY, maxY = Utils.getVectorFromString(getXMLString(xmlFile, nodeKey.."#minMaxY"));
							local minY = Utils.getNoNil(minY, defaultY);
							local maxY = Utils.getNoNil(maxY, defaultY);
							local minZ, maxZ = Utils.getVectorFromString(getXMLString(xmlFile, nodeKey.."#minMaxZ"));
							local minZ = Utils.getNoNil(minZ, defaultZ);
							local maxZ = Utils.getNoNil(maxZ, defaultZ);
							animCurve:addKeyframe({x=defaultX, y=minY, z=minZ, rx=defaultRX, ry=defaultRY, rz=defaultRZ, sx=1, sy=1, sz=1, time = 0});
							animCurve:addKeyframe({x=defaultX, y=maxY, z=maxZ, rx=defaultRX, ry=defaultRY, rz=defaultRZ, sx=1, sy=1, sz=1, time = 1});
						end;
						table.insert(fillPlane.nodes, {node=node, animCurve = animCurve});
					end;
					nodeI = nodeI +1;
				end;
				fillPlanes[fillType] = fillPlane;
			end;
			k = k + 1;
		end;
		
		-- ## REAL CAPACITY MULTIPLIER FOR MR MOD ##
		local realCapacityFx = {};
		local l = 0;
		while true do
			local keyRCM = key .. string.format(".realCapacityMultipliers.realCapacityMultiplier(%d)", l);
			if not hasXMLProperty(xmlFile, keyRCM) then
				break;
			end;
			local fillTypeString = getXMLString(xmlFile, keyRCM.."#fillType");
			local multiplier = getXMLFloat(xmlFile, keyRCM.."#multiplier");
			local fillType = Fillable.fillTypeNameToInt[fillTypeString];
			if fillType ~= nil then
				realCapacityFx[fillType] = multiplier;
			end;
			l = l + 1;
		end;
		
		-- ## OPTIONAL TRAILER TIP REFERENCE POINTS ##
		local tipReferencePoints = {};
		local tipReferencePointsLoad = getXMLString(xmlFile, key .. "#usedTipReferencePoints");
		if tipReferencePointsLoad ~= nil then
			local used = Utils.splitString(" ", tipReferencePointsLoad);
			for i, j in pairs(used) do
				tipReferencePoints[i] = true;
			end;
		else
			for i, j in pairs(self.tipReferencePoints) do
				tipReferencePoints[i] = true;
			end;
		end;
		
		-- ## WRITE TABLE ##
		local entry = {};
		entry.capacity = capacity;
		entry.allowFillFromAir = allowFillFromAir;
		entry.dynamicMountAttacher = dynamicMountAttacher;
		entry.components = components;
		entry.componentsCount = table.getn(components);
		entry.coverSheet = coverSheet;
		entry.coverSheetUnused = coverSheetUnused;
		entry.coverSheetScaleNode = coverSheetScaleNode;
		entry.coverSheetScaleAnimCurve = coverSheetScaleAnimCurve;
		entry.fillTypes = fillTypes;
		entry.fillPlanes = fillPlanes;
		entry.realCapacityFx = realCapacityFx;
		entry.tipReferencePoints = tipReferencePoints;
		table.insert(self.multiT.body, entry);
		
		i = i + 1;
	end;
	
	-- ## TRAILER TIP REFERENCE POINTS ##
	self.multiT.tipReferencePoints = {};
	for i,j in pairs(self.tipReferencePoints) do
		if self.tipReferencePoints[i] ~= nil then
			self.multiT.tipReferencePoints[i] = self.tipReferencePoints[i];
		end;
	end;
	
	-- ## VARIABLE UNLOAD TIME FROM CURRENT BODY CAPACITY ##
	self.multiT.dischargeEndTime = {};
	self.multiT.dischargeTimeScale = Utils.getNoNil(getXMLString(xmlFile, "vehicle.multiTrailer#dischargeTimeScale"), 1.75);
	for i,j in pairs(self.tipAnimations) do
		if self.tipAnimations[i] ~= nil then
			self.multiT.dischargeEndTime[i] = self.tipAnimations[i].dischargeEndTime;
		end;
	end;
	
	-- ## DYNAMIC MOUNT ATTACHER ##
	if self.dynamicMountAttacherTrigger ~= nil then
		self.multiT.dmat = {};
		local x, y, z = getTranslation(self.dynamicMountAttacherTrigger.triggerNode);
		self.multiT.dmat[1] = x;
		self.multiT.dmat[2] = y;
		self.multiT.dmat[3] = z;
	end;
	
	-- ## UNLOAD ATTACHED OBJECTS ##
	self.multiT.unloadAnimation = getXMLString(xmlFile, "vehicle.multiTrailer#unloadAnimation");
	self.multiT.unloading = false;
	self.isObjectMounted = false;
	
	-- ## OTHER ##
	self.multiT.bodyCount = table.getn(self.multiT.body);
	self.multiT.rainWarning = 0;
	self.multiT.inRange = false;
	
	if self.multiT.activeBody > self.multiT.bodyCount then
		self.multiT.activeBody = 1;
	end;
	
	self.multiT.origFillPlanes = {};
	for i,j in pairs(self.fillPlanes) do
		self.multiT.origFillPlanes[i] = j;
	end;
end;

-- ### SAVE / LOAD data & Stream data ###
function multiTrailer:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'currentBody="'..tostring(self.multiT.currentBody)..'" cover="'..tostring(self.multiT.coverSheet)..'"';
	return attributes, nil;
end;

function multiTrailer:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local currentBody = Utils.getNoNil(getXMLInt(xmlFile, key .. "#currentBody"), 1);
		local coverSheet = Utils.getNoNil(getXMLBool(xmlFile, key .. "#cover"), false);
		local fillLevel = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#fillLevel"), 0);
		if currentBody > self.multiT.bodyCount then
			currentBody = 1;
		end;
		self:changeCurrentBody(currentBody, true);
		self:setCoverSheet(coverSheet, true);
		if fillLevel ~= self.fillLevel then
			self:setFillLevel(fillLevel, self.currentFillType);
		end;
	else
		self:changeCurrentBody(self.multiT.activeBody, true);
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function multiTrailer:readStream(streamId, connection)
	self:changeCurrentBody(streamReadInt8(streamId), true);
	self:setCoverSheet(streamReadBool(streamId), true);
	self:setUnloadingObjects(streamReadBool(streamId), true);
	self.isObjectMounted = streamReadBool(streamId);
end;

function multiTrailer:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.multiT.currentBody);
	streamWriteBool(streamId, self.multiT.coverSheet);
	streamWriteBool(streamId, self.multiT.unloading);
	streamWriteBool(streamId, self.isObjectMounted);
end;

function multiTrailer:readUpdateStream(streamId, timestamp, connection)
	if connection:getIsServer() then
		self.isObjectMounted = streamReadBool(streamId);
	end;
end;

function multiTrailer:writeUpdateStream(streamId, connection, dirtyMask)
	if not connection:getIsServer() then
		streamWriteBool(streamId, self.isObjectMounted);
	end;
end;

-- ### UPDATE ###
function multiTrailer:update(dt)
	if self.multiT.firstLoad and self.multiT.currentBody == nil then
		self:changeCurrentBody(self.multiT.activeBody)
		self.multiT.firstLoad = false;
	end;
	
	if self:isActiveForInput() then
		if InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
			self:printInfo();
		end;
	end;
	
	-- ## CHANGE CURRENT BODY ##
	if self:isActiveForInput() then
		if self.multiT.isChangeable then
			if InputBinding.hasEvent(InputBinding.MT_changeCurrentBody) then
				local currentBody = self.multiT.currentBody + 1;
				if currentBody > self.multiT.bodyCount then
					currentBody = 1
				end;
				self:changeCurrentBody(currentBody);
			end;
		end;
	end;
	
	-- ## SET COVERING SHEET ##
	if self.multiT.body[self.multiT.currentBody].coverSheet ~= nil then
		if g_currentMission.environment.lastRainScale > 0 and not self.multiT.coverSheet then
			self:setCoverSheet(true);
		end;
		if self.multiT.inRange then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				if g_currentMission.environment.lastRainScale == 0 then
					self:setCoverSheet(not self.multiT.coverSheet);
				else
					self.multiT.rainWarning = self.time + 1000;
				end;
			end;
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("MT_coverSheet"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
		end;
		
		if self.multiT.coverSheet and self.multiT.body[self.multiT.currentBody].coverSheetScaleNode ~= nil then
			if self.fillLevel ~= self.multiT.fillLevel then
				self.multiT.fillLevel = self.fillLevel;
				local t = self.fillLevel / self.capacity;
				local x,y,z, rx,ry,rz, sx,sy,sz = self.multiT.body[self.multiT.currentBody].coverSheetScaleAnimCurve:get(t);
				setTranslation(self.multiT.body[self.multiT.currentBody].coverSheetScaleNode, x, y, z);
				setRotation(self.multiT.body[self.multiT.currentBody].coverSheetScaleNode, rx, ry, rz);
				setScale(self.multiT.body[self.multiT.currentBody].coverSheetScaleNode, sx, sy, sz);
			end;
		end;
	end;
	
	-- ## SET UNLOAD TIME FROM CURRENT BODY CAPACITY ##
	for i,j in pairs(self.tipAnimations) do
		if self.tipAnimations[i] ~= nil then
			if self.drive or not self.isRealistic then
				self.tipAnimations[i].dischargeEndTime = self.capacity * self.multiT.dischargeTimeScale;
			else
				self.tipAnimations[i].dischargeEndTime = self.multiT.dischargeEndTime[i];
			end;
		end;
	end;
	
	-- ## UNLOAD ATTACHED OBJECTS ##
	if self.multiT.unloadAnimation ~= nil and self.playAnimation ~= nil then
		if self:getIsActiveForInput() and self.multiT.body[self.multiT.currentBody].dynamicMountAttacher then
			if not self.multiT.unloading and self.isObjectMounted and not self:getIsAnimationPlaying(self.multiT.unloadAnimation) then
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
					self:setUnloadingObjects(true);
				end;
			elseif self.multiT.unloading and not self:getIsAnimationPlaying(self.multiT.unloadAnimation) then
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
					self:setUnloadingObjects(false);
				end;
			end;
		end;
	end;
end;

-- ### UPDATE TICK ###
function multiTrailer:updateTick(dt)
	self.multiT.isChangeable = false;
	self.multiT.inRange = false;
	
	if self.multiT.dmat ~= nil and self:getIsActive() then
		if self.isServer then
			for object,_ in pairs(self.pendingDynamicMountObjects) do
				if self.dynamicMountedObjects[object] ~= nil then
					self.isObjectMounted = true;
				else
					self.isObjectMounted = false;
				end;
			end;
		end;
	end;
	
	if self.multiT.bodyCount > 1 then
		local nextBody = self.multiT.body[1];
		if self.multiT.currentBody < self.multiT.bodyCount then
			nextBody = self.multiT.body[self.multiT.currentBody + 1];
		end;
		if self.tipState == Trailer.TIPSTATE_CLOSED and not self.multiT.unloading and not self.isObjectMounted and (self.fillLevel <= 0 or (self.fillLevel < nextBody.capacity and nextBody.fillTypes[self.currentFillType])) then
			self.multiT.isChangeable = true
		end;
	end;
	
	if self.multiT.body[self.multiT.currentBody].coverSheet ~= nil then
		if g_currentMission.player ~= nil then
			local nearestDistance = 3;
			local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
			local sx, sy, sz = getWorldTranslation(self.multiT.body[self.multiT.currentBody].coverSheet); 
			local distance = Utils.vector3Length(sx-vx, sy-vy, sz-vz);
			if distance < nearestDistance then
				self.multiT.inRange = true;
			end;
		end;
	end;
end;

-- ### DRAW Help ###
function multiTrailer:draw()
	if self.multiT.isChangeable then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("MT_currentBodyDraw"), self.multiT.currentBody, self.multiT.bodyCount), InputBinding.MT_changeCurrentBody);
	end;
	if self.multiT.rainWarning > self.time then
		g_currentMission:addWarning(string.format(g_i18n:getText("MT_rainWarning")), 0.018, 0.033);
	end;
	if self.multiT.unloadAnimation ~= nil and self.playAnimation ~= nil then
		if self:getIsActiveForInput() and self.multiT.body[self.multiT.currentBody].dynamicMountAttacher then
			if not self.multiT.unloading and self.isObjectMounted and not self:getIsAnimationPlaying(self.multiT.unloadAnimation) then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("MT_unloadStart"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			elseif self.multiT.unloading and not self:getIsAnimationPlaying(self.multiT.unloadAnimation) then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("MT_unloadStop"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			end;
		end;
	end;
end;

-- ### Change Current Body ###
function multiTrailer:changeCurrentBody(state, noEventSend)
	multiTrailerEvent.sendEvent(self, state, noEventSend);
	self.multiT.currentBody = state;
	
	for _, body in ipairs(self.multiT.body) do
		for _, component in ipairs(body.components) do
			setVisibility(component, false);
		end;
	end;
	
	if self.multiT.body[state] ~= nil then
		for _, component in ipairs(self.multiT.body[state].components) do
			setVisibility(component, true);
		end;
	end;
		
	for i, j in pairs(self.fillTypes) do
		if self.multiT.body[state].fillTypes[i] == true then
			self.fillTypes[i] = true;
		else
			self.fillTypes[i] = false;
		end;
	end;
	
	for i, j in pairs(self.fillPlanes) do
		if self.multiT.body[state].fillPlanes[i] ~= nil then
			self.fillPlanes[i] = self.multiT.body[state].fillPlanes[i];
		else
			self.fillPlanes[i] = self.multiT.origFillPlanes[i];
		end;
	end;
	
	for i, j in pairs(self.multiT.tipReferencePoints) do
		self.tipReferencePoints[i] = self.multiT.tipReferencePoints[i];
	end;
	for i, j in pairs(self.tipReferencePoints) do
		if not self.multiT.body[state].tipReferencePoints[i] then
			table.remove(self.tipReferencePoints, i);
		end;
	end;
	
	self.allowFillFromAir = self.multiT.body[state].allowFillFromAir;
	self.capacity = self.multiT.body[state].capacity;
	
	if self.isRealistic then
		self.realFillVolume = self.fillLevel;
		self.realBaseCapacity = self.multiT.body[state].capacity;
		for i, j in pairs(self.fillTypes) do
			if self.fillTypes[i] then
				self.realCapacityFx[i] = Utils.getNoNil(self.multiT.body[state].realCapacityFx[i], 1);
			end;
		end;
	end;
	
	self:setFillLevel(self.fillLevel, self.currentFillType);
	
	-- ## SET DYNAMIC MOUNT ATTACHER ##
	if self.multiT.dmat ~= nil then
		if self.multiT.body[state].dynamicMountAttacher then
			setTranslation(self.dynamicMountAttacherTrigger.triggerNode, self.multiT.dmat[1], self.multiT.dmat[2], self.multiT.dmat[3]);
		else
			setTranslation(self.dynamicMountAttacherTrigger.triggerNode, self.multiT.dmat[1], self.multiT.dmat[2] - 5, self.multiT.dmat[3]);
		end;
	end;
	
	self:setCoverSheet(false);
end;

function multiTrailer:setCoverSheet(coverSheet, noEventSend)
	SetCoverSheetEvent.sendEvent(self, coverSheet, noEventSend)
	self.multiT.coverSheet = coverSheet;
	if coverSheet then
		self.allowFillFromAir = false;
		if self.multiT.body[self.multiT.currentBody].coverSheetUnused ~= nil then
			setVisibility(self.multiT.body[self.multiT.currentBody].coverSheetUnused, false);
		end;
		setVisibility(self.multiT.body[self.multiT.currentBody].coverSheet, true);
	else
		self.allowFillFromAir = self.multiT.body[self.multiT.currentBody].allowFillFromAir;
		for _, body in ipairs(self.multiT.body) do
			if body.coverSheet ~= nil then
				setVisibility(body.coverSheet, false);
			end;
			if body.coverSheetUnused ~= nil then
				setVisibility(body.coverSheetUnused, false);
			end;
		end;
		if self.multiT.body[self.multiT.currentBody].coverSheetUnused ~= nil then
			setVisibility(self.multiT.body[self.multiT.currentBody].coverSheetUnused, true);
		end;
	end;
end;

function multiTrailer:setUnloadingObjects(unloading, noEventSend)
	SetUnloadingObjectsEvent.sendEvent(self, unloading, noEventSend)
	self.multiT.unloading = unloading;
	if unloading then
		if self.isServer then
			for object,_ in pairs(self.pendingDynamicMountObjects) do
				object:unmountDynamic();
			end;
			setTranslation(self.dynamicMountAttacherTrigger.triggerNode, self.multiT.dmat[1], self.multiT.dmat[2] - 5, self.multiT.dmat[3]);
		end;
		self:playAnimation(self.multiT.unloadAnimation, 2.5, 0, true);
	else
		if self.isServer then
			setTranslation(self.dynamicMountAttacherTrigger.triggerNode, self.multiT.dmat[1], self.multiT.dmat[2], self.multiT.dmat[3]);
		end;
		self:playAnimation(self.multiT.unloadAnimation, -3, nil, true);
	end;
end;

function multiTrailer:isActiveForInput(onlyTrueIfSelected)
	if g_gui.currentGui ~= nil or g_currentMission.isPlayerFrozen then
		return false;
	end;
	if self.isEntered then
		if onlyTrueIfSelected == nil or onlyTrueIfSelected then
			return self.selectedImplement == nil;
		else
			return true;
		end;
	end;
	if self.attacherVehicle ~= nil then
		if self.attacherVehicle.isActiveForInput ~= nil then
			if onlyTrueIfSelected == nil or onlyTrueIfSelected then
				return self.isSelected and self.attacherVehicle:isActiveForInput(false);
			else
				return self.attacherVehicle:isActiveForInput(false);
			end;
		end;
		if onlyTrueIfSelected == nil or onlyTrueIfSelected then
			return self.isSelected and self.attacherVehicle:getIsActiveForInput(false);
		else
			return self.attacherVehicle:getIsActiveForInput(false);
		end;
	end;
	return false;
end;

function multiTrailer:printInfo()
	local mass = {};
	local realMass = {};
	local printMass = 0;
	local printRealMass = 0;
	local fillMass = 0;
	local fx = 0;
	local fillTypeName = Fillable.fillTypeIntToName[self.currentFillType];
	print("");
	print("############################################################");
	print(" MultiTrailer - printInfo function");
	print("");
	for i, j in pairs(self.components) do
		mass = getMass(self.components[i].node);
		realMass = self.components[i].realMassWanted;
		print(" component[" .. i .. "] :  actualMass = " .. mass .. " , realMass = " .. realMass);
		printMass = printMass + mass;
		printRealMass = printRealMass + realMass;
	end;
	if self.realFillVolume > 0 then
		local found, density, pricePerKg = RealisticUtils.getFillTypeInfosV2(fillTypeName);
		fx = 0.001 * density;
		fillMass = self.realFillVolume * fx;
	end;
	print("");
	print(" totalMass = " .. printMass);
	print(" totalRealMass = " .. printRealMass);
	print(" fillMass = " .. fillMass .. " (" .. fillTypeName .. " " .. self.realFillVolume .. " * " .. fx .. ")");
	print("############################################################");
	print("");
end;

function multiTrailer:onAttach(attacherVehicle)
end;

function multiTrailer:onDetach()
end;

function multiTrailer:delete()
end;

function multiTrailer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function multiTrailer:keyEvent(unicode, sym, modifier, isDown)
end;


multiTrailerEvent = {};
multiTrailerEvent_mt = Class(multiTrailerEvent, Event);

InitEventClass(multiTrailerEvent, "multiTrailerEvent");

function multiTrailerEvent:emptyNew()
	local self = Event:new(multiTrailerEvent_mt);
	self.className="multiTrailerEvent";
	return self;
end;

function multiTrailerEvent:new(vehicle, state)
	local self = multiTrailerEvent:emptyNew()
	self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function multiTrailerEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.state = streamReadInt8(streamId);
	self.vehicle = networkGetObject(id);
	self:run(connection);
end;

function multiTrailerEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.state);
end;

function multiTrailerEvent:run(connection)
	self.vehicle:changeCurrentBody(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(multiTrailerEvent:new(self.vehicle, self.state), nil, connection, self.vehicle);
	end;
end;

function multiTrailerEvent.sendEvent(vehicle, state, noEventSend)
	if state ~= vehicle.multiT.currentBody then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(multiTrailerEvent:new(vehicle, state), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(multiTrailerEvent:new(vehicle, state));
			end;
		end;
	end;
end;


SetCoverSheetEvent = {};
SetCoverSheetEvent_mt = Class(SetCoverSheetEvent, Event);

InitEventClass(SetCoverSheetEvent, "SetCoverSheetEvent");

function SetCoverSheetEvent:emptyNew()
	local self = Event:new(SetCoverSheetEvent_mt);
	self.className="SetCoverSheetEvent";
	return self;
end;

function SetCoverSheetEvent:new(vehicle, state)
	local self = SetCoverSheetEvent:emptyNew()
	self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function SetCoverSheetEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
	self.vehicle = networkGetObject(id);
	self:run(connection);
end;

function SetCoverSheetEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.state);
end;

function SetCoverSheetEvent:run(connection)
	self.vehicle:setCoverSheet(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetCoverSheetEvent:new(self.vehicle, self.state), nil, connection, self.vehicle);
	end;
end;

function SetCoverSheetEvent.sendEvent(vehicle, state, noEventSend)
	if state ~= vehicle.multiT.coverSheet then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetCoverSheetEvent:new(vehicle, state), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetCoverSheetEvent:new(vehicle, state));
			end;
		end;
	end;
end;


SetUnloadingObjectsEvent = {};
SetUnloadingObjectsEvent_mt = Class(SetUnloadingObjectsEvent, Event);

InitEventClass(SetUnloadingObjectsEvent, "SetUnloadingObjectsEvent");

function SetUnloadingObjectsEvent:emptyNew()
	local self = Event:new(SetUnloadingObjectsEvent_mt);
	self.className="SetUnloadingObjectsEvent";
	return self;
end;

function SetUnloadingObjectsEvent:new(vehicle, state)
	local self = SetUnloadingObjectsEvent:emptyNew()
	self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function SetUnloadingObjectsEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
	self.vehicle = networkGetObject(id);
	self:run(connection);
end;

function SetUnloadingObjectsEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.state);
end;

function SetUnloadingObjectsEvent:run(connection)
	self.vehicle:setUnloadingObjects(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetUnloadingObjectsEvent:new(self.vehicle, self.state), nil, connection, self.vehicle);
	end;
end;

function SetUnloadingObjectsEvent.sendEvent(vehicle, state, noEventSend)
	if state ~= vehicle.multiT.unloading then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetUnloadingObjectsEvent:new(vehicle, state), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetUnloadingObjectsEvent:new(vehicle, state));
			end;
		end;
	end;
end;