-- by modelleicher
-- www.schwabenmodding.bplaced.net
-- edit by ACG-Modding		(ls-for-ever)
-- www.acg-modding.com
-- permission granted / Erlaubnis bekommen!

realSteerAngles = {};

function realSteerAngles.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations) and SpecializationUtil.hasSpecialization(wheelMode, specializations);
end;

function realSteerAngles:load(xmlFile)
	self.rotMin1 = self.wheels[1].rotMin;
	self.rotMax1 = self.wheels[1].rotMax;
	self.rotMin2 = self.wheels[2].rotMin;
	self.rotMax2 = self.wheels[2].rotMax;
	self.rotSpeedMax = self.wheels[1].rotSpeed;
	self.maxDegrees = self.wheels[1].rotMin;
	
	local x1,_,z1 = getTranslation(self.wheels[1].repr);
	local x2,_,z2 = getTranslation(self.wheels[2].repr);
	self.axleWidth = math.abs(x1)+math.abs(x2);
	
	local _,_,z3 = getTranslation(self.wheels[3].repr);
	local _,_,z4 = getTranslation(self.wheels[4].repr);
	self.wheelbase = ((math.abs(z1)+math.abs(z3))+(math.abs(z2)+math.abs(z4)) / 2);
	
	self.turnCycleMax = 2*self.wheelbase/math.sin(self.maxDegrees);
	self.turnCycleMin = self.turnCycleMax - self.axleWidth;
	self.multiplier = self.turnCycleMax / self.turnCycleMin;
end;

function realSteerAngles:update(dt)
	if self:getIsActive() then
		local side = 0;
		local _,y1,_ = getRotation(self.steering);
		if y1 > 0 then
			side = 1;
		elseif y1 < 0 then
			side = 2;
		end;
		if self.changeWheel == 0 then
		if side == 2 then
			self.wheels[2].rotMin = self.maxDegrees 
			self.wheels[2].rotMax = -self.maxDegrees 
			self.wheels[2].rotSpeed = self.rotSpeedMax;
			self.wheels[1].rotSpeed = self.rotSpeedMax*self.multiplier
			self.wheels[1].rotMin = self.maxDegrees*self.multiplier
			self.wheels[1].rotMax = -self.maxDegrees*self.multiplier
			self.wheels[4].rotMin = self.maxDegrees 
			self.wheels[4].rotMax = -self.maxDegrees 
			self.wheels[4].rotSpeed = -self.rotSpeedMax;
			self.wheels[3].rotSpeed = -self.rotSpeedMax*self.multiplier
			self.wheels[3].rotMin = self.maxDegrees*self.multiplier
			self.wheels[3].rotMax = -self.maxDegrees*self.multiplier
		elseif side == 1 then
			self.wheels[1].rotMin = self.maxDegrees 
			self.wheels[1].rotMax = -self.maxDegrees 
			self.wheels[1].rotSpeed = self.rotSpeedMax;
			self.wheels[2].rotSpeed = self.rotSpeedMax*self.multiplier
			self.wheels[2].rotMin = self.maxDegrees*self.multiplier
			self.wheels[2].rotMax = -self.maxDegrees*self.multiplier
			self.wheels[3].rotMin = self.maxDegrees 
			self.wheels[3].rotMax = -self.maxDegrees 
			self.wheels[3].rotSpeed = -self.rotSpeedMax;
			self.wheels[4].rotSpeed = -self.rotSpeedMax*self.multiplier
			self.wheels[4].rotMin = self.maxDegrees*self.multiplier
			self.wheels[4].rotMax = -self.maxDegrees*self.multiplier
		elseif side == 0 then
			self.wheels[1].rotMin = self.maxDegrees;
			self.wheels[1].rotMax = -self.maxDegrees;	
			self.wheels[2].rotMin = self.maxDegrees;
			self.wheels[2].rotMax = -self.maxDegrees;
			self.wheels[3].rotMin = self.maxDegrees;
			self.wheels[3].rotMax = -self.maxDegrees;	
			self.wheels[4].rotMin = self.maxDegrees;
			self.wheels[4].rotMax = -self.maxDegrees;
		end;
		elseif self.changeWheel == 1 then
		if side == 2 then
			self.wheels[2].rotMin = self.maxDegrees 
			self.wheels[2].rotMax = -self.maxDegrees 
			self.wheels[2].rotSpeed = self.rotSpeedMax;
			self.wheels[1].rotSpeed = self.rotSpeedMax*self.multiplier
			self.wheels[1].rotMin = self.maxDegrees*self.multiplier
			self.wheels[1].rotMax = -self.maxDegrees*self.multiplier
		elseif side == 1 then
			self.wheels[1].rotMin = self.maxDegrees 
			self.wheels[1].rotMax = -self.maxDegrees 
			self.wheels[1].rotSpeed = self.rotSpeedMax;
			self.wheels[2].rotSpeed = self.rotSpeedMax*self.multiplier
			self.wheels[2].rotMin = self.maxDegrees*self.multiplier
			self.wheels[2].rotMax = -self.maxDegrees*self.multiplier
		elseif side == 0 then
			self.wheels[1].rotMin = self.maxDegrees;
			self.wheels[1].rotMax = -self.maxDegrees;	
			self.wheels[2].rotMin = self.maxDegrees;
			self.wheels[2].rotMax = -self.maxDegrees;
		end;
		elseif self.changeWheel == 2 then
		if side == 2 then
			self.wheels[4].rotMin = self.maxDegrees 
			self.wheels[4].rotMax = -self.maxDegrees 
			self.wheels[4].rotSpeed = -self.rotSpeedMax;
			self.wheels[3].rotSpeed = -self.rotSpeedMax*self.multiplier
			self.wheels[3].rotMin = self.maxDegrees*self.multiplier
			self.wheels[3].rotMax = -self.maxDegrees*self.multiplier
		elseif side == 1 then
			self.wheels[3].rotMin = self.maxDegrees 
			self.wheels[3].rotMax = -self.maxDegrees 
			self.wheels[3].rotSpeed = -self.rotSpeedMax;
			self.wheels[4].rotSpeed = -self.rotSpeedMax*self.multiplier
			self.wheels[4].rotMin = self.maxDegrees*self.multiplier
			self.wheels[4].rotMax = -self.maxDegrees*self.multiplier
		elseif side == 0 then
			self.wheels[3].rotMin = self.maxDegrees;
			self.wheels[3].rotMax = -self.maxDegrees;	
			self.wheels[4].rotMin = self.maxDegrees;
			self.wheels[4].rotMax = -self.maxDegrees;
		end;
		end;
	end;
end;

function realSteerAngles:delete()
end;
function realSteerAngles:mouseEvent(posX, posY, isDown, isUp, button)
end;
function realSteerAngles:keyEvent(unicode, sym, modifier, isDown)
end;
function realSteerAngles:updateTick(dt)
end;
function realSteerAngles:draw()
end;