



steam = {};

function steam.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Honk, specializations);
end;

function steam:load(xmlFile) 
    
	self.steamParticleSystems = {};
	local steamParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.steamParticleSystems#count"), 0);
	
	for i=1, steamParticleSystemCount do
         local namei = string.format("vehicle.steamParticleSystems.steamParticleSystem%d", i);
         Utils.loadParticleSystem(xmlFile, self.steamParticleSystems, namei, self.components, false, nil, self.baseDirectory)
end;

end;

function steam:delete()
	Utils.deleteParticleSystem(self.steamParticleSystems);
end;



function steam:update()
    if self.honkPlaying then
		Utils.setEmittingState(self.steamParticleSystems, true)
		else Utils.setEmittingState(self.steamParticleSystems, false)
		end;

end;

function steam:draw()
end;

function steam:onEnter()
end;

function steam:onLeave()
end;

function steam:keyEvent(unicode, sym, modifier, isDown)
end;

function steam:mouseEvent(posX, posY, isDown, isUp, button)
end;
