piston = {}

function piston.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function piston:load(xmlFile)
    self.animation = {};
    self.animation.animCharSet = 0;
    self.animationEnabled = false;
    local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animation#rootNode"));
    if rootNode ~= nil then
        self.animation.animCharSet = getAnimCharacterSet(rootNode);
        if self.animation.animCharSet ~= 0 then
            self.animation.clip = getAnimClipIndex(self.animation.animCharSet, getXMLString(xmlFile, "vehicle.animation#animationClip"));
            if self.animation.clip >= 0 then
                assignAnimTrackClip(self.animation.animCharSet, 0, self.animation.clip);
                setAnimTrackLoopState(self.animation.animCharSet, 0, true);
            end;
        end;
    end;
end;

function piston:delete()
end;

function piston:update(dt)
    if self.isMotorStarted then
        local rot = ((self.lastSpeedReal * 40) * self.movingDirection * dt);
        if self.movingDirection == 0 then
            enableAnimTrack(self.animation.animCharSet, 0);
            setAnimTrackSpeedScale(self.animation.animCharSet, 0, math.max(rot, .8));
        elseif self.movingDirection > 0 then 
            setAnimTrackSpeedScale(self.animation.animCharSet, 0, math.max(rot, 1));
        elseif self.movingDirection < 0 then
            setAnimTrackSpeedScale(self.animation.animCharSet, 0, math.min(rot, -1));
        end;
    else --if not self.isMotorStarted then
        disableAnimTrack(self.animation.animCharSet, 0);
        self.animationEnabled = false;
    end;
end;

function piston:draw()
end;

function piston:onEnter()
end;

function piston:onLeave()
    if self.animationEnabled then
        disableAnimTrack(self.animation.animCharSet, 0);
        self.animationEnabled = false;
    end;
end;

function piston:keyEvent(unicode, sym, modifier, isDown)
end;

function piston:mouseEvent(posX, posY, isDown, isUp, button)
end;
