
lever = {};

function lever.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function lever:load(xmlFile) 
    -- lever
    self.lever = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lever#index"));
    self.lever2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cantalever#index"));
    self.lever3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rod1#index"));
    self.lever4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rod2#index"));
end;

function lever:delete()
end;

function lever:update()
    if self.isMotorStarted then
        if self.movingDirection == 0 then
            setRotation(self.lever, -.25, 0, 0);
            setRotation(self.lever2, .15, 0, 0);
            setRotation(self.lever3, .04, 0, 0);
            setTranslation(self.lever3, -.03619, 1.87, -2.50);
            setRotation(self.lever4, .07, 0, 0);
            setTranslation(self.lever4, -.07629, 2.44, -1.2);
        elseif self.movingDirection > 0 then
            setRotation(self.lever, -.45, 0, 0);
            setRotation(self.lever2, .3, 0, 0);
            setRotation(self.lever3, .08, 0, 0);
            setTranslation(self.lever3, -.03619, 1.94, -2.52);
            setRotation(self.lever4, .07, 0, 0);
            setTranslation(self.lever4, -.07629, 2.42, -1.12);
        else --if self.movingDirection < 0 then
            setRotation(self.lever, -.65, 0, 0);
            setRotation(self.lever2, .5, 0, 0);
            setRotation(self.lever3, .1, 0, 0);
            setTranslation(self.lever3, -.03619, 1.98, -2.553);
            setRotation(self.lever4, .07, 0, 0);
            setTranslation(self.lever4, -.07629, 2.4, -1.05);
        end;
    else
        setRotation(self.lever, 0, 0, 0);
        setRotation(self.lever2, 0, 0, 0);
        setRotation(self.lever3, 0, 0, 0);
        setTranslation(self.lever3, -.03619, 1.83237, -2.48411);
        setRotation(self.lever4, .075, 0, 0);
        setTranslation(self.lever4, -.07629, 2.46035, -1.28625);
    end;
end;

function lever:draw()
end;

function lever:onEnter()
end;

function lever:onLeave()
end;

function lever:keyEvent(unicode, sym, modifier, isDown)
end;

function lever:mouseEvent(posX, posY, isDown, isUp, button)
end;
