
TerraTrac = {};

function TerraTrac.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function TerraTrac:load(xmlFile)
    self.numTerraTrackWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.TerraTrackWheels#count"), 0);
    self.TerraTracks = {};
    for i=1, self.numTerraTrackWheels do
        local TerraTracksnamei = string.format("vehicle.TerraTrackWheels.TTWheel" .. "%d", i);
        self.TerraTracks[i] = {};
        self.TerraTracks[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, TerraTracksnamei .. "#index"));
        self.TerraTracks[i].refWheel = Utils.getNoNil(getXMLInt(xmlFile,  TerraTracksnamei .. "#referenceWheel"), 1);
    end;

    self.terraL = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TracBodyLeft#index"));
    self.terraR = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TracBodyRight#index"));

    self.txL, self.tyL, self.tzL = getTranslation(self.terraL);
    self.txR, self.tyR, self.tzR = getTranslation(self.terraR);
    self.wxL, self.wyL, self.wzL = getTranslation(self.wheels[3].repr);
    self.wxR, self.wyR, self.wzR = getTranslation(self.wheels[4].repr);
    self.deltaLwy = self.tyL - self.wyL;
    self.deltaRwy = self.tyR - self.wyR;
end;

function TerraTrac:delete()
end;

function TerraTrac:update()
    for i=1, self.numTerraTrackWheels do
        local q = self.TerraTracks[i].refWheel
        local x,y,z = getRotation(self.wheels[q].repr);
        local TTWheel = self.TerraTracks[i].index;
        setRotation(TTWheel, x,y,z);
    end;
end;

function TerraTrac:draw()
end;

function TerraTrac:onEnter()
end;

function TerraTrac:onLeave()
end;

function TerraTrac:keyEvent(unicode, sym, modifier, isDown)
end;

function TerraTrac:mouseEvent(posX, posY, isDown, isUp, button)
end;
