--
-- Author: Decker_MMIV
--

TLlowering = {};

function TLlowering.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function TLlowering:load(xmlFile)
    self.isLowered = Utils.overwrittenFunction(self.isLowered, TLlowering.isLowered);
    
    self.getIsPloughRotationAllowed = SpecializationUtil.callSpecializationsFunction("getIsPloughRotationAllowed");

    -- Support for trailed-Plough lowering, when contactReportNode is NEVER touching terrain, so only using groundReferenceNode,
    -- by dynamically altering its groundReferenceThreshold depending on when lowered/raised.
    self.groundReferenceThresholdRaised = self.groundReferenceThreshold;
    self.groundReferenceThresholdLowered = getXMLFloat(xmlFile, "vehicle.groundReferenceNode#thresholdLowered");
end;

function TLlowering:delete()
end;

function TLlowering:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TLlowering:keyEvent(unicode, sym, modifier, isDown)
end;

function TLlowering:readStream(streamId, connection)
end;

function TLlowering:writeStream(streamId, connection)
end;

function TLlowering:readUpdateStream(streamId, timestamp, connection)
end;
  
function TLlowering:writeUpdateStream(streamId, connection, dirtyMask)
end;

function TLlowering:update(dt)
    if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
            if self.attacherVehicle.selectedImplement.object == self and self.allowsLowering then
                local jointDesc = self.attacherVehicle.attacherJoints[self.attacherVehicle.selectedImplement.jointDescIndex];
                self.attacherVehicle:setJointMoveDown(self.attacherVehicle.selectedImplement.jointDescIndex, not jointDesc.moveDown, false);
            end;
        end
    end;
end;

function TLlowering:updateTick(dt)
    if self.groundReferenceThresholdLowered ~= nil then
        self.groundReferenceThreshold = Utils.getMovedLimitedValue(self.groundReferenceThreshold, self.groundReferenceThresholdRaised, self.groundReferenceThresholdLowered, 1000, dt, self:isLowered(false));
    end
end

function TLlowering:draw()
    if g_currentMission.showHelpText then
        if self.attacherVehicle ~= nil and self.attacherVehicle.selectedImplement.object == self and self.allowsLowering then
            local jointDesc = self.attacherVehicle.attacherJoints[self.attacherVehicle.selectedImplement.jointDescIndex];
            if not jointDesc.moveDown then
                g_currentMission:addHelpButtonText(string.format(g_i18n:getText("lift_OBJECT"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
            elseif self.needsLowering then
                g_currentMission:addHelpButtonText(string.format(g_i18n:getText("lower_OBJECT"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
            end;
        end;
    end;
end;

function TLlowering:isLowered(superFunc, default)
    if self.attacherVehicle ~= nil then
        local implement = self.attacherVehicle:getImplementByObject(self);
        if implement ~= nil then
            local jointDesc = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
            if implement.object.allowsLowering then
                return not jointDesc.moveDown; -- and self.attacherVehicle:isLowered(true);
            end;
        end;
    end;
    return default;
end;

function TLlowering:getIsPloughRotationAllowed()
    return false;
end
