-- by modelleicher
-- www.schwabenmodding.bplaced.net
-- date 15.07.2013 
-- set visibility of an x amount of twinwheels true/false and saves the state in the savegame, so at game restart the state is the same as at save
-- version 1  (released with Schlueter Super 1250VL LS Special)
-- version 1.1 (for MoreRealistic Use, released with Schlueter Super 1250VL LS Special MR) date 20.02.2014 

twinwheels = {};

function twinwheels.prerequisitesPresent(specializations)
    return true;
end;

function twinwheels:load(xmlFile)
	self.changeTwinState = twinwheels.changeTwinState;
	self.tyreGripFXTW = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.twinwheels#tyreGripFXwithTwinwheelsOn"), 1.2);	-- MR Version 
	self.tyreGripFXTWBackup = self.realTyreGripFx; -- backup normal tyre grip fx
	self.twinwheels = {};
	self.twinwheelsCnt = getXMLInt(xmlFile, "vehicle.twinwheels#count");
	if self.twinwheelsCnt ~= nil and self.twinwheelsCnt > 0 then
		for i=1, self.twinwheelsCnt do
			local index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.twinwheels.twinwheel"..i.."#index"));
			if index ~= "" and index ~= nil then
				table.insert(self.twinwheels, index);
			end;
		end;
	end;
	self.twinState = false;
	self:changeTwinState(self.twinState);
end;
function twinwheels:readStream(streamId, connection)  
     self:changeTwinState(streamReadBool(streamId), true);  
end;
function twinwheels:writeStream(streamId, connection)  
    streamWriteBool(streamId, self.twinState);  
end;
function twinwheels:delete()
end;
function twinwheels:mouseEvent(posX, posY, isDown, isUp, button)
end;
function twinwheels:keyEvent(unicode, sym, modifier, isDown)
end;
function twinwheels:changeTwinState(state, noEventSend)
	changeTwinStateEvent.sendEvent(self, state, noEventSend);
	self.twinState = state;
	for i=1, self.twinwheelsCnt do
		setVisibility(self.twinwheels[i], state);
	end;
	if state then -- addet for MR version, more grip if twinwheels are on
		self.realTyreGripFx = self.tyreGripFXTW;
	else
		self.realTyreGripFx = self.tyreGripFXTWBackup;
	end;
end;

function twinwheels:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.ToggleTwinWheels) then
			self:changeTwinState(not self.twinState);
		end;
	end;
end;
function twinwheels:draw()
	g_currentMission:addHelpButtonText(g_i18n:getText("ToggleTwinWheels"), InputBinding.ToggleTwinWheels);
end;
function twinwheels:onEnter()
end;
function twinwheels:onLeave()
end;

function twinwheels:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local state = Utils.getNoNil(getXMLBool(xmlFile, key.."#twinState"));
		self:changeTwinState(state);
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function twinwheels:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'twinState="'..tostring(self.twinState)..'"';
	local nodes = nil;
	return attributes,nodes;
end;



changeTwinStateEvent = {};
changeTwinStateEvent_mt = Class(changeTwinStateEvent, Event);
InitEventClass(changeTwinStateEvent, "changeTwinStateEvent");

function changeTwinStateEvent:emptyNew()  
    local self = Event:new(changeTwinStateEvent_mt );
    self.className="changeTwinStateEvent";
    return self;
end;
function changeTwinStateEvent:new(vehicle, state) 
    self.vehicle = vehicle;
    self.state = state;
    return self;
end;
function changeTwinStateEvent:readStream(streamId, connection)  
    local id = streamReadInt32(streamId); 
    self.state = streamReadBool(streamId); 
    self.vehicle = networkGetObject(id); 
    self:run(connection);  
end;
function changeTwinStateEvent:writeStream(streamId, connection)   
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
    streamWriteBool(streamId, self.state );   
end;
function changeTwinStateEvent:run(connection) 
    self.vehicle:changeTwinState(self.state, true);
	if not connection:getIsServer() then  
		g_server:broadcastEvent(changeTwinStateEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;
function changeTwinStateEvent.sendEvent(vehicle, state, noEventSend)  
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then   
			g_server:broadcastEvent(changeTwinStateEvent:new(vehicle, state), nil, nil, vehicle);
		else 
			g_client:getServerConnection():sendEvent(changeTwinStateEvent:new(vehicle, state));
		end;
	end;
end;