trackSound = {}

function trackSound.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function trackSound:load(xmlFile)


	  local trackSound = getXMLString(xmlFile, "vehicle.trackSound#file");
          if trackSound ~= nil and trackSound ~= "" then
          trackSound = Utils.getFilename(trackSound, self.baseDirectory);
          self.trackSound = createSample("trackSound");
          self.trackSoundEnabled = false;
          loadSample(self.trackSound, trackSound, false);
          self.trackSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.trackSound#pitchOffset"), 1);
		  self.trackSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.trackSound#pitchScale"), 1);
		  self.trackSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.trackSound#pitchMax"), 1);
          self.trackSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.trackSound#volume"), 1);
		  self.soundSpeed = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.trackSound#soundSpeed"), 1);
		  self.reverseTrackSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.reverseTrackSound#pitchOffset"), 1);
		  self.reverseTrackSoundPitchScale  = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.reverseTrackSound#pitchScale"), 1);
		  self.reverseTrackSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.reverseTrackSound#pitchMax"), 1);
		  self.reverseTrackSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.reverseTrackSound#volume"), 1);
          setSamplePitch(self.trackSound, self.trackSoundPitch);
          setSamplePitch(self.reverseTrackSound, self.reverseTrackSoundPitch);		 


      else
          self.trackSoundPitch = 1;
          self.trackSoundVolume = 1;





     end;
			local reverseTrackSound = getXMLString(xmlFile, "vehicle.reverseTrackSound#file");
					if reverseTrackSound ~= nil and reverseTrackSound ~= "" then
            		reverseTrackSound = Utils.getFilename(reverseTrackSound, self.baseDirectory);
					self.reverseTrackSound = createSample("reverseTrackSound");
					self.reverseTrackSoundEnabled = false;
					loadSample(self.reverseTrackSound, reverseTrackSound, false);
					self.reverseTrackSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.reverseTrackSound#volume"), 1.0);
      end;

			local trackSound = getXMLString(xmlFile, "vehicle.trackSound#file");
					if trackSound ~= nil and trackSound ~= "" then
            		trackSound = Utils.getFilename(trackSound, self.baseDirectory);
					self.trackSound = createSample("trackSound");
					self.trackSoundEnabled = false;
					loadSample(self.trackSound, trackSound, false);
				    self.trackSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.trackSound#volume"), 1.0);
      end;
end;

function trackSound:delete()
      if self.trackSound ~= nil then
          delete(self.trackSound);
			self.trackSound = nil;
			end;
	  if self.reverseTrackSound ~= nil then
          delete(self.reverseTrackSound);
		  			self.reverseTrackSound = nil;
         end;



end;

 


function trackSound:update(dt)
		    local trackPitch = (self.lastSpeed*self.speedDisplayScale*3600)
             if self.trackSound ~= nil then
                
				 local trackSoundPitch = (trackPitch*.5)
				 end;
				 
		if self.isMotorStarted then
         if self:getIsActiveForSound() then
          if self.reverseTrackSound ~= nil then
             local isDrivingBackwards = (self.movingDirection < 0);
             if self.movingDirection ~= nil then
                  if self.movingDirection >= 0 then
                      isDrivingBackwards = false;
                 end;
             end;
				if isDrivingBackwards then
                 if not self.reverseTrackSoundEnabled and self:getIsActiveForSound() then
                     playSample(self.reverseTrackSound, 0, self.reverseTrackSoundVolume, 0);
				local trackSoundPitch = (trackPitch*.5)
                setSamplePitch(self.trackSound, trackSoundPitch);
                      self.reverseTrackSoundEnabled = true;
                  end;
             else
                 if self.reverseTrackSoundEnabled then
                     stopSample(self.reverseTrackSound);
                     self.reverseTrackSoundEnabled = false;
                 end;
              end;
			  
end;
end;
end;


	 if self.isMotorStarted and self.movingDirection > 0 and not self.trackSoundEnabled and self:getIsActiveForSound() then
		playSample(self.trackSound, 0, self.trackSoundVolume, 0);
                 self.trackSoundEnabled = true;
            end;
			

			
            local trackPitch = (self.lastSpeed*self.speedDisplayScale*3600)
             if self.trackSound ~= nil then
                 --local trackSoundPitch = math.min(self.trackSoundPitchOffset + self.trackSoundPitchScale*math.abs(trackPitch), self.trackSoundPitchMax)
				 local trackSoundPitch = (trackPitch*.1)
                setSamplePitch(self.trackSound, trackSoundPitch);
				 end;
				 
				 
				if self.trackSoundEnabled and self.isMotorStarted and self.movingDirection <= 0 then
                 stopSample(self.trackSound);
                 self.trackSoundEnabled = false;
			end;
		

end;
function trackSound:stopSounds()
		if self.isClient then
          if self.trackSound ~= nil then
              stopSample(self.trackSound);
              self.trackSoundEnabled = false;
         end;
		 		if self.isClient then
          if self.reverseTrackSound ~= nil then
              stopSample(self.reverseTrackSound);
              self.reverseTrackSoundEnabled = false;
         end;
		 end;
end;
end;
function trackSound:draw()
end;

function trackSound:onEnter()
end;

function trackSound:onLeave()
      if self.trackSoundEnabled then
          stopSample(self.trackSound);
          self.trackSoundEnabled = false;
      end;
	        if self.reverseTrackSoundEnabled then
          stopSample(self.reverseTrackSound);
          self.reverseTrackSoundEnabled = false;
      end;
end;

function trackSound:keyEvent(unicode, sym, modifier, isDown)
end;

function trackSound:mouseEvent(posX, posY, isDown, isUp, button)
end;

function trackSound:onDeactivateSounds()
      if self.trackSoundEnabled then
          stopSample(self.trackSound);
          self.trackSoundEnabled = false;
      end;
	        if self.reverseTrackSoundEnabled then
          stopSample(self.reverseTrackSound);
          self.reverseTrackSoundEnabled = false;
      end;
  end;
