--
-- BuyableWheelsAttacher
-- Specialization for BuyableWheelsAttacher
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  23/04/10
--
-- Edited for use with all wheels
-- @edit JoXXer
-- @date 06/11/11

BuyableWheelsAttacher = {};

function BuyableWheelsAttacher.prerequisitesPresent(specializations)
    return true;
end;

function BuyableWheelsAttacher:load(xmlFile)

	self.onAssembling = SpecializationUtil.callSpecializationsFunction("onAssembling");
	self.onDisassembling = SpecializationUtil.callSpecializationsFunction("onDisassembling");

	self.buyableWheels = {};
	self.buyableWheels.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#buyableWheelsCheckString"), "standart");

	-- Rear dual wheels
	self.buyableWheels.rearDualWheels = nil;
	self.buyableWheels.rearDualwheelsInRange = nil;
	-- Front dual wheels
	self.buyableWheels.frontDualWheels = nil;
	self.buyableWheels.frontDualwheelsInRange = nil;
	
	self.hasAttachedDuals = false;
end;

function BuyableWheelsAttacher:delete()
	if self.buyableWheels.rearDualWheels ~= nil then
		self.buyableWheels.rearDualWheels:disassembleWheels(self.buyableWheels);
	end;
	if self.buyableWheels.frontDualWheels ~= nil then
		self.buyableWheels.frontDualWheels:disassembleWheels(self.buyableWheels);
	end;
end;

function BuyableWheelsAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BuyableWheelsAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function BuyableWheelsAttacher:update(dt)

	if self:getIsActive() then

		local wheels = self.buyableWheels;

		if wheels.rearDualwheelsInRange ~= nil then
			if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.BUYABLE_REARDUALWHEELS_ATTACH) then
					if wheels.rearDualWheels == nil then
						wheels.rearDualwheelsInRange:assembleWheels(self);
					else
						if wheels.rearDualwheelsInRange.rearDualWheelsUser == self and wheels.frontDualWheels == nil then
							wheels.rearDualwheelsInRange:disassembleWheels(self);
						end;
					end;
				end;
			end;
		end;

		if wheels.frontDualwheelsInRange ~= nil then
			if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.BUYABLE_FRONTDUALWHEELS_ATTACH) then
					if wheels.frontDualWheels == nil and wheels.rearDualWheels ~= nil then
						wheels.frontDualwheelsInRange:assembleWheels(self);
					else
						if wheels.frontDualwheelsInRange.frontDualWheelsUser == self then
							wheels.frontDualwheelsInRange:disassembleWheels(self);
						end;
					end;
				end;
			end;
		end;
	end;
end;

function BuyableWheelsAttacher:draw()
	local wheels = self.buyableWheels;

	if wheels.rearDualwheelsInRange ~= nil then
		if wheels.rearDualWheels ~= nil then
			if wheels.rearDualwheelsInRange.rearDualWheelsUser == self and wheels.frontDualWheels == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BUYABLE_REARDUALWHEELS_DETACH"), InputBinding.BUYABLE_REARDUALWHEELS_ATTACH);
			end;
		else
			if wheels.rearDualwheelsInRange.rearDualWheelsUser == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BUYABLE_REARDUALWHEELS_ATTACH"), InputBinding.BUYABLE_REARDUALWHEELS_ATTACH);
			end;
		end;
	end;

	if wheels.frontDualwheelsInRange ~= nil and wheels.rearDualWheels ~= nil then
		if wheels.frontDualWheels ~= nil then
			if wheels.frontDualwheelsInRange.frontDualWheelsUser == self then
				g_currentMission:addHelpButtonText(g_i18n:getText("BUYABLE_FRONTDUALWHEELS_DETACH"), InputBinding.BUYABLE_FRONTDUALWHEELS_ATTACH);
			end;
		else
			if wheels.frontDualwheelsInRange.frontDualWheelsUser == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BUYABLE_FRONTDUALWHEELS_ATTACH"), InputBinding.BUYABLE_FRONTDUALWHEELS_ATTACH);
			end;
		end;
	end;
end;
function BuyableWheelsAttacher:onLeave()
	-- Set all wheels in range to nil, if the wheels are moved while not in the vehicle
	local wheels = self.buyableWheels;

	if wheels.rearDualwheelsInRange ~= nil then
		wheels.rearDualwheelsInRange = nil;
	end;

	if wheels.frontDualwheelsInRange ~= nil then
		wheels.frontDualwheelsInRange = nil;
	end;
end;
function BuyableWheelsAttacher:onAssembling(buyableWheels)

	if buyableWheels.rearDualWheelsUser ~= nil then
		self.buyableWheels.rearDualWheels = buyableWheels;
	
		if self.isRealistic then
			self.realVehicleFlotationFx = 1.25
		end;
	elseif buyableWheels.frontDualWheelsUser ~= nil then
		self.buyableWheels.frontDualWheels = buyableWheels;
		
		-- Adjust fenderAngle/fenderRotModifier to compensate for duals, if applicable
		if self.fenderAngle ~= nil then
			self.fenderAngle = self.fenderAngle + math.rad(5);
		end;
		if self.fenderRotModifier ~= nil then
			self.fenderRotModifier = self.fenderRotModifier + 2;
		end;
	
		if self.isRealistic then
			self.realVehicleFlotationFx = 1.40
		end;
	end;
	
	self.hasAttachedDuals = true;
end;

function BuyableWheelsAttacher:onDisassembling(buyableWheels)

	if buyableWheels.rearDualWheelsUser ~= nil then
		self.buyableWheels.rearDualWheels = nil;
	elseif buyableWheels.frontDualWheelsUser ~= nil then
		self.buyableWheels.frontDualWheels = nil;
		
		-- Reset fenderAngle/fenderRotModifier, if applicable
		if self.fenderAngle then
			self.fenderAngle = self.fenderAngle - math.rad(5);
		end;
		if self.fenderRotModifier ~= nil then
			self.fenderRotModifier = self.fenderRotModifier - 2;
		end;
	end;
end;
