BuyableWheelsAttachEvent = {};
BuyableWheelsAttachEvent_mt = Class(BuyableWheelsAttachEvent, Event);

InitEventClass(BuyableWheelsAttachEvent, "BuyableWheelsAttachEvent");

function BuyableWheelsAttachEvent:emptyNew()
    local self = Event:new(BuyableWheelsAttachEvent_mt);
    self.className="BuyableWheelsAttachEvent";
    return self;
end;

function BuyableWheelsAttachEvent:new(vehicle, attacherVehicle)
    local self = BuyableWheelsAttachEvent:emptyNew()
    self.vehicle = vehicle;
	self.attacherVehicle = attacherVehicle;
    return self;
end;

function BuyableWheelsAttachEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	local attacherId = streamReadInt32(streamId);
	self.attacherVehicle = networkGetObject(attacherId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function BuyableWheelsAttachEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt32(streamId, networkGetObjectId(self.attacherVehicle));
end;

function BuyableWheelsAttachEvent:run(connection)
	self.vehicle:assembleWheels(self.attacherVehicle, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(BuyableWheelsAttachEvent:new(self.vehicle, self.attacherVehicle), nil, connection, self.object);
    end;
end;


function BuyableWheelsAttachEvent.sendEvent(vehicle, attacherVehicle, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(BuyableWheelsAttachEvent:new(vehicle, attacherVehicle), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(BuyableWheelsAttachEvent:new(vehicle, attacherVehicle));
		end;
	end;
end;
