--Autor orginal: Face
--Edit Lechu & Aranea
--12.5.2014

RPMControl = {};

function RPMControl.prerequisitesPresent(specializations)
     return SpecializationUtil.hasSpecialization(Baler, specializations);
end; 

function RPMControl:load(xmlFile)
	self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
	self.saveMinRpm = 0;
end;

function RPMControl:delete()
end;

function RPMControl:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RPMControl:keyEvent(unicode, sym, modifier, isDown)
end;

function RPMControl:update(dt)
        if self.isTurnedOn then
                self:setVehicleRpmUp(dt, true);
        else
            self:setVehicleRpmUp(dt, false);
        end
        if self.isTurnedOn then
			self:setAnimationTime(1, 1);
		else
			self:setAnimationTime(1, 0);
end;
end;

function RPMControl:updateTick(dt)
		
end;

function RPMControl:draw()
end;

function RPMControl:onDetach()
    if self.deactivateOnDetach then
        RPMControl.onDeactivate(self);
    end;
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy == steerable then
			steerable.motor.minRpm = self.saveMinRpm;
			self.attacherVehicleCopy = nil;
		end;
	end;
end;

function RPMControl:onAttach(attacherVehicle)
	for k, steerable in pairs(g_currentMission.steerables) do
		if steerable == attacherVehicle then
			self.saveMinRpm = attacherVehicle.motor.minRpm;
			if self.attacherVehicleCopy == nil then
				self.attacherVehicleCopy = self.attacherVehicle;
			end;
		elseif steerable == attacherVehicle.attacherVehicle then
			self.saveMinRpm = attacherVehicle.attacherVehicle.motor.minRpm;
			if self.attacherVehicleCopy == nil then
				self.attacherVehicleCopy = attacherVehicle.attacherVehicle;
			end;
		end;
	end;
end;

function RPMControl:onLeave()
    if self.deactivateOnLeave then
        RPMControl.onDeactivate(self);
    end;
end;

function RPMControl:onDeactivate()
	self:setVehicleRpmUp(nil, false);
end;

function RPMControl:setVehicleRpmUp(dt, isActive)
	if self.attacherVehicleCopy ~= nil and self.saveMinRpm ~= 0 then
		if dt ~= nil then
			if isActive == true then
				self.attacherVehicleCopy.motor.minRpm = math.max(self.attacherVehicleCopy.motor.minRpm-(dt*5), -1400);
			else
				self.attacherVehicleCopy.motor.minRpm = math.min(self.attacherVehicleCopy.motor.minRpm+(dt*5), self.saveMinRpm);
			end;
		else
			self.attacherVehicleCopy.motor.minRpm = self.saveMinRpm;
		end;
		if self.attacherVehicleCopy.isMotorStarted then
			local fuelUsed = 0.0000011*math.abs(self.attacherVehicleCopy.motor.minRpm);
			self.attacherVehicleCopy:setFuelFillLevel(self.attacherVehicleCopy.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;
