--
-- PowerShaftAttacher
-- Specialization for PowerShaftAttacher
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--
-- @edit: Ziuta (Ziut), date: 18.06.2013
--  new: "shaftAttacher2", automatic installation
--
-- free for noncommerical-usage
--

PowerShaftAttacher = {};

function PowerShaftAttacher.prerequisitesPresent(specializations)
    return true;
end;

function PowerShaftAttacher:load(xmlFile)
	
	local i=0;
    while true do
        local baseName = string.format("vehicle.attacherJoints.attacherJoint(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;		
		local joint = self.attacherJoints[i+1];
		local shaftAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#shaft"));
		local shaftAttacher2 = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#ptoOutputNode"));
		if shaftAttacher2 ~= nil then
			joint.powerShaftAttacher = shaftAttacher2;
		elseif shaftAttacher ~= nil then
			joint.powerShaftAttacher = shaftAttacher;
		end;
		i = i + 1;
	end;

	local attacherJointCount = i;
	i = 0;
    while true do
        local baseName = string.format("vehicle.trailerAttacherJoints.trailerAttacherJoint(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;
		
		local joint = self.attacherJoints[attacherJointCount + 1 + i];
		local shaftAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#shaft"));
		local shaftAttacher2 = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#ptoOutputNode"));
		if shaftAttacher2 ~= nil then
			joint.powerShaftAttacher = shaftAttacher2;
		elseif shaftAttacher ~= nil then
			joint.powerShaftAttacher = shaftAttacher;
		end;
        i = i+1;
    end;	
end;

function PowerShaftAttacher:delete()
end;

function PowerShaftAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PowerShaftAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function PowerShaftAttacher:update(dt)
end;

function PowerShaftAttacher:draw()
end;