--
-- custom for marstonAceFenlander
--
-- @author:    	Xentro (www.fs-uk.com)(Marcus@Xentro.se)
-- @version:    v0.1
-- @date:       2013-11-22
-- 


marstonAceFenlander = {};

function marstonAceFenlander.prerequisitesPresent(specializations)
    return true;
end;

function marstonAceFenlander:load(xmlFile)
	self.setSheet = SpecializationUtil.callSpecializationsFunction("setSheet");
	
	self.sheet = {};
	self.sheet.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sheet#node"));
	self.sheet.node2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sheet#node2"));
	self.sheet.isActive = false;
	
end;

function marstonAceFenlander:delete()
end;

function marstonAceFenlander:readStream(streamId, connection)
	self:setSheet(streamReadBool(streamId), true);
end;

function marstonAceFenlander:writeStream(streamId, connection)
	streamWriteBool(streamId, self.sheet.isActive);
end;

function marstonAceFenlander:mouseEvent(posX, posY, isDown, isUp, button)
end;

function marstonAceFenlander:keyEvent(unicode, sym, modifier, isDown)
end;

function marstonAceFenlander:update(dt)
	if self:getIsActive() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHEET) then
			self:setSheet(not self.sheet.isActive);
		end;
	end;
end;

function marstonAceFenlander:updateTick(dt)
end;

function marstonAceFenlander:draw()
	if self.sheet.isActive then
		g_currentMission:addHelpButtonText(g_i18n:getText("UNSHEET"), InputBinding.TOGGLE_SHEET);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("SHEETOVER"), InputBinding.TOGGLE_SHEET);
	end;
end;

function marstonAceFenlander:setSheet(state, noEventSend)
	self.sheet.isActive = state;
	setVisibility(self.sheet.node, state);
	setVisibility(self.sheet.node2, not state);
	
	setSheetEvents.sendEvent(self, state, noEventSend)
end;


-- Event --
setSheetEvents = {};
setSheetEvents_mt = Class(setSheetEvents, Event);
  
InitEventClass(setSheetEvents, "setSheetEvents");
  
function setSheetEvents:emptyNew()
	local self = Event:new(setSheetEvents_mt);
	self.className = "setSheetEvents";
	
	return self;
end;
  
function setSheetEvents:new(object, sheet)
	local self = setSheetEvents:emptyNew()
	self.object = object;
	self.sheet = sheet;
	
	return self;
end;
  
function setSheetEvents:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.sheet = streamReadBool(streamId);
	self.object = networkGetObject(id);
	
	self:run(connection);
end;
  
function setSheetEvents:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.sheet);
end;
  
function setSheetEvents:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object);
	end;
	
	self.object:setSheet(self.sheet, true);
end;
  
function setSheetEvents.sendEvent(vehicle, sheet, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(setSheetEvents:new(vehicle, sheet), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(setSheetEvents:new(vehicle, sheet));
		end;
	end;
end;