
	

transmission_Sound = {};

function transmission_Sound.prerequisitesPresent(specializations) 
	return SpecializationUtil.hasSpecialization(RealisticMotorized, specializations);
end;

function transmission_Sound:load(xmlFile) 
	self.isRealistic = true;	
	self.hasTSound = false;
	local newRunSound = getXMLString(xmlFile, "vehicle.transmissionSounds.newRunSound#file");
	if newRunSound ~= nil and newRunSound ~= "" then 
		self.hasTSound = true;
		newRunSound = Utils.getFilename(newRunSound, self.baseDirectory);
		self.newRunSound = createSample("newRunSound");
		loadSample(self.newRunSound, newRunSound, false);
		self.newRunSoundPitch = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.transmissionSounds.newRunSound#pitch"), 1);
		self.newRunSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.transmissionSounds.newRunSound#pitchMax"), 1.4);
		self.newRunSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.transmissionSounds.newRunSound#volume"), 1.0);
		setSamplePitch(self.newRunSound, self.newRunSoundPitch);
		self.newRunSoundOn = nil;
		self.newRunSoundIsPlaying = false;
		
		self.timeOutVolume = self.newRunSoundVolume;
		self.newRunSoundLastVolume = self.newRunSoundVolume;
		
		self.srpms = {};
		self.srpms.min = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realManualTransmission.rpm#minRpm"), 550)
		self.srpms.max = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realManualTransmission.rpm#maxRpm"), 2000)

		local rpmRange = self.srpms.min / self.srpms.max - self.srpms.min -- 500
		local pitchRange = self.newRunSoundPitchMax - self.newRunSoundPitch; -- 1.1
		self.pitchPerRpm = pitchRange / rpmRange;
	end;
	
end;

function transmission_Sound:update(dt)
-- self.realMotorLoad  0 to 1 load of engine
	if self.hasTSound and self:getIsActive() and self.isMotorStarted then
		self.newRunSoundOn = true;
	else
		self.newRunSoundOn = false;
	end;
	if self.hasTSound then
		--if self.realMotorLoad > 0 then
		--	self.newRunSoundOn = true;
		--else
			--self.timeOutVolume = Utils.getNoNil(self.timeOutVolume, self.newRunSoundLastVolume) - 0.005*dt;
			--if self.timeOutVolume <= 0 then
			--	self.newRunSoundOn = false;
			--end;
		--	self.timeOutVolume = self.realMotorLoadS;
		--end;
		if self.newRunSoundOn and not self.newRunSoundIsPlaying then
			playSample(self.newRunSound, 0, 0.0, 0);
			self.newRunSoundIsPlaying = true;
			self.timeOutVolume = nil;
		elseif not self.newRunSoundOn and self.newRunSoundIsPlaying then
			stopSample(self.newRunSound);
			self.newRunSoundIsPlaying = false;
		end;
		if self:getIsActive() and self.isMotorStarted then
		if self.newRunSoundIsPlaying then
			local pitch = (RealisticUtils.linearFx(self.realSoundEngineRevFx, self.srpms.min, self.srpms.max) - self.srpms.min) * self.pitchPerRpm + self.newRunSoundPitch;
			local vol = self.newRunSoundVolume * (self.realMotorLoadS /2) ;
			setSampleVolume(self.newRunSound, vol);
			--renderText(0.1, 0.1, 0.021, "volume: "..tostring(vol));
			--renderText(0.1, 0.2, 0.021, "pitch: "..tostring(pitch));
			setSamplePitch(self.newRunSound, pitch);
			self.newRunSoundLasVolume = vol;

		end;
		end;
	end;

end;
function transmission_Sound:delete()    
end;
function transmission_Sound:mouseEvent(posX, posY, isDown, isUp, button)
end;
function transmission_Sound:keyEvent(unicode, sym, modifier, isDown)
end;

function transmission_Sound:updateTick(dt)
end;




function transmission_Sound:draw() 		
end;


