--
-- Ruefa
--
-- M@D Author:  Heady
-- M@D date: 21.06.2011
--
-- > Copyright (C) Heady - www.planet-ls.de < --
--
-- edit by modelleicher @05.04.2014
-- conversion to moreRealistic functionality

Ruefa = {};

function Ruefa.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function Ruefa:load(xmlFile)
	self.setRuefaState = Ruefa.setRuefaState;
	local Ruefa = {};
    Ruefa.name = getXMLString(xmlFile, "vehicle.Ruefa#name");
    Ruefa.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Ruefa#upSpeedScale"), 1);
    Ruefa.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Ruefa#downSpeedScale"), -Ruefa.openSpeedScale);
    if Ruefa.name ~= nil then
        self.Ruefa = Ruefa;
		self.Ruefa.active = false;	
		self.RuefaActive = false;
	
		self.Ruefa.characterTransform = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Ruefa#characterTransform"));	
		self.Ruefa.characterTransformArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Ruefa#characterTransformArm"));	
    else
		print("No Ruefa animation specified in XML File, ruefa script won't work without animation"); -- error message just in case
	end;
end;

function Ruefa:delete()
end;
function Ruefa:mouseEvent(posX, posY, isDown, isUp, button)
end;
function Ruefa:keyEvent(unicode, sym, modifier, isDown)
end;
function Ruefa:readStream(streamId, connection)	
	self.Ruefa.active = streamReadBool(streamId);
end;
function Ruefa:writeStream(streamId, connection)
	streamWriteBool(streamId, self.Ruefa.active);
end;

function Ruefa:update(dt)
	if self:getIsActiveForInput() then			
		if InputBinding.hasEvent(InputBinding.RuefaOnOffTrac) then
			self:setRuefaState(not self.Ruefa.active)
			
		end;		
	end;	
end;
function Ruefa:setRuefaState(state, noEventSend)
	mrRuefaStateEvent.sendEvent(self, state, noEventSend);
	self.Ruefa.active = not self.Ruefa.active;
end;

function Ruefa:updateTick(dt)
	if self:getIsActive() then -- for performance reasons.. no need to loop through this if vehicle isn't active 
		if self.RuefaActive ~= self.Ruefa.active then		
			if self.Ruefa.active then
				self:playAnimation(self.Ruefa.name, self.Ruefa.openSpeedScale, self:getAnimationTime(self.Ruefa.name));
				 -- changes for moreRealistic:
				self.realReverseDrivingModeEngaged = true;
				self.steeringSpeed = - self.steeringSpeed;
			else	
				self:playAnimation(self.Ruefa.name, self.Ruefa.closeSpeedScale, self:getAnimationTime(self.Ruefa.name)); 
				 -- changes for moreRealistic:
				self.realReverseDrivingModeEngaged = false;
				self.steeringSpeed = - self.steeringSpeed;			
			end;		
		end;
		if self:getIsAnimationPlaying(self.Ruefa.name) then
			local state;
			setVisibility(self.Ruefa.characterTransform, state);
			setVisibility(self.Ruefa.characterTransformArm, state);
		else
			setVisibility(self.Ruefa.characterTransform, true);
			setVisibility(self.Ruefa.characterTransformArm, true);
		end;
		self.RuefaActive = self.Ruefa.active;
	end;
end;
function Ruefa:onLeave()
	setVisibility(self.Ruefa.characterTransformArm, false);
end;
function Ruefa:draw()	
	if self:getIsActiveForInput() then
		g_currentMission:addHelpButtonText(g_i18n:getText("RuefaOnOffTrac"), InputBinding.RuefaOnOffTrac);
	end;
end;


mrRuefaStateEvent = {};
mrRuefaStateEvent_mt = Class(mrRuefaStateEvent, Event);
InitEventClass(mrRuefaStateEvent, "mrRuefaStateEvent");

function mrRuefaStateEvent:emptyNew()  
    local self = Event:new(mrRuefaStateEvent_mt );
    self.className="mrRuefaStateEvent";
    return self;
end;
function mrRuefaStateEvent:new(vehicle, state) 
    self.vehicle = vehicle;
    self.state = state;
    return self;
end;
function mrRuefaStateEvent:readStream(streamId, connection)  
    local id = streamReadInt32(streamId); 
    self.state = streamReadBool(streamId); 
    self.vehicle = networkGetObject(id); 
    self:run(connection);  
end;
function mrRuefaStateEvent:writeStream(streamId, connection)   
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
    streamWriteBool(streamId, self.state );   
end;
function mrRuefaStateEvent:run(connection) 
    self.vehicle:setRuefaState(self.state, true);
	if not connection:getIsServer() then  
		g_server:broadcastEvent(mrRuefaStateEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;
function mrRuefaStateEvent.sendEvent(vehicle, state, noEventSend)  
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then   
			g_server:broadcastEvent(mrRuefaStateEvent:new(vehicle, state), nil, nil, vehicle);
		else 
			g_client:getServerConnection():sendEvent(mrRuefaStateEvent:new(vehicle, state));
		end;
	end;
end;